package jp.co.sra.jun.opengl.display;

import java.awt.Color;
import java.awt.Dimension;

import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.WindowSpecLayout;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.goodies.utilities.JunSensorUtility;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.support.JunGLCanvas;
import jp.co.sra.jun.opengl.support.JunGLJPanel;
import jp.co.sra.jun.opengl.support.JunOpenGLDrawable;
import jp.co.sra.jun.opengl.support.JunOpenGLResource;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;

/**
 * JunOpenGL3dModelTestExamples class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   2000/01/06 (by MATSUDA Ryouichi)
 *  @updated   2007/08/17 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun696 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGL3dModelTestExamples.java,v 8.14 2008/02/20 06:32:18 nisinaka Exp $
 */
public class JunOpenGL3dModelTestExamples extends jp.co.sra.jun.system.support.JunTestExamples {

	/**
	 * Example:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example() {
		JunOpenGL3dModel anOpenGLModel = JunSensorUtility.ShiftDown() ? new TestJunOpenGLModel() : new JunOpenGL3dModel();
		anOpenGLModel.open();

		return true;
	}

	/**
	 * Example8:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example8() {
		JunOpenGL3dModel anOpenGLModel = JunSensorUtility.ShiftDown() ? new TestJunOpenGLModel() : new JunOpenGL3dModel();
		anOpenGLModel.openGL3dObject_(C6H6());
		anOpenGLModel.viewFactor_(1.2);
		anOpenGLModel.open();

		return true;
	}

	/**
	 * Example_backgroundColor : 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_backgroundColor() {
		JunOpenGL3dModel anOpenGLModel = JunSensorUtility.ShiftDown() ? new TestJunOpenGLModel() : new JunOpenGL3dModel();
		anOpenGLModel.openGL3dObject_(C6H6());
		anOpenGLModel.viewFactor_(1.2);
		anOpenGLModel.backgroundColor_(Color.black);
		anOpenGLModel.open();

		return true;
	}

	/**
	 * Create a sample object.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGL3dObject
	 * @category Private
	 */
	protected static JunOpenGL3dObject C6H6() {
		JunOpenGL3dObject aC = JunOpenGL3dObject.Globe_(30);
		aC.paint_(new Color(127, 127, 255));

		JunOpenGL3dObject aH = aC.transform_(Jun3dTransformation.Scale_(0.6));
		aH = aH.transform_(Jun3dTransformation.Translate_(new Jun3dPoint(0.75, 0, 0)));
		aH.paint_(new Color(127, 255, 127));

		JunOpenGL3dObject aCH = new JunOpenGL3dCompoundObject(aH, aC);
		aCH = aCH.transform_(Jun3dTransformation.Translate_(new Jun3dPoint(0.75, 0, 0)));

		JunOpenGL3dCompoundObject displayObject = new JunOpenGL3dCompoundObject();
		for (int each = 60; each <= 360; each += 60) {
			Jun3dTransformation aT = Jun3dTransformation.Rotate_(JunAngle.FromDeg_(each));
			displayObject.add_(aCH.transform_(aT));
		}
		displayObject.name_("benzene");

		return displayObject;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunOpenGL3dModelTestExamples();
	}

	///
	static class TestJunOpenGLModel extends JunOpenGL3dModel {
		public StView defaultView() {
			return new JunAbstractViewJPanel(this) {
				protected void initialize() {
					super.initialize();
					this.setLightWeightPopupEnabled(false);
				}

				protected void buildComponent() {
					this.setLayout(new WindowSpecLayout());
					this.add(new JunOpenGL3dViewAwt(this.getOpenGLModel()) {
						protected JunOpenGLDrawable createOpenGLDrawable() {
							return new JunGLCanvas(getOpenGLModel());
						}
					}, WindowSpecLayout.Position(0f, 0, 0f, 0, 0.5f, 0, 0.5f, 0));

					this.add(new JunOpenGL3dViewSwing(this.getOpenGLModel()) {
						protected JunOpenGLDrawable createOpenGLDrawable() {
							return new JunGLJPanel(getOpenGLModel());
						}
					}, WindowSpecLayout.Position(0.5f, 0, 0f, 0, 1f, 0, 0.5f, 0));

					if (JunOpenGLResource.GetJOGLCanvasClass() != null) {
						this.add(new JunOpenGL3dViewAwt(this.getOpenGLModel()) {
							protected JunOpenGLDrawable createOpenGLDrawable() {
								JunOpenGLDrawable aDrawable = null;
								try {
									aDrawable = (JunOpenGLDrawable) JunOpenGLResource.GetJOGLCanvasClass().newInstance();
									aDrawable.setRenderer(getOpenGLModel());
								} catch (InstantiationException e) {
									e.printStackTrace();
								} catch (IllegalAccessException e) {
									e.printStackTrace();
								}
								return aDrawable;
							}
						}, WindowSpecLayout.Position(0f, 0, 0.5f, 0, 0.5f, 0, 1f, 0));
					}

					if (JunOpenGLResource.GetJOGLJPanelClass() != null) {
						this.add(new JunOpenGL3dViewSwing(this.getOpenGLModel()) {
							protected JunOpenGLDrawable createOpenGLDrawable() {
								JunOpenGLDrawable aDrawable = null;
								try {
									aDrawable = (JunOpenGLDrawable) JunOpenGLResource.GetJOGLJPanelClass().newInstance();
									aDrawable.setRenderer(getOpenGLModel());
								} catch (InstantiationException e) {
									e.printStackTrace();
								} catch (IllegalAccessException e) {
									e.printStackTrace();
								}
								return aDrawable;
							}
						}, WindowSpecLayout.Position(0.5f, 0, 0.5f, 0, 1f, 0, 1f, 0));
					}

					this.setPreferredSize(new Dimension(600, 600));
				}

				public JunOpenGL3dModel getOpenGLModel() {
					return (JunOpenGL3dModel) this.model();
				}

				public void update_(DependentEvent evt) {
					//
				}
			};
		}
	}

}
