package jp.co.sra.jun.opengl.display;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.Map.Entry;

import javax.swing.JPanel;

import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StApplicationModel;
import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.StModel;
import jp.co.sra.smalltalk.menu.StMenuBar;
import jp.co.sra.smalltalk.menu.StMenuBarView;
import jp.co.sra.smalltalk.menu.StPopupMenu;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.opengl.support.JunOpenGLDrawable;

/**
 * JunOpenGL3dViewWrapper class
 * 
 *  @author    nisinaka
 *  @created   2007/08/27 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun623 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGL3dViewWrapper.java,v 8.6 2008/02/20 06:32:18 nisinaka Exp $
 */
public class JunOpenGL3dViewWrapper implements JunOpenGL3dView {

	protected JunOpenGL3dView openGL3dView;

	/**
	 * Create a new instance of JunOpenGL3dViewWrapper and initialize it.
	 *
	 * @param anOpenGL3dView jp.co.sra.jun.opengl.display.JunOpenGL3dView
	 * @category Instance creation
	 */
	public JunOpenGL3dViewWrapper(JunOpenGL3dView anOpenGL3dView) {
		openGL3dView = anOpenGL3dView;
	}

	/**
	 * Release the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StView#release()
	 * @category initialize-release
	 */
	public void release() {
		openGL3dView.release();
	}

	/**
	 * Answer my model as JunOpenGL3dModel.
	 * 
	 * @return jp.kidresearch.art.opengl.JunOpenGL3dModel
	 * @see jp.co.sra.jun.opengl.display.JunOpenGL3dView#getOpenGL3dModel()
	 * @category model accessing
	 */
	public JunOpenGL3dModel getOpenGL3dModel() {
		return openGL3dView.getOpenGL3dModel();
	}

	/**
	 * Answer my model.
	 * 
	 * @return jp.co.sra.smalltalk.StModel
	 * @see jp.co.sra.smalltalk.StView#model()
	 * @category model accessing
	 */
	public StModel model() {
		return openGL3dView.model();
	}

	/**
	 * Set my model.
	 * 
	 * @param newModel jp.co.sra.smalltalk.StModel
	 * @see jp.co.sra.smalltalk.StView#model_(jp.co.sra.smalltalk.StModel)
	 * @category model accessing
	 */
	public void model_(StModel newModel) {
		openGL3dView.model_(newModel);
	}

	/**
	 * Answer my OpenGL drawable.
	 * 
	 * @return jp.co.sra.jun.opengl.support.JunOpenGLDrawable
	 * @see jp.co.sra.jun.opengl.display.JunOpenGL3dView#getOpenGLDrawable()
	 * @category accessing
	 */
	public JunOpenGLDrawable getOpenGLDrawable() {
		return openGL3dView.getOpenGLDrawable();
	}

	/**
	 * Answer my controller.
	 * 
	 * @return jp.co.sra.smalltalk.StController
	 * @see jp.co.sra.smalltalk.StView#controller()
	 * @category controller accessing
	 */
	public StController controller() {
		return openGL3dView.controller();
	}

	/**
	 * Set my controller.
	 * 
	 * @param newController jp.co.sra.smalltalk.StController
	 * @see jp.co.sra.smalltalk.StView#controller_(jp.co.sra.smalltalk.StController)
	 * @category controller accessing
	 */
	public void controller_(StController newController) {
		openGL3dView.controller_(newController);
	}

	/**
	 * Convert the model points to the view 3D points sorted by Z.
	 * 
	 * @param modelPoints jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @return java.util.Map.Entry[]
	 * @see jp.co.sra.jun.opengl.display.JunOpenGL3dView#convertModelPointsToView3dPointsSortedByZ_(jp.co.sra.jun.geometry.basic.Jun3dPoint[])
	 * @category converting
	 */
	public Entry[] convertModelPointsToView3dPointsSortedByZ_(Jun3dPoint[] modelPoints) {
		return openGL3dView.convertModelPointsToView3dPointsSortedByZ_(modelPoints);
	}

	/**
	 * Answer the view as a java component.
	 *
	 * @return java.awt.Component
	 * @see jp.co.sra.smalltalk.StView#toComponent()
	 * @category converting
	 */
	public Component toComponent() {
		return this.getOpenGLDrawable().toComponent();
	}

	/**
	 * Answer the top component of the view.
	 *
	 * @return java.awt.Window
	 * @see jp.co.sra.smalltalk.StView#topComponent()
	 * @category user interface
	 */
	public Window topComponent() {
		return openGL3dView.topComponent();
	}

	/**
	 * Answer the bordered panel which contains the receiver.
	 *
	 * @return java.awt.Container
	 * @see jp.co.sra.smalltalk.StView#_onBorderedPanel()
	 * @category interface opening
	 */
	public Container _onBorderedPanel() {
		JPanel openGLDrawableOnBorderedPanel = StApplicationModel._JPanelWithBorder();
		openGLDrawableOnBorderedPanel.setLayout(new BorderLayout());
		openGLDrawableOnBorderedPanel.add(openGL3dView.getOpenGLDrawable().toComponent(), BorderLayout.CENTER);
		return openGLDrawableOnBorderedPanel;
	}

	/**
	 * Called when a changed method is invoked on a dependence.
	 * 
	 * @param e jp.co.sra.smalltalk.DependentEvent
	 * @see jp.co.sra.smalltalk.DependentListener#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @category updating
	 */
	public void update_(DependentEvent e) {
		openGL3dView.update_(e);
	}

	/**
	 * Set my popup menu view from the StPopupMenu.
	 * 
	 * @param aPopupMenu jp.co.sra.smalltalk.menu.StPopupMenu
	 * @see jp.co.sra.smalltalk.StView#popupMenu_(jp.co.sra.smalltalk.menu.StPopupMenu)
	 * @category popup menu
	 */
	public void popupMenu_(StPopupMenu aPopupMenu) {
		openGL3dView.popupMenu_(aPopupMenu);
	}

	/**
	 * Show the popup menu at the specified point on the view.
	 *
	 * @param x int
	 * @param y int
	 * @see jp.co.sra.smalltalk.StView#_showPopupMenu(int, int)
	 * @category popup menu
	 */
	public void _showPopupMenu(int x, int y) {
		openGL3dView._showPopupMenu(x, y);
	}

	/**
	 * Create my menu bar view.
	 * My subclasses may override this method to change properties of the menu.
	 * 
	 * @param aMenuBar jp.co.sra.smalltalk.menu.StMenuBar
	 * @return jp.co.sra.smalltalk.menu.StMenuBarView
	 * @see jp.co.sra.smalltalk.StView#_createMenuBarView(jp.co.sra.smalltalk.menu.StMenuBar)
	 * @category resources
	 */
	public StMenuBarView _createMenuBarView(StMenuBar aMenuBar) {
		return openGL3dView._createMenuBarView(aMenuBar);
	}

	/**
	 * Set up the keyboard for the view on the window.
	 * 
	 * @param aWindow
	 * @see jp.co.sra.smalltalk.StView#_setupKeyboard(java.awt.Window)
	 * @category keyboard 
	 */
	public void _setupKeyboard(Window window) {
		// No keyboard handling.
	}

}
