package jp.co.sra.jun.opengl.display;

import java.awt.Dimension;

import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.WindowSpecLayout;

import jp.co.sra.jun.goodies.button.JunButtonViewAwt;
import jp.co.sra.jun.goodies.wheels.JunThumbWheelViewAwt;

/**
 * JunOpenGLDisplayViewAwt class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1999/06/02 (by MATSUDA Ryouichi)
 *  @updated   2003/01/09 (by nisinaka)
 *  @updated   2003/05/14 (by nisinaka)
 *  @updated   2004/09/21 (by nisinaka)
 *  @updated   2004/12/02 (by Mitsuhiro Asada)
 *  @updated   2007/08/23 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun475 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLDisplayViewAwt.java,v 8.18 2008/02/20 06:32:19 nisinaka Exp $
 */
public class JunOpenGLDisplayViewAwt extends JunOpenGL3dViewAwt implements JunOpenGLDisplayView {

	/**
	 * Create a new instance of JunOpenGLDisplayViewAwt and initialize it.
	 * 
	 * @param anOpenGLDisplayModel jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @category Instance creation
	 */
	public JunOpenGLDisplayViewAwt(JunOpenGLDisplayModel anOpenGLDisplayModel) {
		super(anOpenGLDisplayModel);
	}

	/**
	 * Create a new view for the JunOpenGLDisplayModel which does not contain any widgets.
	 * 
	 * @param anOpenGLDisplayModel jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @return jp.co.sra.smalltalk.StView
	 * @category Utilities
	 */
	public static StView WithoutWidgets(JunOpenGLDisplayModel anOpenGLDisplayModel) {
		return new JunOpenGLDisplayViewAwt(anOpenGLDisplayModel) {
			protected void buildComponent() {
				this.setLayout(new WindowSpecLayout());
				this.add(this.createOpenGLDrawableOnBorderedPanel(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -1, 1f, -1));
				this.setSize(new Dimension(300, 300));
			}
		};
	}

	/**
	 * Release the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#release()
	 * @category initialize-release
	 */
	public void release() {
		if (controller instanceof JunOpenGLDisplayController) {
			this.getOpenGLDisplayController().flushMovementVector();
		}

		super.release();
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.createOpenGLDrawableOnBorderedPanel(), WindowSpecLayout.Position(0f, 20, 0f, 1, 1f, -20, 1f, -20));
		this.add(new JunButtonViewAwt(this.getOpenGLDisplayModel().pickButton()), WindowSpecLayout.Position(0f, 1, 0f, 1, 0f, 19, 0f, 19));
		this.add(new JunButtonViewAwt(this.getOpenGLDisplayModel().grabButton()), WindowSpecLayout.Position(0f, 1, 0f, 20, 0f, 19, 0f, 38));
		this.add(new JunButtonViewAwt(this.getOpenGLDisplayModel().dragButton()), WindowSpecLayout.Position(0f, 1, 0f, 39, 0f, 19, 0f, 57));
		this.add(new JunThumbWheelViewAwt(this.getOpenGLDisplayModel().xThumbWheel()), WindowSpecLayout.Position(0f, 1, 0.5f, -61, 0f, 19, 0.5f, 61));
		this.add(new JunThumbWheelViewAwt(this.getOpenGLDisplayModel().yThumbWheel()), WindowSpecLayout.Position(0.5f, -61, 1f, -19, 0.5f, 61, 1f, -1));
		this.add(new JunThumbWheelViewAwt(this.getOpenGLDisplayModel().zThumbWheel()), WindowSpecLayout.Position(1f, -19, 0.5f, -61, 1f, -1, 0.5f, 61));
		this.add(new JunButtonViewAwt(this.getOpenGLDisplayModel().focusButton()), WindowSpecLayout.Position(1f, -19, 0.5f, -80, 1f, -1, 0.5f, -62));
		this.add(new JunButtonViewAwt(this.getOpenGLDisplayModel().dollyButton()), WindowSpecLayout.Position(1f, -19, 0.5f, 62, 1f, -1, 0.5f, 80));
		this.setSize(300, 300);
	}

	/**
	 * Answer my model as JunOpenGLDisplayModel.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @see jp.co.sra.jun.opengl.display.JunOpenGLDisplayView#getOpenGLDisplayModel()
	 * @category model accessing
	 */
	public JunOpenGLDisplayModel getOpenGLDisplayModel() {
		return (JunOpenGLDisplayModel) this.model();
	}

	/**
	 * Answer my controller as JunOpenGLDisplayController.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayController
	 * @category controller accessing
	 */
	public JunOpenGLDisplayController getOpenGLDisplayController() {
		return (JunOpenGLDisplayController) this.controller();
	}

	/**
	 * Answer a default controller.
	 * 
	 * @return jp.co.sra.smalltalk.StController
	 * @see jp.co.sra.smalltalk.StViewPanel#defaultController()
	 * @category controller accessing
	 */
	protected StController defaultController() {
		return new JunOpenGLDisplayController();
	}

	/**
	 * Answer my current OpenGL view.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGL3dViewWrapper
	 * @see jp.co.sra.jun.opengl.display.JunOpenGLDisplayView#getOpenGLView()
	 * @deprecated since Jun683, the former JunOpenGL3dView is replaced with JunOpenGLDrawable.
	 * @category accessing
	 */
	public JunOpenGL3dViewWrapper getOpenGLView() {
		return new JunOpenGL3dViewWrapper(this);
	}

	/**
	 * Answer my current OpenGL view.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGL3dView
	 * @see jp.co.sra.jun.opengl.display.JunOpenGLDisplayViewSwing#openGLView()
	 * @deprecated since Jun683, the former JunOpenGL3dView is replaced with JunOpenGLDrawable.
	 * @category user interface
	 */
	protected JunOpenGL3dView openGLView() {
		if (openGLView == null) {
			openGLView = new JunOpenGL3dViewWrapper(this);
		}
		return openGLView;
	}

	protected JunOpenGL3dView openGLView;

}
