package jp.co.sra.jun.opengl.display;

import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.WindowSpecLayout;

import jp.co.sra.jun.goodies.button.JunButtonViewAwt;
import jp.co.sra.jun.goodies.wheels.JunThumbWheelViewAwt;

/**
 * JunOpenGLShowViewAwt class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1999/06/02 (by MATSUDA Ryouichi)
 *  @updated   2000/01/09 (by MATSUDA Ryouichi)
 *  @updated   2003/05/08 (by nisinaka)
 *  @updated   2004/09/22 (by nisinaka)
 *  @updated   2007/08/24 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLShowViewAwt.java,v 8.14 2008/02/20 06:32:19 nisinaka Exp $
 */
public class JunOpenGLShowViewAwt extends JunOpenGLDisplayViewAwt implements JunOpenGLShowView {

	/**
	 * Create a new instance of <code>JunOpenGLShowViewAwt</code> and initialize it.
	 * 
	 * @param anOpenGLShowModel jp.co.sra.jun.opengl.display.JunOpenGLShowModel
	 * @category Instance creation
	 */
	public JunOpenGLShowViewAwt(JunOpenGLShowModel anOpenGLShowModel) {
		super(anOpenGLShowModel);
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.createOpenGLDrawableOnBorderedPanel(), WindowSpecLayout.Position(0f, 20, 0f, 1, 1f, -20, 1f, -20));
		this.add(new JunButtonViewAwt(this.getOpenGLShowModel().bullButton()), WindowSpecLayout.Position(0f, 1, 0f, 1, 0f, 19, 0f, 19));
		this.add(new JunButtonViewAwt(this.getOpenGLShowModel().grabButton()), WindowSpecLayout.Position(0f, 1, 0f, 20, 0f, 19, 0f, 38));
		this.add(new JunButtonViewAwt(this.getOpenGLShowModel().dragButton()), WindowSpecLayout.Position(0f, 1, 0f, 39, 0f, 19, 0f, 57));
		this.add(new JunThumbWheelViewAwt(this.getOpenGLShowModel().xThumbWheel()), WindowSpecLayout.Position(0f, 1, 0.5f, -61, 0f, 19, 0.5f, 61));
		this.add(new JunThumbWheelViewAwt(this.getOpenGLShowModel().yThumbWheel()), WindowSpecLayout.Position(0.5f, -61, 1f, -19, 0.5f, 61, 1f, -1));
		this.add(new JunThumbWheelViewAwt(this.getOpenGLShowModel().zThumbWheel()), WindowSpecLayout.Position(1f, -19, 0.5f, -61, 1f, -1, 0.5f, 61));
		this.setSize(300, 300);
	}

	/**
	 * Answer my model as JunOpenGLDisplayModel.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @see jp.co.sra.jun.opengl.display.JunOpenGLDisplayView#getOpenGLDisplayModel()
	 * @category model accessing
	 */
	public JunOpenGLDisplayModel getOpenGLDisplayModel() {
		return this.getOpenGLShowModel().displayModel();
	}

	/**
	 * Answer my model as JunOpenGLShowModel.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLShowModel
	 * @see jp.co.sra.jun.opengl.display.JunOpenGLShowView#getOpenGLShowModel()
	 * @category model accessing
	 */
	public JunOpenGLShowModel getOpenGLShowModel() {
		return (JunOpenGLShowModel) this.model();
	}

	/**
	 * Answer a default controller.
	 * 
	 * @return jp.co.sra.smalltalk.StController
	 * @see jp.co.sra.smalltalk.StViewPanel#defaultController()
	 * @category controller accessing
	 */
	protected StController defaultController() {
		return new JunOpenGLShowController();
	}

	/**
	 * Answer my show view.
	 *
	 * @see jp.co.sra.jun.opengl.display.JunOpenGLShowViewSwing#showView()
	 * @return jp.co.sra.jun.opengl.display.JunOpenGL3dViewSwing
	 * @deprecated since Jun683, the former JunOpenGL3dView is replaced with JunOpenGLDrawable.
	 * @category user interface
	 */
	public JunOpenGL3dView showView() {
		return this;
	}

}
