package jp.co.sra.jun.opengl.flux;

import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;

/**
 * JunOpenGLFluxImmutableObject class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1998/11/25 (by MATSUDA Ryouichi)
 *  @updated   2004/11/12 (by Mitsuhiro Asada)
 *  @updated   2006/10/12 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLFluxImmutableObject.java,v 8.11 2008/02/20 06:32:34 nisinaka Exp $
 */
public class JunOpenGLFluxImmutableObject extends JunOpenGLFluxAbstract {

	/**
	 * Create a new instance of JunOpenGLFluxImmutableObject and initialize it.
	 *
	 * @param a3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @return jp.co.sra.jun.opengl.flux.JunOpenGLFluxImmutableObject
	 * @category Instance creation
	 * @deprecated since Jun628, use the constructor.
	 */
	public static JunOpenGLFluxImmutableObject Object_(JunOpenGL3dObject a3dObject) {
		return new JunOpenGLFluxImmutableObject(a3dObject);
	}

	/**
	 * Create a new instance of JunOpenGLFluxImmutableObject and initialize it.
	 *
	 * @param a3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Instance creation
	 */
	public JunOpenGLFluxImmutableObject(JunOpenGL3dObject a3dObject) {
		super(a3dObject);
	}

	/**
	 * Create a new instance of JunOpenGLFluxImmutableObject and initialize it.
	 *
	 * @param aList jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category Instance creation
	 */
	public JunOpenGLFluxImmutableObject(JunLispList aList) {
		this.fromLispList(aList);
	}

	/**
	 * Answer the compound object.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject
	 * @category accessing
	 */
	public JunOpenGL3dCompoundObject compoundObject() {
		return this.originalObject().asCompoundObject();
	}

	/**
	 * Answer the object at normalized number.
	 * 
	 * @param normalizedNumber double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category accessing
	 */
	public JunOpenGL3dObject at_(double normalizedNumber) {
		if (this.originalObject() == null) {
			return null;
		}
		return this.originalObject();
	}

	/**
	 * Answer the number of all elements.
	 * 
	 * @return int
	 * @category accessing
	 */
	public int size() {
		return 0;
	}

	/**
	 * Answer my preferred bounding box.
	 * 
	 * @return jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox
	 * @see jp.co.sra.jun.opengl.flux.JunOpenGLFluxAbstract#preferredBoundingBox()
	 * @category bounds accessing
	 */
	public Jun3dBoundingBox preferredBoundingBox() {
		return this.compoundObject().boundingBox();
	}

	/**
	 * Answer my transformation sequence.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject[]
	 * @category accessing
	 */
	public JunOpenGL3dObject[] transformationSequence() {
		return new JunOpenGL3dObject[0];
	}

	/**
	 * Add a transformation..
	 * 
	 * @param aTransformation jp.co.sra.jun.geometry.transformations.Jun3dTransformation
	 * @category adding
	 */
	public void add_(Jun3dTransformation aTransformation) {
	}

	/**
	 * Enumerate the points and evaluate the block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category enumerating
	 */
	public void pointsDo_(StBlockClosure aBlock) {
		if (this.originalObject() == null) {
			return;
		}

		this.originalObject().pointsDo_(aBlock);
	}

	/**
	 * Answer true if the receiver is empty, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isEmpty() {
		throw SmalltalkException.Error("Please use \"isEmptyTransformation\" instead of \"isEmpty\"");
	}

	/**
	 * Answer true if the receiver is empty transformation, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isEmptyTransformation() {
		return true;
	}

	/**
	 * Show the receiver.
	 * 
	 * @category utilities
	 */
	public void show() {
		JunOpenGLFluxObject fluxObject = new JunOpenGLFluxObject();
		fluxObject.addImmutable_(this);
		fluxObject.show();
	}

	/**
	 * Get my attributes from the lisp list.
	 * 
	 * @param aList jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category lisp support
	 */
	public void fromLispList(JunLispList aList) {
		this.objectFromLispList(aList);
	}

	/**
	 * Convert the receiver as a lisp list.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispCons
	 * @category lisp support
	 */
	public JunLispCons toLispList() {
		JunLispCons list = this.lispCons();
		list.head_(this.kindName());
		list.add_(this.objectToLispList());
		return list;
	}

	/**
	 * Get my object from the lisp list.
	 * 
	 * @param aList jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category lisp support
	 */
	protected void objectFromLispList(JunLispList aList) {
		JunLispCons list = (JunLispCons) aList.detect_ifNone_(new StBlockClosure() {
			public Object value_(Object anObject) {
				return new Boolean(anObject instanceof JunLispCons && (((JunLispCons) anObject).head() == $("object")));
			}
		}, new StBlockClosure());
		if (list == null) {
			return;
		}

		this.originalObject_(JunOpenGL3dCompoundObject.ObjectFromLispList_((JunLispCons) list.tail()));
	}

	/**
	 * Convert the object as a lisp list.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispCons
	 * @category lisp support
	 */
	protected JunLispCons objectToLispList() {
		JunLispCons list = this.lispCons();
		list.head_($("object"));

		if (this.originalObject() != null) {
			list.tail_(this.originalObject().toLispList());
		}
		return list;
	}

}
