package jp.co.sra.jun.opengl.illusion;

import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StImage;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.surfaces.Jun3dTriangle;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.goodies.movie.framework.JunMoviePlayer;
import jp.co.sra.jun.goodies.movie.support.JunImagesToMovie;
import jp.co.sra.jun.goodies.utilities.JunControlUtility;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayLight;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.flux.JunOpenGLFluxModel;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.system.framework.JunAbstractObject;

/**
 * JunOpenGLIllusion class
 * 
 *  @author    nisinaka
 *  @created   2004/09/27 (by nisinaka)
 *  @updated   2006/10/12 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun655 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLIllusion.java,v 8.14 2008/02/20 06:32:34 nisinaka Exp $
 */
public abstract class JunOpenGLIllusion extends JunAbstractObject {
	protected JunOpenGLFluxModel fluxModel;
	protected int[] factorOfStages;

	/**
	 * Create a new face instance.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject
	 * @category Face
	 */
	public static JunOpenGL3dCompoundObject Face() {
		Jun3dTriangle[] faceTriangles = (Jun3dTriangle[]) FaceBoundingBoxAndTriangles()[1];
		JunOpenGL3dCompoundObject faceObject = new JunOpenGL3dCompoundObject();
		for (int i = 0; i < faceTriangles.length; i++) {
			faceObject.add_(faceTriangles[i].asJunOpenGL3dObjectColor_(FaceColor()));
		}
		return faceObject;
	}

	/**
	 * Answer the face bounding box and polylines.
	 * 
	 * @return java.lang.Object[] { jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox, jp.co.sra.jun.geometry.basic.Jun3dPoint[] }
	 * @category Face
	 */
	public static Object[] FaceBoundingBoxAndPolylines() {
		Object[] anArray = FaceData();
		Jun3dBoundingBox boundingBox = (Jun3dBoundingBox) anArray[0];
		Jun3dPoint[] facePoints = (Jun3dPoint[]) anArray[1];
		Map faceTable = new TreeMap();
		for (int i = 0; i < facePoints.length; i++) {
			Jun3dPoint aPoint = facePoints[i];
			Number key = new Double(aPoint.z());
			if (faceTable.containsKey(key) == false) {
				faceTable.put(key, new ArrayList());
			}
			((List) faceTable.get(key)).add(facePoints[i]);
		}
		Jun3dPoint[] facePolylines = (Jun3dPoint[]) faceTable.values().toArray(new Jun3dPoint[faceTable.size()]);
		return new Object[] { boundingBox, facePolylines };
	}

	/**
	 * Answer the face bounding box and triangles.
	 * 
	 * @return java.lang.Object[] { jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox, jp.co.sra.jun.geometry.surfaces.Jun3dTriangle[] }
	 * @category Face
	 */
	public static Object[] FaceBoundingBoxAndTriangles() {
		Object[] anArray = FaceData();
		Jun3dBoundingBox boundingBox = (Jun3dBoundingBox) anArray[0];
		Jun3dPoint[] facePoints = (Jun3dPoint[]) anArray[1];
		int[][] facePatches = (int[][]) anArray[2];
		Jun3dTriangle[] faceTriangles = new Jun3dTriangle[facePatches.length];
		for (int i = 0; i < facePatches.length; i++) {
			Jun3dPoint firstPoint = facePoints[facePatches[i][0]];
			Jun3dPoint secondPoint = facePoints[facePatches[i][1]];
			Jun3dPoint thirdPoint = facePoints[facePatches[i][2]];
			Jun3dTriangle aTriangle = Jun3dTriangle.First_second_third_(firstPoint, secondPoint, thirdPoint);
			faceTriangles[i] = aTriangle;
		}
		return new Object[] { boundingBox, faceTriangles };
	}

	/**
	 * Answer the face color.
	 * 
	 * @return java.awt.Color
	 * @category Face
	 */
	public static Color FaceColor() {
		return new Color(240, 220, 200);
	}

	/**
	 * Answer the face data.
	 * 
	 * @return java.lang.Object[] { jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox, jp.co.sra.jun.geometry.basic.Jun3dPoint[], int[][] }
	 * @category Face
	 */
	public static Object[] FaceData() {
		return new Object[] { FaceBoundingBox(), FacePoints(), FacePatches() };
	}

	/**
	 * Answer the face bounding box.
	 * 
	 * @return jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox
	 * @category Face
	 */
	protected static Jun3dBoundingBox FaceBoundingBox() {
		return Jun3dBoundingBox.Origin_corner_(new Jun3dPoint(-95.1766, -100.778, -117.0), new Jun3dPoint(95.1766, 100.778, 117.0));
	}

	/**
	 * Answer the face points.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @category Face
	 */
	protected static Jun3dPoint[] FacePoints() {
		Jun3dPoint[] facePoints = new Jun3dPoint[] {
				new Jun3dPoint(50.0, 9.46299, 104.0),
				new Jun3dPoint(52.8365, 4.48811, 104.0),
				new Jun3dPoint(52.6235, -1.18212, 104.0),
				new Jun3dPoint(52.1855, -6.88582, 104.0),
				new Jun3dPoint(50.0, -12.1791, 104.0),
				new Jun3dPoint(50.0, 24.0218, 97.0),
				new Jun3dPoint(52.4343, 19.5479, 97.0),
				new Jun3dPoint(54.3908, 14.8396, 97.0),
				new Jun3dPoint(56.5782, 10.2445, 97.0),
				new Jun3dPoint(58.0993, 5.44834, 97.0),
				new Jun3dPoint(57.7437, 0.362133, 97.0),
				new Jun3dPoint(57.5787, -4.70666, 97.0),
				new Jun3dPoint(58.0412, -9.71815, 97.0),
				new Jun3dPoint(56.7045, -14.4991, 97.0),
				new Jun3dPoint(54.9468, -19.256, 97.0),
				new Jun3dPoint(51.9458, -23.21, 97.0),
				new Jun3dPoint(50.0, -27.9228, 97.0),
				new Jun3dPoint(50.0, 34.661, 90.0),
				new Jun3dPoint(52.5546, 30.1804, 90.0),
				new Jun3dPoint(55.2464, 25.7833, 90.0),
				new Jun3dPoint(57.3227, 21.1091, 90.0),
				new Jun3dPoint(58.7401, 16.1524, 90.0),
				new Jun3dPoint(60.4332, 11.3227, 90.0),
				new Jun3dPoint(61.2259, 6.43154, 90.0),
				new Jun3dPoint(62.2179, 1.37306, 90.0),
				new Jun3dPoint(63.2607, -3.6744, 90.0),
				new Jun3dPoint(63.1171, -8.80806, 90.0),
				new Jun3dPoint(61.771, -13.7215, 90.0),
				new Jun3dPoint(60.4302, -18.5613, 90.0),
				new Jun3dPoint(58.273, -23.0702, 90.0),
				new Jun3dPoint(55.2455, -27.1742, 90.0),
				new Jun3dPoint(52.6227, -31.6151, 90.0),
				new Jun3dPoint(50.0, -36.0561, 90.0),
				new Jun3dPoint(50.0, 42.3779, 83.0),
				new Jun3dPoint(52.8461, 37.9734, 83.0),
				new Jun3dPoint(55.6108, 33.5323, 83.0),
				new Jun3dPoint(58.5634, 29.2722, 83.0),
				new Jun3dPoint(60.9833, 24.6437, 83.0),
				new Jun3dPoint(63.0056, 19.8784, 83.0),
				new Jun3dPoint(64.3129, 14.7998, 83.0),
				new Jun3dPoint(65.3344, 9.6593, 83.0),
				new Jun3dPoint(66.4855, 4.54689, 83.0),
				new Jun3dPoint(67.6161, -0.56998, 83.0),
				new Jun3dPoint(68.3517, -5.62759, 83.0),
				new Jun3dPoint(67.057, -10.6408, 83.0),
				new Jun3dPoint(65.6527, -15.5534, 83.0),
				new Jun3dPoint(63.6976, -20.3693, 83.0),
				new Jun3dPoint(62.2057, -25.3967, 83.0),
				new Jun3dPoint(59.7951, -30.0238, 83.0),
				new Jun3dPoint(56.5727, -34.1549, 83.0),
				new Jun3dPoint(53.2062, -38.1736, 83.0),
				new Jun3dPoint(50.0, -42.3234, 83.0),
				new Jun3dPoint(50.0, 46.4536, 76.0),
				new Jun3dPoint(53.3894, 42.5545, 76.0),
				new Jun3dPoint(56.3996, 38.3703, 76.0),
				new Jun3dPoint(59.6016, 34.3304, 76.0),
				new Jun3dPoint(62.9518, 30.4048, 76.0),
				new Jun3dPoint(65.2943, 25.8001, 76.0),
				new Jun3dPoint(66.6783, 20.8331, 76.0),
				new Jun3dPoint(68.0166, 15.8468, 76.0),
				new Jun3dPoint(69.8553, 11.0278, 76.0),
				new Jun3dPoint(70.1959, 5.94049, 76.0),
				new Jun3dPoint(71.7746, 1.03453, 76.0),
				new Jun3dPoint(71.4648, -4.1146, 76.0),
				new Jun3dPoint(70.1505, -8.97157, 76.0),
				new Jun3dPoint(69.4223, -14.074, 76.0),
				new Jun3dPoint(68.495, -19.1564, 76.0),
				new Jun3dPoint(67.1972, -24.1545, 76.0),
				new Jun3dPoint(65.5319, -29.0248, 76.0),
				new Jun3dPoint(62.3733, -33.1131, 76.0),
				new Jun3dPoint(59.9003, -37.5833, 76.0),
				new Jun3dPoint(56.0012, -40.9728, 76.0),
				new Jun3dPoint(52.6272, -44.7993, 76.0),
				new Jun3dPoint(50.0, -49.2478, 76.0),
				new Jun3dPoint(50.0, 50.289, 69.0),
				new Jun3dPoint(53.7633, 46.8212, 69.0),
				new Jun3dPoint(57.333, 43.1904, 69.0),
				new Jun3dPoint(60.2376, 38.9879, 69.0),
				new Jun3dPoint(63.3686, 34.9556, 69.0),
				new Jun3dPoint(66.0457, 30.5965, 69.0),
				new Jun3dPoint(68.5754, 26.1489, 69.0),
				new Jun3dPoint(69.7028, 21.1609, 69.0),
				new Jun3dPoint(70.8174, 16.1701, 69.0),
				new Jun3dPoint(72.6944, 11.4154, 69.0),
				new Jun3dPoint(73.7894, 6.42037, 69.0),
				new Jun3dPoint(74.0335, 1.36732, 69.0),
				new Jun3dPoint(74.508, -3.60172, 69.0),
				new Jun3dPoint(74.151, -8.70667, 69.0),
				new Jun3dPoint(72.8051, -13.6191, 69.0),
				new Jun3dPoint(72.0626, -18.6755, 69.0),
				new Jun3dPoint(71.1441, -23.7098, 69.0),
				new Jun3dPoint(69.0254, -28.3525, 69.0),
				new Jun3dPoint(66.2069, -32.5865, 69.0),
				new Jun3dPoint(63.6165, -36.9477, 69.0),
				new Jun3dPoint(60.4878, -40.9972, 69.0),
				new Jun3dPoint(57.0448, -44.7502, 69.0),
				new Jun3dPoint(53.3485, -48.2731, 69.0),
				new Jun3dPoint(50.0, -52.1428, 69.0),
				new Jun3dPoint(50.0, 55.0761, 62.0),
				new Jun3dPoint(53.3367, 51.2376, 62.0),
				new Jun3dPoint(56.6734, 47.3992, 62.0),
				new Jun3dPoint(60.0101, 43.5608, 62.0),
				new Jun3dPoint(63.2116, 39.6207, 62.0),
				new Jun3dPoint(65.9112, 35.3121, 62.0),
				new Jun3dPoint(68.1224, 30.7427, 62.0),
				new Jun3dPoint(70.4505, 26.2307, 62.0),
				new Jun3dPoint(72.0029, 21.4046, 62.0),
				new Jun3dPoint(73.6445, 16.6042, 62.0),
				new Jun3dPoint(74.6031, 11.6117, 62.0),
				new Jun3dPoint(75.7186, 6.65327, 62.0),
				new Jun3dPoint(76.8887, 1.77234, 62.0),
				new Jun3dPoint(76.5339, -3.30125, 62.0),
				new Jun3dPoint(76.1791, -8.37484, 62.0),
				new Jun3dPoint(75.5809, -13.401, 62.0),
				new Jun3dPoint(74.2369, -18.2971, 62.0),
				new Jun3dPoint(73.2556, -23.2875, 62.0),
				new Jun3dPoint(71.9837, -28.2097, 62.0),
				new Jun3dPoint(69.2256, -32.4096, 62.0),
				new Jun3dPoint(66.1161, -36.4343, 62.0),
				new Jun3dPoint(63.3594, -40.6981, 62.0),
				new Jun3dPoint(59.7776, -44.2485, 62.0),
				new Jun3dPoint(57.0402, -48.502, 62.0),
				new Jun3dPoint(53.328, -51.9646, 62.0),
				new Jun3dPoint(50.0, -55.8106, 62.0),
				new Jun3dPoint(50.0, 55.8958, 55.0),
				new Jun3dPoint(54.1978, 52.9604, 55.0),
				new Jun3dPoint(57.7883, 49.3501, 55.0),
				new Jun3dPoint(61.1489, 45.4842, 55.0),
				new Jun3dPoint(64.084, 41.3166, 55.0),
				new Jun3dPoint(66.8186, 36.9867, 55.0),
				new Jun3dPoint(70.0668, 33.0403, 55.0),
				new Jun3dPoint(71.613, 28.1698, 55.0),
				new Jun3dPoint(73.2219, 23.3203, 55.0),
				new Jun3dPoint(74.3101, 18.3414, 55.0),
				new Jun3dPoint(76.2029, 13.6588, 55.0),
				new Jun3dPoint(77.376, 8.74191, 55.0),
				new Jun3dPoint(77.9415, 3.71632, 55.0),
				new Jun3dPoint(78.5804, -1.30258, 55.0),
				new Jun3dPoint(78.3218, -6.40342, 55.0),
				new Jun3dPoint(76.9783, -11.2816, 55.0),
				new Jun3dPoint(76.621, -16.3915, 55.0),
				new Jun3dPoint(76.2637, -21.5014, 55.0),
				new Jun3dPoint(74.6856, -26.3339, 55.0),
				new Jun3dPoint(72.9573, -31.1521, 55.0),
				new Jun3dPoint(70.0505, -35.3184, 55.0),
				new Jun3dPoint(66.4827, -38.9272, 55.0),
				new Jun3dPoint(63.4198, -42.9563, 55.0),
				new Jun3dPoint(60.2286, -46.8787, 55.0),
				new Jun3dPoint(56.789, -50.5941, 55.0),
				new Jun3dPoint(53.3518, -54.3823, 55.0),
				new Jun3dPoint(50.0, -58.2558, 55.0),
				new Jun3dPoint(50.0, 59.2085, 49.0),
				new Jun3dPoint(53.7757, 55.7293, 49.0),
				new Jun3dPoint(57.5513, 52.2501, 49.0),
				new Jun3dPoint(61.2053, 48.6527, 49.0),
				new Jun3dPoint(64.1385, 44.4508, 49.0),
				new Jun3dPoint(67.3754, 40.4771, 49.0),
				new Jun3dPoint(70.1923, 36.1877, 49.0),
				new Jun3dPoint(72.7417, 31.7314, 49.0),
				new Jun3dPoint(74.3464, 26.9322, 49.0),
				new Jun3dPoint(75.4784, 21.928, 49.0),
				new Jun3dPoint(76.9455, 17.0791, 49.0),
				new Jun3dPoint(78.4254, 12.2348, 49.0),
				new Jun3dPoint(79.2742, 7.2157, 49.0),
				new Jun3dPoint(79.9301, 2.25972, 49.0),
				new Jun3dPoint(79.5719, -2.862, 49.0),
				new Jun3dPoint(79.2138, -7.98372, 49.0),
				new Jun3dPoint(78.8556, -13.1054, 49.0),
				new Jun3dPoint(78.2127, -18.1913, 49.0),
				new Jun3dPoint(77.2911, -23.2422, 49.0),
				new Jun3dPoint(76.0476, -28.2197, 49.0),
				new Jun3dPoint(74.0834, -32.9266, 49.0),
				new Jun3dPoint(70.9444, -36.9895, 49.0),
				new Jun3dPoint(68.19, -41.313, 49.0),
				new Jun3dPoint(64.5116, -44.8475, 49.0),
				new Jun3dPoint(61.1227, -48.7008, 49.0),
				new Jun3dPoint(57.3667, -52.1877, 49.0),
				new Jun3dPoint(53.8748, -55.9382, 49.0),
				new Jun3dPoint(50.0, -59.3065, 49.0),
				new Jun3dPoint(50.0, 59.6626, 42.0),
				new Jun3dPoint(54.1747, 56.7434, 42.0),
				new Jun3dPoint(58.1654, 53.5956, 42.0),
				new Jun3dPoint(61.8419, 50.076, 42.0),
				new Jun3dPoint(65.184, 46.2314, 42.0),
				new Jun3dPoint(68.526, 42.3869, 42.0),
				new Jun3dPoint(71.4791, 38.25, 42.0),
				new Jun3dPoint(73.6832, 33.6769, 42.0),
				new Jun3dPoint(75.9267, 29.1369, 42.0),
				new Jun3dPoint(76.9279, 24.1454, 42.0),
				new Jun3dPoint(78.661, 19.3671, 42.0),
				new Jun3dPoint(80.0689, 14.48, 42.0),
				new Jun3dPoint(80.4339, 9.46414, 42.0),
				new Jun3dPoint(81.0134, 4.46785, 42.0),
				new Jun3dPoint(80.732, -0.60707, 42.0),
				new Jun3dPoint(80.3767, -5.68874, 42.0),
				new Jun3dPoint(80.0214, -10.7704, 42.0),
				new Jun3dPoint(79.666, -15.8521, 42.0),
				new Jun3dPoint(79.3107, -20.9337, 42.0),
				new Jun3dPoint(77.9282, -25.7758, 42.0),
				new Jun3dPoint(76.2688, -30.5893, 42.0),
				new Jun3dPoint(73.6186, -34.8891, 42.0),
				new Jun3dPoint(71.1706, -39.2916, 42.0),
				new Jun3dPoint(67.9015, -43.1962, 42.0),
				new Jun3dPoint(64.787, -47.2273, 42.0),
				new Jun3dPoint(61.4805, -51.1013, 42.0),
				new Jun3dPoint(57.6891, -54.4963, 42.0),
				new Jun3dPoint(53.8445, -57.8383, 42.0),
				new Jun3dPoint(50.0, -61.1804, 42.0),
				new Jun3dPoint(50.0, 60.2905, 35.0),
				new Jun3dPoint(54.141, 57.3948, 35.0),
				new Jun3dPoint(58.257, 54.4651, 35.0),
				new Jun3dPoint(62.2556, 51.3758, 35.0),
				new Jun3dPoint(66.0426, 48.0359, 35.0),
				new Jun3dPoint(69.5656, 44.4244, 35.0),
				new Jun3dPoint(72.5132, 40.3346, 35.0),
				new Jun3dPoint(74.3214, 35.6803, 35.0),
				new Jun3dPoint(76.4354, 31.1331, 35.0),
				new Jun3dPoint(77.4346, 26.1832, 35.0),
				new Jun3dPoint(78.5524, 21.259, 35.0),
				new Jun3dPoint(79.5957, 16.3186, 35.0),
				new Jun3dPoint(80.5508, 11.3591, 35.0),
				new Jun3dPoint(80.2139, 6.31925, 35.0),
				new Jun3dPoint(80.8703, 1.3707, 35.0),
				new Jun3dPoint(80.5179, -3.66997, 35.0),
				new Jun3dPoint(80.1654, -8.71065, 35.0),
				new Jun3dPoint(80.3701, -13.7594, 35.0),
				new Jun3dPoint(80.2605, -18.7723, 35.0),
				new Jun3dPoint(79.1187, -23.6786, 35.0),
				new Jun3dPoint(78.129, -28.5697, 35.0),
				new Jun3dPoint(76.1027, -33.1914, 35.0),
				new Jun3dPoint(73.5332, -37.5423, 35.0),
				new Jun3dPoint(70.9637, -41.8932, 35.0),
				new Jun3dPoint(68.0275, -45.9804, 35.0),
				new Jun3dPoint(64.7211, -49.8015, 35.0),
				new Jun3dPoint(61.1518, -53.3601, 35.0),
				new Jun3dPoint(57.1664, -56.4467, 35.0),
				new Jun3dPoint(53.3064, -59.6308, 35.0),
				new Jun3dPoint(50.0, -63.4519, 35.0),
				new Jun3dPoint(50.0, 59.9887, 28.0),
				new Jun3dPoint(54.376, 57.4043, 28.0),
				new Jun3dPoint(58.7451, 54.8091, 28.0),
				new Jun3dPoint(62.971, 51.986, 28.0),
				new Jun3dPoint(67.0211, 48.9323, 28.0),
				new Jun3dPoint(70.3485, 45.1586, 28.0),
				new Jun3dPoint(72.9883, 40.8182, 28.0),
				new Jun3dPoint(75.0621, 36.1858, 28.0),
				new Jun3dPoint(76.3959, 31.2865, 28.0),
				new Jun3dPoint(76.5966, 26.2675, 28.0),
				new Jun3dPoint(77.251, 21.2899, 28.0),
				new Jun3dPoint(77.6442, 16.2884, 28.0),
				new Jun3dPoint(79.2117, 11.4673, 28.0),
				new Jun3dPoint(79.6489, 6.50088, 28.0),
				new Jun3dPoint(79.8788, 1.52668, 28.0),
				new Jun3dPoint(79.6331, -3.54388, 28.0),
				new Jun3dPoint(79.9101, -8.61843, 28.0),
				new Jun3dPoint(79.8172, -13.6902, 28.0),
				new Jun3dPoint(79.4627, -18.7599, 28.0),
				new Jun3dPoint(78.8344, -23.7763, 28.0),
				new Jun3dPoint(77.1096, -28.5529, 28.0),
				new Jun3dPoint(76.1057, -33.4701, 28.0),
				new Jun3dPoint(74.1662, -38.1676, 28.0),
				new Jun3dPoint(72.5236, -42.9745, 28.0),
				new Jun3dPoint(70.247, -47.5039, 28.0),
				new Jun3dPoint(66.486, -50.6851, 28.0),
				new Jun3dPoint(63.0879, -54.4397, 28.0),
				new Jun3dPoint(58.9508, -57.3781, 28.0),
				new Jun3dPoint(54.5297, -59.8643, 28.0),
				new Jun3dPoint(50.0, -62.1687, 28.0),
				new Jun3dPoint(50.0, 59.7758, 21.0),
				new Jun3dPoint(54.5614, 57.4317, 21.0),
				new Jun3dPoint(59.1228, 55.0876, 21.0),
				new Jun3dPoint(63.2282, 52.0263, 21.0),
				new Jun3dPoint(67.1964, 48.7806, 21.0),
				new Jun3dPoint(70.4995, 44.925, 21.0),
				new Jun3dPoint(73.1491, 40.5362, 21.0),
				new Jun3dPoint(75.8953, 36.2062, 21.0),
				new Jun3dPoint(76.9527, 31.3593, 21.0),
				new Jun3dPoint(76.595, 26.2433, 21.0),
				new Jun3dPoint(76.2372, 21.1273, 21.0),
				new Jun3dPoint(75.8795, 16.0114, 21.0),
				new Jun3dPoint(76.9184, 11.008, 21.0),
				new Jun3dPoint(78.0067, 6.00019, 21.0),
				new Jun3dPoint(78.839, 0.992893, 21.0),
				new Jun3dPoint(78.4813, -4.12307, 21.0),
				new Jun3dPoint(78.1236, -9.23904, 21.0),
				new Jun3dPoint(77.7658, -14.355, 21.0),
				new Jun3dPoint(77.4081, -19.471, 21.0),
				new Jun3dPoint(77.0503, -24.5869, 21.0),
				new Jun3dPoint(76.6926, -29.7029, 21.0),
				new Jun3dPoint(76.3348, -34.8189, 21.0),
				new Jun3dPoint(74.6877, -39.6442, 21.0),
				new Jun3dPoint(72.9365, -44.4604, 21.0),
				new Jun3dPoint(70.4419, -48.9328, 21.0),
				new Jun3dPoint(66.6297, -52.3459, 21.0),
				new Jun3dPoint(62.6551, -55.5764, 21.0),
				new Jun3dPoint(58.4368, -58.493, 21.0),
				new Jun3dPoint(54.2184, -61.4095, 21.0),
				new Jun3dPoint(50.0, -64.3261, 21.0),
				new Jun3dPoint(50.0, 60.5081, 14.0),
				new Jun3dPoint(54.3883, 57.9165, 14.0),
				new Jun3dPoint(58.7765, 55.3249, 14.0),
				new Jun3dPoint(62.6373, 52.0233, 14.0),
				new Jun3dPoint(66.4453, 48.6371, 14.0),
				new Jun3dPoint(69.1864, 44.4984, 14.0),
				new Jun3dPoint(72.1256, 40.4016, 14.0),
				new Jun3dPoint(74.2531, 35.8018, 14.0),
				new Jun3dPoint(75.1988, 30.8783, 14.0),
				new Jun3dPoint(75.351, 25.7842, 14.0),
				new Jun3dPoint(75.2046, 20.696, 14.0),
				new Jun3dPoint(75.1978, 15.6439, 14.0),
				new Jun3dPoint(76.4683, 10.7084, 14.0),
				new Jun3dPoint(78.0393, 5.87347, 14.0),
				new Jun3dPoint(77.8233, 0.802225, 14.0),
				new Jun3dPoint(77.4678, -4.28176, 14.0),
				new Jun3dPoint(77.1123, -9.36574, 14.0),
				new Jun3dPoint(76.7568, -14.4497, 14.0),
				new Jun3dPoint(76.4012, -19.5337, 14.0),
				new Jun3dPoint(76.0457, -24.6177, 14.0),
				new Jun3dPoint(76.6845, -29.607, 14.0),
				new Jun3dPoint(75.3388, -34.5226, 14.0),
				new Jun3dPoint(73.9931, -39.4381, 14.0),
				new Jun3dPoint(72.6211, -44.3396, 14.0),
				new Jun3dPoint(69.3102, -48.2106, 14.0),
				new Jun3dPoint(66.5246, -52.4373, 14.0),
				new Jun3dPoint(62.6589, -55.755, 14.0),
				new Jun3dPoint(58.384, -58.5294, 14.0),
				new Jun3dPoint(54.192, -61.4278, 14.0),
				new Jun3dPoint(50.0, -64.3261, 14.0),
				new Jun3dPoint(50.0, 62.597, 7.0),
				new Jun3dPoint(54.0487, 59.4689, 7.0),
				new Jun3dPoint(58.1804, 56.4536, 7.0),
				new Jun3dPoint(62.0092, 53.117, 7.0),
				new Jun3dPoint(65.3658, 49.2557, 7.0),
				new Jun3dPoint(68.0251, 44.9622, 7.0),
				new Jun3dPoint(70.346, 40.4129, 7.0),
				new Jun3dPoint(72.7563, 35.9075, 7.0),
				new Jun3dPoint(74.4837, 31.1039, 7.0),
				new Jun3dPoint(74.5759, 26.041, 7.0),
				new Jun3dPoint(74.6644, 20.9606, 7.0),
				new Jun3dPoint(75.7674, 15.9684, 7.0),
				new Jun3dPoint(77.4389, 11.1741, 7.0),
				new Jun3dPoint(79.5059, 6.51885, 7.0),
				new Jun3dPoint(79.5076, 1.59581, 7.0),
				new Jun3dPoint(78.5376, -3.31733, 7.0),
				new Jun3dPoint(77.1997, -8.11597, 7.0),
				new Jun3dPoint(76.8427, -13.2199, 7.0),
				new Jun3dPoint(75.5667, -18.1448, 7.0),
				new Jun3dPoint(75.14, -23.2351, 7.0),
				new Jun3dPoint(74.7831, -28.339, 7.0),
				new Jun3dPoint(74.4262, -33.4429, 7.0),
				new Jun3dPoint(73.3079, -38.3985, 7.0),
				new Jun3dPoint(71.1927, -43.0191, 7.0),
				new Jun3dPoint(68.3234, -47.2432, 7.0),
				new Jun3dPoint(64.9436, -51.0009, 7.0),
				new Jun3dPoint(61.4871, -54.7614, 7.0),
				new Jun3dPoint(57.7227, -58.2148, 7.0),
				new Jun3dPoint(53.8614, -61.5714, 7.0),
				new Jun3dPoint(50.0, -64.9281, 7.0),
				new Jun3dPoint(50.0, 65.7766, 0.0),
				new Jun3dPoint(53.8613, 62.4354, 0.0),
				new Jun3dPoint(57.7225, 59.0943, 0.0),
				new Jun3dPoint(61.8977, 56.1561, 0.0),
				new Jun3dPoint(65.0204, 52.1738, 0.0),
				new Jun3dPoint(67.7088, 47.8381, 0.0),
				new Jun3dPoint(69.7428, 43.1595, 0.0),
				new Jun3dPoint(72.268, 38.7218, 0.0),
				new Jun3dPoint(73.8448, 33.9419, 0.0),
				new Jun3dPoint(74.9718, 28.9653, 0.0),
				new Jun3dPoint(75.4297, 23.9145, 0.0),
				new Jun3dPoint(76.0195, 18.8707, 0.0),
				new Jun3dPoint(78.4694, 14.4063, 0.0),
				new Jun3dPoint(80.9985, 9.97048, 0.0),
				new Jun3dPoint(82.7814, 5.21097, 0.0),
				new Jun3dPoint(82.7899, 0.150558, 0.0),
				new Jun3dPoint(80.4147, -4.31826, 0.0),
				new Jun3dPoint(79.1384, -9.06164, 0.0),
				new Jun3dPoint(78.7822, -14.1554, 0.0),
				new Jun3dPoint(77.3179, -19.0333, 0.0),
				new Jun3dPoint(76.0919, -23.9577, 0.0),
				new Jun3dPoint(75.7357, -29.0514, 0.0),
				new Jun3dPoint(74.8518, -34.0211, 0.0),
				new Jun3dPoint(73.165, -38.8374, 0.0),
				new Jun3dPoint(71.2514, -43.57, 0.0),
				new Jun3dPoint(68.8712, -48.0745, 0.0),
				new Jun3dPoint(65.2814, -51.6442, 0.0),
				new Jun3dPoint(61.9193, -55.4846, 0.0),
				new Jun3dPoint(57.6503, -58.2785, 0.0),
				new Jun3dPoint(54.2887, -62.1162, 0.0),
				new Jun3dPoint(50.0, -64.8875, 0.0),
				new Jun3dPoint(50.0, 65.1825, -7.0),
				new Jun3dPoint(54.3871, 62.5915, -7.0),
				new Jun3dPoint(58.7743, 60.0006, -7.0),
				new Jun3dPoint(63.064, 57.2927, -7.0),
				new Jun3dPoint(66.4066, 53.4474, -7.0),
				new Jun3dPoint(68.9442, 49.031, -7.0),
				new Jun3dPoint(70.5392, 44.2694, -7.0),
				new Jun3dPoint(72.5846, 39.6704, -7.0),
				new Jun3dPoint(73.8677, 34.7961, -7.0),
				new Jun3dPoint(75.7221, 30.0986, -7.0),
				new Jun3dPoint(75.716, 25.0479, -7.0),
				new Jun3dPoint(76.7921, 20.0716, -7.0),
				new Jun3dPoint(79.3943, 15.8728, -7.0),
				new Jun3dPoint(82.71, 12.0083, -7.0),
				new Jun3dPoint(85.5001, 7.77108, -7.0),
				new Jun3dPoint(85.9946, 2.9728, -7.0),
				new Jun3dPoint(84.102, -1.67401, -7.0),
				new Jun3dPoint(81.3514, -5.91054, -7.0),
				new Jun3dPoint(80.4369, -10.9229, -7.0),
				new Jun3dPoint(79.3603, -15.8943, -7.0),
				new Jun3dPoint(77.7828, -20.739, -7.0),
				new Jun3dPoint(76.2053, -25.5837, -7.0),
				new Jun3dPoint(75.6258, -30.6227, -7.0),
				new Jun3dPoint(75.1905, -35.6866, -7.0),
				new Jun3dPoint(73.4037, -40.4542, -7.0),
				new Jun3dPoint(71.5985, -45.215, -7.0),
				new Jun3dPoint(68.9438, -49.5589, -7.0),
				new Jun3dPoint(65.7381, -53.5166, -7.0),
				new Jun3dPoint(62.1827, -57.1486, -7.0),
				new Jun3dPoint(58.3374, -60.4912, -7.0),
				new Jun3dPoint(54.2794, -63.551, -7.0),
				new Jun3dPoint(50.0, -66.3162, -7.0),
				new Jun3dPoint(50.0, 64.6476, -14.0),
				new Jun3dPoint(54.5732, 62.2974, -14.0),
				new Jun3dPoint(59.1464, 59.9473, -14.0),
				new Jun3dPoint(63.7196, 57.5971, -14.0),
				new Jun3dPoint(67.5721, 54.2103, -14.0),
				new Jun3dPoint(69.6319, 49.5048, -14.0),
				new Jun3dPoint(71.9204, 44.9115, -14.0),
				new Jun3dPoint(73.4924, 40.0292, -14.0),
				new Jun3dPoint(74.6714, 35.0664, -14.0),
				new Jun3dPoint(75.8757, 30.2936, -14.0),
				new Jun3dPoint(76.649, 25.229, -14.0),
				new Jun3dPoint(78.2499, 20.3564, -14.0),
				new Jun3dPoint(80.5625, 15.7748, -14.0),
				new Jun3dPoint(84.4648, 12.4865, -14.0),
				new Jun3dPoint(88.1941, 8.9832, -14.0),
				new Jun3dPoint(91.4092, 5.00472, -14.0),
				new Jun3dPoint(90.2716, 0.474147, -14.0),
				new Jun3dPoint(87.6569, -3.95314, -14.0),
				new Jun3dPoint(84.6714, -8.12904, -14.0),
				new Jun3dPoint(82.2202, -12.6479, -14.0),
				new Jun3dPoint(79.8093, -17.1894, -14.0),
				new Jun3dPoint(77.5517, -21.8086, -14.0),
				new Jun3dPoint(76.8916, -26.8575, -14.0),
				new Jun3dPoint(76.5329, -31.9867, -14.0),
				new Jun3dPoint(75.188, -36.8843, -14.0),
				new Jun3dPoint(73.9707, -41.8463, -14.0),
				new Jun3dPoint(72.151, -46.6514, -14.0),
				new Jun3dPoint(69.8183, -51.1489, -14.0),
				new Jun3dPoint(66.6195, -55.1656, -14.0),
				new Jun3dPoint(62.8679, -58.6675, -14.0),
				new Jun3dPoint(59.1656, -62.1239, -14.0),
				new Jun3dPoint(54.5828, -64.4552, -14.0),
				new Jun3dPoint(50.0, -66.7866, -14.0),
				new Jun3dPoint(50.0, 63.7618, -20.0),
				new Jun3dPoint(54.571, 61.4127, -20.0),
				new Jun3dPoint(59.1421, 59.0637, -20.0),
				new Jun3dPoint(63.6507, 56.6013, -20.0),
				new Jun3dPoint(67.8743, 53.7781, -20.0),
				new Jun3dPoint(70.627, 49.4393, -20.0),
				new Jun3dPoint(72.4321, 44.7072, -20.0),
				new Jun3dPoint(74.3944, 40.0319, -20.0),
				new Jun3dPoint(75.4359, 35.016, -20.0),
				new Jun3dPoint(76.717, 30.0389, -20.0),
				new Jun3dPoint(77.6889, 24.9947, -20.0),
				new Jun3dPoint(80.0037, 20.5608, -20.0),
				new Jun3dPoint(83.4741, 16.7738, -20.0),
				new Jun3dPoint(87.0963, 13.1279, -20.0),
				new Jun3dPoint(90.8045, 9.57417, -20.0),
				new Jun3dPoint(94.5094, 6.02949, -20.0),
				new Jun3dPoint(94.8509, 1.15864, -20.0),
				new Jun3dPoint(92.1064, -3.02854, -20.0),
				new Jun3dPoint(88.8252, -6.96854, -20.0),
				new Jun3dPoint(85.6, -10.9539, -20.0),
				new Jun3dPoint(82.9866, -15.3791, -20.0),
				new Jun3dPoint(80.2261, -19.7097, -20.0),
				new Jun3dPoint(78.0796, -24.2039, -20.0),
				new Jun3dPoint(77.721, -29.3307, -20.0),
				new Jun3dPoint(76.3763, -34.2259, -20.0),
				new Jun3dPoint(75.8157, -39.3133, -20.0),
				new Jun3dPoint(74.0907, -44.1508, -20.0),
				new Jun3dPoint(72.4056, -49.0029, -20.0),
				new Jun3dPoint(69.8346, -53.3077, -20.0),
				new Jun3dPoint(66.2155, -56.9384, -20.0),
				new Jun3dPoint(62.579, -60.5518, -20.0),
				new Jun3dPoint(58.4546, -63.607, -20.0),
				new Jun3dPoint(54.2273, -66.5298, -20.0),
				new Jun3dPoint(50.0, -69.4525, -20.0),
				new Jun3dPoint(50.0, 61.9601, -27.0),
				new Jun3dPoint(54.5762, 59.7477, -27.0),
				new Jun3dPoint(59.1523, 57.5354, -27.0),
				new Jun3dPoint(63.7285, 55.323, -27.0),
				new Jun3dPoint(67.5535, 52.1281, -27.0),
				new Jun3dPoint(70.8881, 48.292, -27.0),
				new Jun3dPoint(72.6127, 43.6873, -27.0),
				new Jun3dPoint(74.8018, 39.143, -27.0),
				new Jun3dPoint(76.5766, 34.3904, -27.0),
				new Jun3dPoint(76.8139, 29.3739, -27.0),
				new Jun3dPoint(77.1999, 24.4723, -27.0),
				new Jun3dPoint(79.8497, 20.137, -27.0),
				new Jun3dPoint(83.2212, 16.4005, -27.0),
				new Jun3dPoint(87.1686, 13.2015, -27.0),
				new Jun3dPoint(90.9856, 9.90518, -27.0),
				new Jun3dPoint(93.8472, 5.71342, -27.0),
				new Jun3dPoint(94.8862, 1.10919, -27.0),
				new Jun3dPoint(92.859, -3.31125, -27.0),
				new Jun3dPoint(89.4907, -7.08748, -27.0),
				new Jun3dPoint(85.7035, -10.4683, -27.0),
				new Jun3dPoint(82.9722, -14.5723, -27.0),
				new Jun3dPoint(81.1756, -19.3271, -27.0),
				new Jun3dPoint(78.9946, -23.8974, -27.0),
				new Jun3dPoint(77.7654, -28.6959, -27.0),
				new Jun3dPoint(76.4246, -33.5347, -27.0),
				new Jun3dPoint(76.0701, -38.6053, -27.0),
				new Jun3dPoint(75.3487, -43.5896, -27.0),
				new Jun3dPoint(73.6319, -48.37, -27.0),
				new Jun3dPoint(70.8147, -52.5402, -27.0),
				new Jun3dPoint(67.3897, -56.2699, -27.0),
				new Jun3dPoint(63.1205, -59.0286, -27.0),
				new Jun3dPoint(58.8312, -61.754, -27.0),
				new Jun3dPoint(54.4156, -64.2716, -27.0),
				new Jun3dPoint(50.0, -66.7893, -27.0),
				new Jun3dPoint(50.0, 60.31, -34.0),
				new Jun3dPoint(54.5378, 58.1162, -34.0),
				new Jun3dPoint(59.0757, 55.9224, -34.0),
				new Jun3dPoint(63.3632, 53.3239, -34.0),
				new Jun3dPoint(67.3346, 50.2242, -34.0),
				new Jun3dPoint(70.3897, 46.2643, -34.0),
				new Jun3dPoint(72.4903, 41.6915, -34.0),
				new Jun3dPoint(74.6603, 37.1527, -34.0),
				new Jun3dPoint(76.1245, 32.341, -34.0),
				new Jun3dPoint(76.6755, 27.3954, -34.0),
				new Jun3dPoint(77.3732, 22.4661, -34.0),
				new Jun3dPoint(79.3807, 17.8476, -34.0),
				new Jun3dPoint(82.2135, 13.7075, -34.0),
				new Jun3dPoint(85.8096, 10.1936, -34.0),
				new Jun3dPoint(88.9956, 6.35176, -34.0),
				new Jun3dPoint(91.5903, 2.03279, -34.0),
				new Jun3dPoint(90.9811, -2.72159, -34.0),
				new Jun3dPoint(87.3817, -6.19869, -34.0),
				new Jun3dPoint(83.858, -9.6115, -34.0),
				new Jun3dPoint(81.7687, -13.9234, -34.0),
				new Jun3dPoint(79.8524, -18.5452, -34.0),
				new Jun3dPoint(78.4184, -23.3772, -34.0),
				new Jun3dPoint(77.0611, -28.2311, -34.0),
				new Jun3dPoint(76.447, -33.2145, -34.0),
				new Jun3dPoint(76.0954, -38.2426, -34.0),
				new Jun3dPoint(75.5037, -43.2142, -34.0),
				new Jun3dPoint(73.2442, -47.7055, -34.0),
				new Jun3dPoint(70.3503, -51.8213, -34.0),
				new Jun3dPoint(66.6021, -55.1807, -34.0),
				new Jun3dPoint(62.4544, -58.0303, -34.0),
				new Jun3dPoint(58.2918, -60.8716, -34.0),
				new Jun3dPoint(54.1459, -63.7381, -34.0),
				new Jun3dPoint(50.0, -66.6045, -34.0),
				new Jun3dPoint(50.0, 61.5456, -41.0),
				new Jun3dPoint(54.0272, 58.4341, -41.0),
				new Jun3dPoint(58.0544, 55.3227, -41.0),
				new Jun3dPoint(62.0815, 52.2112, -41.0),
				new Jun3dPoint(66.0266, 48.9994, -41.0),
				new Jun3dPoint(68.9711, 45.0163, -41.0),
				new Jun3dPoint(71.7529, 40.8304, -41.0),
				new Jun3dPoint(74.0323, 36.3331, -41.0),
				new Jun3dPoint(75.3791, 31.4309, -41.0),
				new Jun3dPoint(76.4023, 26.4492, -41.0),
				new Jun3dPoint(77.7517, 21.5552, -41.0),
				new Jun3dPoint(79.8934, 16.9483, -41.0),
				new Jun3dPoint(82.4141, 12.5273, -41.0),
				new Jun3dPoint(85.1558, 8.24053, -41.0),
				new Jun3dPoint(86.7376, 3.42717, -41.0),
				new Jun3dPoint(87.6912, -1.43568, -41.0),
				new Jun3dPoint(86.9331, -6.41773, -41.0),
				new Jun3dPoint(84.4812, -10.8495, -41.0),
				new Jun3dPoint(81.6529, -15.0632, -41.0),
				new Jun3dPoint(80.3836, -19.9253, -41.0),
				new Jun3dPoint(78.8269, -24.669, -41.0),
				new Jun3dPoint(77.9134, -29.6755, -41.0),
				new Jun3dPoint(76.5922, -34.5789, -41.0),
				new Jun3dPoint(75.0136, -39.3777, -41.0),
				new Jun3dPoint(73.561, -44.0365, -41.0),
				new Jun3dPoint(70.8106, -48.3084, -41.0),
				new Jun3dPoint(67.2066, -51.8444, -41.0),
				new Jun3dPoint(63.865, -55.6812, -41.0),
				new Jun3dPoint(59.4496, -58.2088, -41.0),
				new Jun3dPoint(54.8061, -60.24, -41.0),
				new Jun3dPoint(50.0, -61.9135, -41.0),
				new Jun3dPoint(50.0, 57.8171, -48.0),
				new Jun3dPoint(54.1761, 55.0273, -48.0),
				new Jun3dPoint(58.3522, 52.2374, -48.0),
				new Jun3dPoint(62.5402, 49.4664, -48.0),
				new Jun3dPoint(66.4102, 46.5174, -48.0),
				new Jun3dPoint(68.7465, 42.1331, -48.0),
				new Jun3dPoint(71.42, 37.9577, -48.0),
				new Jun3dPoint(73.6632, 33.4749, -48.0),
				new Jun3dPoint(75.024, 28.6706, -48.0),
				new Jun3dPoint(76.5367, 23.9555, -48.0),
				new Jun3dPoint(78.6447, 19.4064, -48.0),
				new Jun3dPoint(80.9742, 14.9659, -48.0),
				new Jun3dPoint(83.0015, 10.3772, -48.0),
				new Jun3dPoint(85.4891, 6.01424, -48.0),
				new Jun3dPoint(86.7789, 1.21861, -48.0),
				new Jun3dPoint(87.5333, -3.69426, -48.0),
				new Jun3dPoint(86.1227, -8.38047, -48.0),
				new Jun3dPoint(84.206, -13.0226, -48.0),
				new Jun3dPoint(82.0056, -17.5233, -48.0),
				new Jun3dPoint(79.9033, -22.0602, -48.0),
				new Jun3dPoint(78.8004, -26.9183, -48.0),
				new Jun3dPoint(76.7132, -31.4864, -48.0),
				new Jun3dPoint(74.8127, -36.1272, -48.0),
				new Jun3dPoint(72.7285, -40.6637, -48.0),
				new Jun3dPoint(69.8443, -44.7643, -48.0),
				new Jun3dPoint(67.2115, -49.0294, -48.0),
				new Jun3dPoint(63.4212, -52.3243, -48.0),
				new Jun3dPoint(59.3226, -55.2224, -48.0),
				new Jun3dPoint(54.7818, -57.2469, -48.0),
				new Jun3dPoint(50.0, -58.7823, -48.0),
				new Jun3dPoint(50.0, 55.3143, -55.0),
				new Jun3dPoint(54.3455, 52.7479, -55.0),
				new Jun3dPoint(58.6911, 50.1815, -55.0),
				new Jun3dPoint(63.0366, 47.6152, -55.0),
				new Jun3dPoint(65.7846, 43.3848, -55.0),
				new Jun3dPoint(68.8688, 39.4354, -55.0),
				new Jun3dPoint(70.9625, 34.852, -55.0),
				new Jun3dPoint(73.4622, 30.4678, -55.0),
				new Jun3dPoint(74.5972, 25.5888, -55.0),
				new Jun3dPoint(76.4572, 20.965, -55.0),
				new Jun3dPoint(79.0967, 16.6657, -55.0),
				new Jun3dPoint(81.7643, 12.3835, -55.0),
				new Jun3dPoint(84.3333, 8.04135, -55.0),
				new Jun3dPoint(85.2869, 3.08878, -55.0),
				new Jun3dPoint(86.5449, -1.79866, -55.0),
				new Jun3dPoint(86.1022, -6.77294, -55.0),
				new Jun3dPoint(84.3603, -11.5056, -55.0),
				new Jun3dPoint(82.5066, -16.1918, -55.0),
				new Jun3dPoint(79.6183, -20.3191, -55.0),
				new Jun3dPoint(77.9471, -24.9346, -55.0),
				new Jun3dPoint(76.1342, -29.6203, -55.0),
				new Jun3dPoint(73.5678, -33.9659, -55.0),
				new Jun3dPoint(71.0014, -38.3114, -55.0),
				new Jun3dPoint(68.6536, -42.774, -55.0),
				new Jun3dPoint(66.2632, -47.2138, -55.0),
				new Jun3dPoint(62.6303, -50.5348, -55.0),
				new Jun3dPoint(58.6697, -53.6439, -55.0),
				new Jun3dPoint(54.4981, -56.4169, -55.0),
				new Jun3dPoint(50.0, -58.7052, -55.0),
				new Jun3dPoint(50.0, 53.2367, -62.0),
				new Jun3dPoint(54.3305, 50.6792, -62.0),
				new Jun3dPoint(58.6611, 48.1217, -62.0),
				new Jun3dPoint(62.5144, 44.9911, -62.0),
				new Jun3dPoint(65.814, 41.1954, -62.0),
				new Jun3dPoint(68.0511, 36.7415, -62.0),
				new Jun3dPoint(70.2687, 32.2561, -62.0),
				new Jun3dPoint(71.8881, 27.5079, -62.0),
				new Jun3dPoint(74.1837, 23.0429, -62.0),
				new Jun3dPoint(76.8977, 18.8093, -62.0),
				new Jun3dPoint(80.1081, 14.9466, -62.0),
				new Jun3dPoint(82.8131, 10.7075, -62.0),
				new Jun3dPoint(85.0877, 6.23219, -62.0),
				new Jun3dPoint(85.8848, 1.40272, -62.0),
				new Jun3dPoint(85.534, -3.61438, -62.0),
				new Jun3dPoint(84.3858, -8.44419, -62.0),
				new Jun3dPoint(82.6943, -13.1624, -62.0),
				new Jun3dPoint(80.0156, -17.3716, -62.0),
				new Jun3dPoint(77.271, -21.5426, -62.0),
				new Jun3dPoint(75.1133, -26.0722, -62.0),
				new Jun3dPoint(73.3911, -30.6472, -62.0),
				new Jun3dPoint(70.5049, -34.7549, -62.0),
				new Jun3dPoint(67.9474, -39.0855, -62.0),
				new Jun3dPoint(65.3899, -43.416, -62.0),
				new Jun3dPoint(62.3212, -47.3789, -62.0),
				new Jun3dPoint(58.6754, -50.8281, -62.0),
				new Jun3dPoint(54.4826, -53.5385, -62.0),
				new Jun3dPoint(50.0, -55.819, -62.0),
				new Jun3dPoint(50.0, 51.3815, -69.0),
				new Jun3dPoint(54.0715, 48.2358, -69.0),
				new Jun3dPoint(58.143, 45.0901, -69.0),
				new Jun3dPoint(61.7984, 41.5035, -69.0),
				new Jun3dPoint(64.7231, 37.2815, -69.0),
				new Jun3dPoint(67.32, 32.8413, -69.0),
				new Jun3dPoint(69.966, 28.4309, -69.0),
				new Jun3dPoint(72.654, 24.046, -69.0),
				new Jun3dPoint(74.7848, 19.3715, -69.0),
				new Jun3dPoint(77.942, 15.3505, -69.0),
				new Jun3dPoint(80.7194, 11.0199, -69.0),
				new Jun3dPoint(83.0606, 6.44861, -69.0),
				new Jun3dPoint(83.8874, 1.5098, -69.0),
				new Jun3dPoint(83.5285, -3.62281, -69.0),
				new Jun3dPoint(82.2898, -8.5488, -69.0),
				new Jun3dPoint(81.3891, -13.4907, -69.0),
				new Jun3dPoint(78.7818, -17.8738, -69.0),
				new Jun3dPoint(75.8984, -22.1044, -69.0),
				new Jun3dPoint(72.9142, -26.2848, -69.0),
				new Jun3dPoint(70.696, -30.9136, -69.0),
				new Jun3dPoint(67.8669, -35.2042, -69.0),
				new Jun3dPoint(64.8423, -39.3664, -69.0),
				new Jun3dPoint(61.87, -43.566, -69.0),
				new Jun3dPoint(58.4038, -47.3166, -69.0),
				new Jun3dPoint(54.3214, -50.4271, -69.0),
				new Jun3dPoint(50.0, -53.2195, -69.0),
				new Jun3dPoint(50.0, 47.9529, -76.0),
				new Jun3dPoint(53.6829, 44.5592, -76.0),
				new Jun3dPoint(57.3658, 41.1655, -76.0),
				new Jun3dPoint(61.0487, 37.7718, -76.0),
				new Jun3dPoint(64.4677, 34.1217, -76.0),
				new Jun3dPoint(67.7533, 30.342, -76.0),
				new Jun3dPoint(69.8211, 25.8077, -76.0),
				new Jun3dPoint(72.7931, 21.8337, -76.0),
				new Jun3dPoint(74.9031, 17.3014, -76.0),
				new Jun3dPoint(77.5302, 13.0398, -76.0),
				new Jun3dPoint(79.3391, 8.43524, -76.0),
				new Jun3dPoint(81.1889, 3.78642, -76.0),
				new Jun3dPoint(81.6978, -1.13112, -76.0),
				new Jun3dPoint(81.3485, -6.12703, -76.0),
				new Jun3dPoint(80.4393, -11.0139, -76.0),
				new Jun3dPoint(78.6569, -15.6905, -76.0),
				new Jun3dPoint(76.3085, -20.0666, -76.0),
				new Jun3dPoint(73.4767, -24.1855, -76.0),
				new Jun3dPoint(70.4147, -28.1486, -76.0),
				new Jun3dPoint(67.3481, -32.046, -76.0),
				new Jun3dPoint(64.1156, -35.848, -76.0),
				new Jun3dPoint(61.0537, -39.8111, -76.0),
				new Jun3dPoint(57.5593, -43.366, -76.0),
				new Jun3dPoint(53.7797, -46.6516, -76.0),
				new Jun3dPoint(50.0, -49.9373, -76.0),
				new Jun3dPoint(50.0, 42.8561, -83.0),
				new Jun3dPoint(53.719, 39.4291, -83.0),
				new Jun3dPoint(57.4381, 36.0021, -83.0),
				new Jun3dPoint(61.1826, 32.6093, -83.0),
				new Jun3dPoint(65.5371, 30.0376, -83.0),
				new Jun3dPoint(68.5723, 26.1664, -83.0),
				new Jun3dPoint(71.7975, 22.28, -83.0),
				new Jun3dPoint(74.5007, 18.0072, -83.0),
				new Jun3dPoint(76.746, 13.4865, -83.0),
				new Jun3dPoint(79.0115, 8.97579, -83.0),
				new Jun3dPoint(80.1336, 4.0803, -83.0),
				new Jun3dPoint(80.713, -0.8795, -83.0),
				new Jun3dPoint(80.3602, -5.92442, -83.0),
				new Jun3dPoint(79.4678, -10.8643, -83.0),
				new Jun3dPoint(77.6727, -15.5885, -83.0),
				new Jun3dPoint(75.3023, -20.0081, -83.0),
				new Jun3dPoint(72.4404, -24.1659, -83.0),
				new Jun3dPoint(69.3484, -28.1679, -83.0),
				new Jun3dPoint(65.5404, -31.4298, -83.0),
				new Jun3dPoint(61.4503, -34.3621, -83.0),
				new Jun3dPoint(57.6335, -37.68, -83.0),
				new Jun3dPoint(53.8167, -40.9978, -83.0),
				new Jun3dPoint(50.0, -44.3157, -83.0),
				new Jun3dPoint(50.0, 35.7405, -89.0),
				new Jun3dPoint(54.1852, 32.9446, -89.0),
				new Jun3dPoint(58.3704, 30.1487, -89.0),
				new Jun3dPoint(62.5556, 27.3527, -89.0),
				new Jun3dPoint(66.723, 24.5308, -89.0),
				new Jun3dPoint(70.7358, 21.522, -89.0),
				new Jun3dPoint(73.8007, 17.5552, -89.0),
				new Jun3dPoint(75.9697, 13.0238, -89.0),
				new Jun3dPoint(78.2876, 8.56556, -89.0),
				new Jun3dPoint(79.2678, 3.63826, -89.0),
				new Jun3dPoint(80.5224, -1.23605, -89.0),
				new Jun3dPoint(80.1787, -6.20435, -89.0),
				new Jun3dPoint(79.0007, -11.0311, -89.0),
				new Jun3dPoint(76.8, -15.3477, -89.0),
				new Jun3dPoint(74.4493, -19.7512, -89.0),
				new Jun3dPoint(70.9266, -23.3137, -89.0),
				new Jun3dPoint(67.128, -26.6158, -89.0),
				new Jun3dPoint(63.1173, -29.6188, -89.0),
				new Jun3dPoint(58.7449, -32.1117, -89.0),
				new Jun3dPoint(54.3724, -34.6047, -89.0),
				new Jun3dPoint(50.0, -37.0977, -89.0),
				new Jun3dPoint(50.0, 27.5363, -96.0),
				new Jun3dPoint(54.1645, 24.7542, -96.0),
				new Jun3dPoint(58.3291, 21.9721, -96.0),
				new Jun3dPoint(62.4936, 19.19, -96.0),
				new Jun3dPoint(66.6582, 16.4079, -96.0),
				new Jun3dPoint(69.9897, 12.68, -96.0),
				new Jun3dPoint(72.7587, 8.62856, -96.0),
				new Jun3dPoint(74.7739, 4.08909, -96.0),
				new Jun3dPoint(75.7097, -0.751952, -96.0),
				new Jun3dPoint(75.3603, -5.74811, -96.0),
				new Jun3dPoint(73.9587, -10.4971, -96.0),
				new Jun3dPoint(71.4862, -14.7805, -96.0),
				new Jun3dPoint(68.0017, -18.3609, -96.0),
				new Jun3dPoint(64.0297, -21.3993, -96.0),
				new Jun3dPoint(59.7005, -23.7886, -96.0),
				new Jun3dPoint(54.8502, -25.037, -96.0),
				new Jun3dPoint(50.0, -26.2855, -96.0) };
		return facePoints;
	}

	/**
	 * Answer the face patches.
	 * 
	 * @return int[][]
	 * @category Face
	 */
	protected static int[][] FacePatches() {
		int[][] facePatches = new int[][] {
				new int[] { 0, 1, 8 },
				new int[] { 1, 2, 10 },
				new int[] { 2, 3, 11 },
				new int[] { 3, 4, 12 },
				new int[] { 5, 0, 6 },
				new int[] { 6, 0, 7 },
				new int[] { 7, 0, 8 },
				new int[] { 8, 1, 9 },
				new int[] { 9, 1, 10 },
				new int[] { 10, 2, 11 },
				new int[] { 11, 3, 12 },
				new int[] { 12, 4, 13 },
				new int[] { 13, 4, 14 },
				new int[] { 14, 4, 15 },
				new int[] { 15, 4, 16 },
				new int[] { 5, 6, 19 },
				new int[] { 6, 7, 20 },
				new int[] { 7, 8, 21 },
				new int[] { 8, 9, 23 },
				new int[] { 9, 10, 24 },
				new int[] { 10, 11, 25 },
				new int[] { 11, 12, 26 },
				new int[] { 12, 13, 27 },
				new int[] { 13, 14, 28 },
				new int[] { 14, 15, 29 },
				new int[] { 15, 16, 30 },
				new int[] { 17, 5, 18 },
				new int[] { 18, 5, 19 },
				new int[] { 19, 6, 20 },
				new int[] { 20, 7, 21 },
				new int[] { 21, 8, 22 },
				new int[] { 22, 8, 23 },
				new int[] { 23, 9, 24 },
				new int[] { 24, 10, 25 },
				new int[] { 25, 11, 26 },
				new int[] { 26, 12, 27 },
				new int[] { 27, 13, 28 },
				new int[] { 28, 14, 29 },
				new int[] { 29, 15, 30 },
				new int[] { 30, 16, 31 },
				new int[] { 31, 16, 32 },
				new int[] { 17, 18, 35 },
				new int[] { 18, 19, 36 },
				new int[] { 19, 20, 37 },
				new int[] { 20, 21, 38 },
				new int[] { 21, 22, 39 },
				new int[] { 22, 23, 40 },
				new int[] { 23, 24, 41 },
				new int[] { 24, 25, 42 },
				new int[] { 25, 26, 43 },
				new int[] { 26, 27, 44 },
				new int[] { 27, 28, 45 },
				new int[] { 28, 29, 46 },
				new int[] { 29, 30, 48 },
				new int[] { 30, 31, 49 },
				new int[] { 31, 32, 50 },
				new int[] { 33, 17, 34 },
				new int[] { 34, 17, 35 },
				new int[] { 35, 18, 36 },
				new int[] { 36, 19, 37 },
				new int[] { 37, 20, 38 },
				new int[] { 38, 21, 39 },
				new int[] { 39, 22, 40 },
				new int[] { 40, 23, 41 },
				new int[] { 41, 24, 42 },
				new int[] { 42, 25, 43 },
				new int[] { 43, 26, 44 },
				new int[] { 44, 27, 45 },
				new int[] { 45, 28, 46 },
				new int[] { 46, 29, 47 },
				new int[] { 47, 29, 48 },
				new int[] { 48, 30, 49 },
				new int[] { 49, 31, 50 },
				new int[] { 50, 32, 51 },
				new int[] { 33, 34, 53 },
				new int[] { 34, 35, 54 },
				new int[] { 35, 36, 55 },
				new int[] { 36, 37, 56 },
				new int[] { 37, 38, 57 },
				new int[] { 38, 39, 59 },
				new int[] { 39, 40, 60 },
				new int[] { 40, 41, 61 },
				new int[] { 41, 42, 62 },
				new int[] { 42, 43, 63 },
				new int[] { 43, 44, 64 },
				new int[] { 44, 45, 65 },
				new int[] { 45, 46, 66 },
				new int[] { 46, 47, 67 },
				new int[] { 47, 48, 68 },
				new int[] { 48, 49, 69 },
				new int[] { 49, 50, 70 },
				new int[] { 50, 51, 71 },
				new int[] { 52, 33, 53 },
				new int[] { 53, 34, 54 },
				new int[] { 54, 35, 55 },
				new int[] { 55, 36, 56 },
				new int[] { 56, 37, 57 },
				new int[] { 57, 38, 58 },
				new int[] { 58, 38, 59 },
				new int[] { 59, 39, 60 },
				new int[] { 60, 40, 61 },
				new int[] { 61, 41, 62 },
				new int[] { 62, 42, 63 },
				new int[] { 63, 43, 64 },
				new int[] { 64, 44, 65 },
				new int[] { 65, 45, 66 },
				new int[] { 66, 46, 67 },
				new int[] { 67, 47, 68 },
				new int[] { 68, 48, 69 },
				new int[] { 69, 49, 70 },
				new int[] { 70, 50, 71 },
				new int[] { 71, 51, 72 },
				new int[] { 72, 51, 73 },
				new int[] { 52, 53, 75 },
				new int[] { 53, 54, 76 },
				new int[] { 54, 55, 77 },
				new int[] { 55, 56, 78 },
				new int[] { 56, 57, 79 },
				new int[] { 57, 58, 80 },
				new int[] { 58, 59, 81 },
				new int[] { 59, 60, 82 },
				new int[] { 60, 61, 83 },
				new int[] { 61, 62, 84 },
				new int[] { 62, 63, 86 },
				new int[] { 63, 64, 87 },
				new int[] { 64, 65, 88 },
				new int[] { 65, 66, 89 },
				new int[] { 66, 67, 90 },
				new int[] { 67, 68, 91 },
				new int[] { 68, 69, 92 },
				new int[] { 69, 70, 93 },
				new int[] { 70, 71, 94 },
				new int[] { 71, 72, 95 },
				new int[] { 72, 73, 96 },
				new int[] { 74, 52, 75 },
				new int[] { 75, 53, 76 },
				new int[] { 76, 54, 77 },
				new int[] { 77, 55, 78 },
				new int[] { 78, 56, 79 },
				new int[] { 79, 57, 80 },
				new int[] { 80, 58, 81 },
				new int[] { 81, 59, 82 },
				new int[] { 82, 60, 83 },
				new int[] { 83, 61, 84 },
				new int[] { 84, 62, 85 },
				new int[] { 85, 62, 86 },
				new int[] { 86, 63, 87 },
				new int[] { 87, 64, 88 },
				new int[] { 88, 65, 89 },
				new int[] { 89, 66, 90 },
				new int[] { 90, 67, 91 },
				new int[] { 91, 68, 92 },
				new int[] { 92, 69, 93 },
				new int[] { 93, 70, 94 },
				new int[] { 94, 71, 95 },
				new int[] { 95, 72, 96 },
				new int[] { 96, 73, 97 },
				new int[] { 74, 75, 99 },
				new int[] { 75, 76, 100 },
				new int[] { 76, 77, 101 },
				new int[] { 77, 78, 102 },
				new int[] { 78, 79, 103 },
				new int[] { 79, 80, 104 },
				new int[] { 80, 81, 105 },
				new int[] { 81, 82, 106 },
				new int[] { 82, 83, 107 },
				new int[] { 83, 84, 108 },
				new int[] { 84, 85, 109 },
				new int[] { 85, 86, 111 },
				new int[] { 86, 87, 112 },
				new int[] { 87, 88, 113 },
				new int[] { 88, 89, 114 },
				new int[] { 89, 90, 115 },
				new int[] { 90, 91, 116 },
				new int[] { 91, 92, 117 },
				new int[] { 92, 93, 118 },
				new int[] { 93, 94, 119 },
				new int[] { 94, 95, 120 },
				new int[] { 95, 96, 121 },
				new int[] { 96, 97, 122 },
				new int[] { 98, 74, 99 },
				new int[] { 99, 75, 100 },
				new int[] { 100, 76, 101 },
				new int[] { 101, 77, 102 },
				new int[] { 102, 78, 103 },
				new int[] { 103, 79, 104 },
				new int[] { 104, 80, 105 },
				new int[] { 105, 81, 106 },
				new int[] { 106, 82, 107 },
				new int[] { 107, 83, 108 },
				new int[] { 108, 84, 109 },
				new int[] { 109, 85, 110 },
				new int[] { 110, 85, 111 },
				new int[] { 111, 86, 112 },
				new int[] { 112, 87, 113 },
				new int[] { 113, 88, 114 },
				new int[] { 114, 89, 115 },
				new int[] { 115, 90, 116 },
				new int[] { 116, 91, 117 },
				new int[] { 117, 92, 118 },
				new int[] { 118, 93, 119 },
				new int[] { 119, 94, 120 },
				new int[] { 120, 95, 121 },
				new int[] { 121, 96, 122 },
				new int[] { 122, 97, 123 },
				new int[] { 98, 99, 125 },
				new int[] { 99, 100, 126 },
				new int[] { 100, 101, 127 },
				new int[] { 101, 102, 128 },
				new int[] { 102, 103, 129 },
				new int[] { 103, 104, 130 },
				new int[] { 104, 105, 131 },
				new int[] { 105, 106, 132 },
				new int[] { 106, 107, 133 },
				new int[] { 107, 108, 134 },
				new int[] { 108, 109, 135 },
				new int[] { 109, 110, 136 },
				new int[] { 110, 111, 137 },
				new int[] { 111, 112, 138 },
				new int[] { 112, 113, 139 },
				new int[] { 113, 114, 140 },
				new int[] { 114, 115, 141 },
				new int[] { 115, 116, 142 },
				new int[] { 116, 117, 143 },
				new int[] { 117, 118, 144 },
				new int[] { 118, 119, 145 },
				new int[] { 119, 120, 146 },
				new int[] { 120, 121, 147 },
				new int[] { 121, 122, 148 },
				new int[] { 122, 123, 149 },
				new int[] { 124, 98, 125 },
				new int[] { 125, 99, 126 },
				new int[] { 126, 100, 127 },
				new int[] { 127, 101, 128 },
				new int[] { 128, 102, 129 },
				new int[] { 129, 103, 130 },
				new int[] { 130, 104, 131 },
				new int[] { 131, 105, 132 },
				new int[] { 132, 106, 133 },
				new int[] { 133, 107, 134 },
				new int[] { 134, 108, 135 },
				new int[] { 135, 109, 136 },
				new int[] { 136, 110, 137 },
				new int[] { 137, 111, 138 },
				new int[] { 138, 112, 139 },
				new int[] { 139, 113, 140 },
				new int[] { 140, 114, 141 },
				new int[] { 141, 115, 142 },
				new int[] { 142, 116, 143 },
				new int[] { 143, 117, 144 },
				new int[] { 144, 118, 145 },
				new int[] { 145, 119, 146 },
				new int[] { 146, 120, 147 },
				new int[] { 147, 121, 148 },
				new int[] { 148, 122, 149 },
				new int[] { 149, 123, 150 },
				new int[] { 124, 125, 152 },
				new int[] { 125, 126, 153 },
				new int[] { 126, 127, 154 },
				new int[] { 127, 128, 155 },
				new int[] { 128, 129, 156 },
				new int[] { 129, 130, 157 },
				new int[] { 130, 131, 158 },
				new int[] { 131, 132, 159 },
				new int[] { 132, 133, 160 },
				new int[] { 133, 134, 161 },
				new int[] { 134, 135, 162 },
				new int[] { 135, 136, 163 },
				new int[] { 136, 137, 164 },
				new int[] { 137, 138, 165 },
				new int[] { 138, 139, 166 },
				new int[] { 139, 140, 167 },
				new int[] { 140, 141, 168 },
				new int[] { 141, 142, 169 },
				new int[] { 142, 143, 170 },
				new int[] { 143, 144, 171 },
				new int[] { 144, 145, 172 },
				new int[] { 145, 146, 173 },
				new int[] { 146, 147, 174 },
				new int[] { 147, 148, 175 },
				new int[] { 148, 149, 176 },
				new int[] { 149, 150, 177 },
				new int[] { 151, 124, 152 },
				new int[] { 152, 125, 153 },
				new int[] { 153, 126, 154 },
				new int[] { 154, 127, 155 },
				new int[] { 155, 128, 156 },
				new int[] { 156, 129, 157 },
				new int[] { 157, 130, 158 },
				new int[] { 158, 131, 159 },
				new int[] { 159, 132, 160 },
				new int[] { 160, 133, 161 },
				new int[] { 161, 134, 162 },
				new int[] { 162, 135, 163 },
				new int[] { 163, 136, 164 },
				new int[] { 164, 137, 165 },
				new int[] { 165, 138, 166 },
				new int[] { 166, 139, 167 },
				new int[] { 167, 140, 168 },
				new int[] { 168, 141, 169 },
				new int[] { 169, 142, 170 },
				new int[] { 170, 143, 171 },
				new int[] { 171, 144, 172 },
				new int[] { 172, 145, 173 },
				new int[] { 173, 146, 174 },
				new int[] { 174, 147, 175 },
				new int[] { 175, 148, 176 },
				new int[] { 176, 149, 177 },
				new int[] { 177, 150, 178 },
				new int[] { 151, 152, 180 },
				new int[] { 152, 153, 181 },
				new int[] { 153, 154, 182 },
				new int[] { 154, 155, 183 },
				new int[] { 155, 156, 184 },
				new int[] { 156, 157, 185 },
				new int[] { 157, 158, 186 },
				new int[] { 158, 159, 187 },
				new int[] { 159, 160, 188 },
				new int[] { 160, 161, 189 },
				new int[] { 161, 162, 190 },
				new int[] { 162, 163, 191 },
				new int[] { 163, 164, 192 },
				new int[] { 164, 165, 193 },
				new int[] { 165, 166, 194 },
				new int[] { 166, 167, 195 },
				new int[] { 167, 168, 196 },
				new int[] { 168, 169, 197 },
				new int[] { 169, 170, 198 },
				new int[] { 170, 171, 199 },
				new int[] { 171, 172, 200 },
				new int[] { 172, 173, 201 },
				new int[] { 173, 174, 202 },
				new int[] { 174, 175, 203 },
				new int[] { 175, 176, 204 },
				new int[] { 176, 177, 205 },
				new int[] { 177, 178, 206 },
				new int[] { 179, 151, 180 },
				new int[] { 180, 152, 181 },
				new int[] { 181, 153, 182 },
				new int[] { 182, 154, 183 },
				new int[] { 183, 155, 184 },
				new int[] { 184, 156, 185 },
				new int[] { 185, 157, 186 },
				new int[] { 186, 158, 187 },
				new int[] { 187, 159, 188 },
				new int[] { 188, 160, 189 },
				new int[] { 189, 161, 190 },
				new int[] { 190, 162, 191 },
				new int[] { 191, 163, 192 },
				new int[] { 192, 164, 193 },
				new int[] { 193, 165, 194 },
				new int[] { 194, 166, 195 },
				new int[] { 195, 167, 196 },
				new int[] { 196, 168, 197 },
				new int[] { 197, 169, 198 },
				new int[] { 198, 170, 199 },
				new int[] { 199, 171, 200 },
				new int[] { 200, 172, 201 },
				new int[] { 201, 173, 202 },
				new int[] { 202, 174, 203 },
				new int[] { 203, 175, 204 },
				new int[] { 204, 176, 205 },
				new int[] { 205, 177, 206 },
				new int[] { 206, 178, 207 },
				new int[] { 179, 180, 209 },
				new int[] { 180, 181, 210 },
				new int[] { 181, 182, 211 },
				new int[] { 182, 183, 212 },
				new int[] { 183, 184, 213 },
				new int[] { 184, 185, 214 },
				new int[] { 185, 186, 215 },
				new int[] { 186, 187, 216 },
				new int[] { 187, 188, 217 },
				new int[] { 188, 189, 218 },
				new int[] { 189, 190, 219 },
				new int[] { 190, 191, 220 },
				new int[] { 191, 192, 221 },
				new int[] { 192, 193, 222 },
				new int[] { 193, 194, 223 },
				new int[] { 194, 195, 224 },
				new int[] { 195, 196, 225 },
				new int[] { 196, 197, 226 },
				new int[] { 197, 198, 227 },
				new int[] { 198, 199, 228 },
				new int[] { 199, 200, 229 },
				new int[] { 200, 201, 230 },
				new int[] { 201, 202, 231 },
				new int[] { 202, 203, 232 },
				new int[] { 203, 204, 233 },
				new int[] { 204, 205, 234 },
				new int[] { 205, 206, 235 },
				new int[] { 206, 207, 236 },
				new int[] { 208, 179, 209 },
				new int[] { 209, 180, 210 },
				new int[] { 210, 181, 211 },
				new int[] { 211, 182, 212 },
				new int[] { 212, 183, 213 },
				new int[] { 213, 184, 214 },
				new int[] { 214, 185, 215 },
				new int[] { 215, 186, 216 },
				new int[] { 216, 187, 217 },
				new int[] { 217, 188, 218 },
				new int[] { 218, 189, 219 },
				new int[] { 219, 190, 220 },
				new int[] { 220, 191, 221 },
				new int[] { 221, 192, 222 },
				new int[] { 222, 193, 223 },
				new int[] { 223, 194, 224 },
				new int[] { 224, 195, 225 },
				new int[] { 225, 196, 226 },
				new int[] { 226, 197, 227 },
				new int[] { 227, 198, 228 },
				new int[] { 228, 199, 229 },
				new int[] { 229, 200, 230 },
				new int[] { 230, 201, 231 },
				new int[] { 231, 202, 232 },
				new int[] { 232, 203, 233 },
				new int[] { 233, 204, 234 },
				new int[] { 234, 205, 235 },
				new int[] { 235, 206, 236 },
				new int[] { 236, 207, 237 },
				new int[] { 208, 209, 238 },
				new int[] { 209, 210, 239 },
				new int[] { 210, 211, 240 },
				new int[] { 211, 212, 241 },
				new int[] { 212, 213, 242 },
				new int[] { 213, 214, 244 },
				new int[] { 214, 215, 245 },
				new int[] { 215, 216, 246 },
				new int[] { 216, 217, 247 },
				new int[] { 217, 218, 248 },
				new int[] { 218, 219, 249 },
				new int[] { 219, 220, 250 },
				new int[] { 220, 221, 251 },
				new int[] { 221, 222, 252 },
				new int[] { 222, 223, 253 },
				new int[] { 223, 224, 254 },
				new int[] { 224, 225, 255 },
				new int[] { 225, 226, 256 },
				new int[] { 226, 227, 256 },
				new int[] { 227, 228, 257 },
				new int[] { 228, 229, 258 },
				new int[] { 229, 230, 259 },
				new int[] { 230, 231, 260 },
				new int[] { 231, 232, 261 },
				new int[] { 232, 233, 263 },
				new int[] { 233, 234, 264 },
				new int[] { 234, 235, 265 },
				new int[] { 235, 236, 266 },
				new int[] { 236, 237, 267 },
				new int[] { 238, 209, 239 },
				new int[] { 239, 210, 240 },
				new int[] { 240, 211, 241 },
				new int[] { 241, 212, 242 },
				new int[] { 242, 213, 243 },
				new int[] { 243, 213, 244 },
				new int[] { 244, 214, 245 },
				new int[] { 245, 215, 246 },
				new int[] { 246, 216, 247 },
				new int[] { 247, 217, 248 },
				new int[] { 248, 218, 249 },
				new int[] { 249, 219, 250 },
				new int[] { 250, 220, 251 },
				new int[] { 251, 221, 252 },
				new int[] { 252, 222, 253 },
				new int[] { 253, 223, 254 },
				new int[] { 254, 224, 255 },
				new int[] { 255, 225, 256 },
				new int[] { 256, 227, 257 },
				new int[] { 257, 228, 258 },
				new int[] { 258, 229, 259 },
				new int[] { 259, 230, 260 },
				new int[] { 260, 231, 261 },
				new int[] { 261, 232, 262 },
				new int[] { 262, 232, 263 },
				new int[] { 263, 233, 264 },
				new int[] { 264, 234, 265 },
				new int[] { 265, 235, 266 },
				new int[] { 266, 236, 267 },
				new int[] { 238, 239, 268 },
				new int[] { 239, 240, 269 },
				new int[] { 240, 241, 270 },
				new int[] { 241, 242, 271 },
				new int[] { 242, 243, 272 },
				new int[] { 243, 244, 273 },
				new int[] { 244, 245, 274 },
				new int[] { 245, 246, 275 },
				new int[] { 246, 247, 277 },
				new int[] { 247, 248, 277 },
				new int[] { 248, 249, 278 },
				new int[] { 249, 250, 280 },
				new int[] { 250, 251, 280 },
				new int[] { 251, 252, 281 },
				new int[] { 252, 253, 282 },
				new int[] { 253, 254, 283 },
				new int[] { 254, 255, 284 },
				new int[] { 255, 256, 285 },
				new int[] { 256, 257, 286 },
				new int[] { 257, 258, 287 },
				new int[] { 258, 259, 288 },
				new int[] { 259, 260, 289 },
				new int[] { 260, 261, 290 },
				new int[] { 261, 262, 291 },
				new int[] { 262, 263, 292 },
				new int[] { 263, 264, 293 },
				new int[] { 264, 265, 294 },
				new int[] { 265, 266, 295 },
				new int[] { 266, 267, 296 },
				new int[] { 268, 239, 269 },
				new int[] { 269, 240, 270 },
				new int[] { 270, 241, 271 },
				new int[] { 271, 242, 272 },
				new int[] { 272, 243, 273 },
				new int[] { 273, 244, 274 },
				new int[] { 274, 245, 275 },
				new int[] { 275, 246, 276 },
				new int[] { 276, 246, 277 },
				new int[] { 277, 248, 278 },
				new int[] { 278, 249, 279 },
				new int[] { 279, 249, 280 },
				new int[] { 280, 251, 281 },
				new int[] { 281, 252, 282 },
				new int[] { 282, 253, 283 },
				new int[] { 283, 254, 284 },
				new int[] { 284, 255, 285 },
				new int[] { 285, 256, 286 },
				new int[] { 286, 257, 287 },
				new int[] { 287, 258, 288 },
				new int[] { 288, 259, 289 },
				new int[] { 289, 260, 290 },
				new int[] { 290, 261, 291 },
				new int[] { 291, 262, 292 },
				new int[] { 292, 263, 293 },
				new int[] { 293, 264, 294 },
				new int[] { 294, 265, 295 },
				new int[] { 295, 266, 296 },
				new int[] { 296, 267, 297 },
				new int[] { 268, 269, 299 },
				new int[] { 269, 270, 300 },
				new int[] { 270, 271, 301 },
				new int[] { 271, 272, 302 },
				new int[] { 272, 273, 303 },
				new int[] { 273, 274, 304 },
				new int[] { 274, 275, 305 },
				new int[] { 275, 276, 305 },
				new int[] { 276, 277, 306 },
				new int[] { 277, 278, 307 },
				new int[] { 278, 279, 308 },
				new int[] { 279, 280, 309 },
				new int[] { 280, 281, 310 },
				new int[] { 281, 282, 311 },
				new int[] { 282, 283, 312 },
				new int[] { 283, 284, 313 },
				new int[] { 284, 285, 314 },
				new int[] { 285, 286, 315 },
				new int[] { 286, 287, 316 },
				new int[] { 287, 288, 318 },
				new int[] { 288, 289, 319 },
				new int[] { 289, 290, 319 },
				new int[] { 290, 291, 321 },
				new int[] { 291, 292, 321 },
				new int[] { 292, 293, 322 },
				new int[] { 293, 294, 323 },
				new int[] { 294, 295, 324 },
				new int[] { 295, 296, 325 },
				new int[] { 296, 297, 326 },
				new int[] { 298, 268, 299 },
				new int[] { 299, 269, 300 },
				new int[] { 300, 270, 301 },
				new int[] { 301, 271, 302 },
				new int[] { 302, 272, 303 },
				new int[] { 303, 273, 304 },
				new int[] { 304, 274, 305 },
				new int[] { 305, 276, 306 },
				new int[] { 306, 277, 307 },
				new int[] { 307, 278, 308 },
				new int[] { 308, 279, 309 },
				new int[] { 309, 280, 310 },
				new int[] { 310, 281, 311 },
				new int[] { 311, 282, 312 },
				new int[] { 312, 283, 313 },
				new int[] { 313, 284, 314 },
				new int[] { 314, 285, 315 },
				new int[] { 315, 286, 316 },
				new int[] { 316, 287, 317 },
				new int[] { 317, 287, 318 },
				new int[] { 318, 288, 319 },
				new int[] { 319, 290, 320 },
				new int[] { 320, 290, 321 },
				new int[] { 321, 292, 322 },
				new int[] { 322, 293, 323 },
				new int[] { 323, 294, 324 },
				new int[] { 324, 295, 325 },
				new int[] { 325, 296, 326 },
				new int[] { 326, 297, 327 },
				new int[] { 298, 299, 329 },
				new int[] { 299, 300, 330 },
				new int[] { 300, 301, 331 },
				new int[] { 301, 302, 332 },
				new int[] { 302, 303, 333 },
				new int[] { 303, 304, 334 },
				new int[] { 304, 305, 335 },
				new int[] { 305, 306, 336 },
				new int[] { 306, 307, 337 },
				new int[] { 307, 308, 338 },
				new int[] { 308, 309, 339 },
				new int[] { 309, 310, 340 },
				new int[] { 310, 311, 341 },
				new int[] { 311, 312, 342 },
				new int[] { 312, 313, 343 },
				new int[] { 313, 314, 344 },
				new int[] { 314, 315, 345 },
				new int[] { 315, 316, 346 },
				new int[] { 316, 317, 347 },
				new int[] { 317, 318, 348 },
				new int[] { 318, 319, 349 },
				new int[] { 319, 320, 350 },
				new int[] { 320, 321, 351 },
				new int[] { 321, 322, 352 },
				new int[] { 322, 323, 353 },
				new int[] { 323, 324, 353 },
				new int[] { 324, 325, 354 },
				new int[] { 325, 326, 355 },
				new int[] { 326, 327, 356 },
				new int[] { 328, 298, 329 },
				new int[] { 329, 299, 330 },
				new int[] { 330, 300, 331 },
				new int[] { 331, 301, 332 },
				new int[] { 332, 302, 333 },
				new int[] { 333, 303, 334 },
				new int[] { 334, 304, 335 },
				new int[] { 335, 305, 336 },
				new int[] { 336, 306, 337 },
				new int[] { 337, 307, 338 },
				new int[] { 338, 308, 339 },
				new int[] { 339, 309, 340 },
				new int[] { 340, 310, 341 },
				new int[] { 341, 311, 342 },
				new int[] { 342, 312, 343 },
				new int[] { 343, 313, 344 },
				new int[] { 344, 314, 345 },
				new int[] { 345, 315, 346 },
				new int[] { 346, 316, 347 },
				new int[] { 347, 317, 348 },
				new int[] { 348, 318, 349 },
				new int[] { 349, 319, 350 },
				new int[] { 350, 320, 351 },
				new int[] { 351, 321, 352 },
				new int[] { 352, 322, 353 },
				new int[] { 353, 324, 354 },
				new int[] { 354, 325, 355 },
				new int[] { 355, 326, 356 },
				new int[] { 356, 327, 357 },
				new int[] { 328, 329, 359 },
				new int[] { 329, 330, 360 },
				new int[] { 330, 331, 361 },
				new int[] { 331, 332, 362 },
				new int[] { 332, 333, 363 },
				new int[] { 333, 334, 364 },
				new int[] { 334, 335, 365 },
				new int[] { 335, 336, 366 },
				new int[] { 336, 337, 367 },
				new int[] { 337, 338, 368 },
				new int[] { 338, 339, 369 },
				new int[] { 339, 340, 370 },
				new int[] { 340, 341, 371 },
				new int[] { 341, 342, 372 },
				new int[] { 342, 343, 373 },
				new int[] { 343, 344, 374 },
				new int[] { 344, 345, 375 },
				new int[] { 345, 346, 376 },
				new int[] { 346, 347, 377 },
				new int[] { 347, 348, 378 },
				new int[] { 348, 349, 379 },
				new int[] { 349, 350, 380 },
				new int[] { 350, 351, 381 },
				new int[] { 351, 352, 382 },
				new int[] { 352, 353, 383 },
				new int[] { 353, 354, 384 },
				new int[] { 354, 355, 385 },
				new int[] { 355, 356, 386 },
				new int[] { 356, 357, 388 },
				new int[] { 358, 328, 359 },
				new int[] { 359, 329, 360 },
				new int[] { 360, 330, 361 },
				new int[] { 361, 331, 362 },
				new int[] { 362, 332, 363 },
				new int[] { 363, 333, 364 },
				new int[] { 364, 334, 365 },
				new int[] { 365, 335, 366 },
				new int[] { 366, 336, 367 },
				new int[] { 367, 337, 368 },
				new int[] { 368, 338, 369 },
				new int[] { 369, 339, 370 },
				new int[] { 370, 340, 371 },
				new int[] { 371, 341, 372 },
				new int[] { 372, 342, 373 },
				new int[] { 373, 343, 374 },
				new int[] { 374, 344, 375 },
				new int[] { 375, 345, 376 },
				new int[] { 376, 346, 377 },
				new int[] { 377, 347, 378 },
				new int[] { 378, 348, 379 },
				new int[] { 379, 349, 380 },
				new int[] { 380, 350, 381 },
				new int[] { 381, 351, 382 },
				new int[] { 382, 352, 383 },
				new int[] { 383, 353, 384 },
				new int[] { 384, 354, 385 },
				new int[] { 385, 355, 386 },
				new int[] { 386, 356, 387 },
				new int[] { 387, 356, 388 },
				new int[] { 358, 359, 389 },
				new int[] { 359, 360, 390 },
				new int[] { 360, 361, 391 },
				new int[] { 361, 362, 393 },
				new int[] { 362, 363, 394 },
				new int[] { 363, 364, 395 },
				new int[] { 364, 365, 396 },
				new int[] { 365, 366, 397 },
				new int[] { 366, 367, 398 },
				new int[] { 367, 368, 399 },
				new int[] { 368, 369, 400 },
				new int[] { 369, 370, 401 },
				new int[] { 370, 371, 402 },
				new int[] { 371, 372, 403 },
				new int[] { 372, 373, 404 },
				new int[] { 373, 374, 405 },
				new int[] { 374, 375, 406 },
				new int[] { 375, 376, 407 },
				new int[] { 376, 377, 408 },
				new int[] { 377, 378, 409 },
				new int[] { 378, 379, 410 },
				new int[] { 379, 380, 411 },
				new int[] { 380, 381, 412 },
				new int[] { 381, 382, 413 },
				new int[] { 382, 383, 414 },
				new int[] { 383, 384, 415 },
				new int[] { 384, 385, 416 },
				new int[] { 385, 386, 417 },
				new int[] { 386, 387, 418 },
				new int[] { 387, 388, 419 },
				new int[] { 389, 359, 390 },
				new int[] { 390, 360, 391 },
				new int[] { 391, 361, 392 },
				new int[] { 392, 361, 393 },
				new int[] { 393, 362, 394 },
				new int[] { 394, 363, 395 },
				new int[] { 395, 364, 396 },
				new int[] { 396, 365, 397 },
				new int[] { 397, 366, 398 },
				new int[] { 398, 367, 399 },
				new int[] { 399, 368, 400 },
				new int[] { 400, 369, 401 },
				new int[] { 401, 370, 402 },
				new int[] { 402, 371, 403 },
				new int[] { 403, 372, 404 },
				new int[] { 404, 373, 405 },
				new int[] { 405, 374, 406 },
				new int[] { 406, 375, 407 },
				new int[] { 407, 376, 408 },
				new int[] { 408, 377, 409 },
				new int[] { 409, 378, 410 },
				new int[] { 410, 379, 411 },
				new int[] { 411, 380, 412 },
				new int[] { 412, 381, 413 },
				new int[] { 413, 382, 414 },
				new int[] { 414, 383, 415 },
				new int[] { 415, 384, 416 },
				new int[] { 416, 385, 417 },
				new int[] { 417, 386, 418 },
				new int[] { 418, 387, 419 },
				new int[] { 419, 388, 420 },
				new int[] { 389, 390, 421 },
				new int[] { 390, 391, 422 },
				new int[] { 391, 392, 423 },
				new int[] { 392, 393, 424 },
				new int[] { 393, 394, 426 },
				new int[] { 394, 395, 427 },
				new int[] { 395, 396, 428 },
				new int[] { 396, 397, 429 },
				new int[] { 397, 398, 430 },
				new int[] { 398, 399, 431 },
				new int[] { 399, 400, 431 },
				new int[] { 400, 401, 432 },
				new int[] { 401, 402, 433 },
				new int[] { 402, 403, 434 },
				new int[] { 403, 404, 436 },
				new int[] { 404, 405, 437 },
				new int[] { 405, 406, 439 },
				new int[] { 406, 407, 439 },
				new int[] { 407, 408, 440 },
				new int[] { 408, 409, 441 },
				new int[] { 409, 410, 442 },
				new int[] { 410, 411, 443 },
				new int[] { 411, 412, 444 },
				new int[] { 412, 413, 445 },
				new int[] { 413, 414, 446 },
				new int[] { 414, 415, 447 },
				new int[] { 415, 416, 448 },
				new int[] { 416, 417, 449 },
				new int[] { 417, 418, 450 },
				new int[] { 418, 419, 451 },
				new int[] { 419, 420, 452 },
				new int[] { 421, 390, 422 },
				new int[] { 422, 391, 423 },
				new int[] { 423, 392, 424 },
				new int[] { 424, 393, 425 },
				new int[] { 425, 393, 426 },
				new int[] { 426, 394, 427 },
				new int[] { 427, 395, 428 },
				new int[] { 428, 396, 429 },
				new int[] { 429, 397, 430 },
				new int[] { 430, 398, 431 },
				new int[] { 431, 400, 432 },
				new int[] { 432, 401, 433 },
				new int[] { 433, 402, 434 },
				new int[] { 434, 403, 435 },
				new int[] { 435, 403, 436 },
				new int[] { 436, 404, 437 },
				new int[] { 437, 405, 438 },
				new int[] { 438, 405, 439 },
				new int[] { 439, 407, 440 },
				new int[] { 440, 408, 441 },
				new int[] { 441, 409, 442 },
				new int[] { 442, 410, 443 },
				new int[] { 443, 411, 444 },
				new int[] { 444, 412, 445 },
				new int[] { 445, 413, 446 },
				new int[] { 446, 414, 447 },
				new int[] { 447, 415, 448 },
				new int[] { 448, 416, 449 },
				new int[] { 449, 417, 450 },
				new int[] { 450, 418, 451 },
				new int[] { 451, 419, 452 },
				new int[] { 452, 420, 453 },
				new int[] { 421, 422, 454 },
				new int[] { 422, 423, 455 },
				new int[] { 423, 424, 456 },
				new int[] { 424, 425, 457 },
				new int[] { 425, 426, 458 },
				new int[] { 426, 427, 459 },
				new int[] { 427, 428, 460 },
				new int[] { 428, 429, 461 },
				new int[] { 429, 430, 462 },
				new int[] { 430, 431, 463 },
				new int[] { 431, 432, 464 },
				new int[] { 432, 433, 465 },
				new int[] { 433, 434, 466 },
				new int[] { 434, 435, 467 },
				new int[] { 435, 436, 468 },
				new int[] { 436, 437, 470 },
				new int[] { 437, 438, 471 },
				new int[] { 438, 439, 472 },
				new int[] { 439, 440, 473 },
				new int[] { 440, 441, 474 },
				new int[] { 441, 442, 475 },
				new int[] { 442, 443, 476 },
				new int[] { 443, 444, 477 },
				new int[] { 444, 445, 478 },
				new int[] { 445, 446, 479 },
				new int[] { 446, 447, 480 },
				new int[] { 447, 448, 481 },
				new int[] { 448, 449, 482 },
				new int[] { 449, 450, 483 },
				new int[] { 450, 451, 484 },
				new int[] { 451, 452, 485 },
				new int[] { 452, 453, 486 },
				new int[] { 454, 422, 455 },
				new int[] { 455, 423, 456 },
				new int[] { 456, 424, 457 },
				new int[] { 457, 425, 458 },
				new int[] { 458, 426, 459 },
				new int[] { 459, 427, 460 },
				new int[] { 460, 428, 461 },
				new int[] { 461, 429, 462 },
				new int[] { 462, 430, 463 },
				new int[] { 463, 431, 464 },
				new int[] { 464, 432, 465 },
				new int[] { 465, 433, 466 },
				new int[] { 466, 434, 467 },
				new int[] { 467, 435, 468 },
				new int[] { 468, 436, 469 },
				new int[] { 469, 436, 470 },
				new int[] { 470, 437, 471 },
				new int[] { 471, 438, 472 },
				new int[] { 472, 439, 473 },
				new int[] { 473, 440, 474 },
				new int[] { 474, 441, 475 },
				new int[] { 475, 442, 476 },
				new int[] { 476, 443, 477 },
				new int[] { 477, 444, 478 },
				new int[] { 478, 445, 479 },
				new int[] { 479, 446, 480 },
				new int[] { 480, 447, 481 },
				new int[] { 481, 448, 482 },
				new int[] { 482, 449, 483 },
				new int[] { 483, 450, 484 },
				new int[] { 484, 451, 485 },
				new int[] { 485, 452, 486 },
				new int[] { 486, 453, 487 },
				new int[] { 454, 455, 488 },
				new int[] { 455, 456, 489 },
				new int[] { 456, 457, 490 },
				new int[] { 457, 458, 491 },
				new int[] { 458, 459, 492 },
				new int[] { 459, 460, 493 },
				new int[] { 460, 461, 494 },
				new int[] { 461, 462, 495 },
				new int[] { 462, 463, 496 },
				new int[] { 463, 464, 497 },
				new int[] { 464, 465, 498 },
				new int[] { 465, 466, 499 },
				new int[] { 466, 467, 500 },
				new int[] { 467, 468, 502 },
				new int[] { 468, 469, 503 },
				new int[] { 469, 470, 503 },
				new int[] { 470, 471, 505 },
				new int[] { 471, 472, 506 },
				new int[] { 472, 473, 507 },
				new int[] { 473, 474, 508 },
				new int[] { 474, 475, 509 },
				new int[] { 475, 476, 510 },
				new int[] { 476, 477, 511 },
				new int[] { 477, 478, 512 },
				new int[] { 478, 479, 513 },
				new int[] { 479, 480, 514 },
				new int[] { 480, 481, 515 },
				new int[] { 481, 482, 516 },
				new int[] { 482, 483, 517 },
				new int[] { 483, 484, 518 },
				new int[] { 484, 485, 519 },
				new int[] { 485, 486, 520 },
				new int[] { 486, 487, 521 },
				new int[] { 488, 455, 489 },
				new int[] { 489, 456, 490 },
				new int[] { 490, 457, 491 },
				new int[] { 491, 458, 492 },
				new int[] { 492, 459, 493 },
				new int[] { 493, 460, 494 },
				new int[] { 494, 461, 495 },
				new int[] { 495, 462, 496 },
				new int[] { 496, 463, 497 },
				new int[] { 497, 464, 498 },
				new int[] { 498, 465, 499 },
				new int[] { 499, 466, 500 },
				new int[] { 500, 467, 501 },
				new int[] { 501, 467, 502 },
				new int[] { 502, 468, 503 },
				new int[] { 503, 470, 504 },
				new int[] { 504, 470, 505 },
				new int[] { 505, 471, 506 },
				new int[] { 506, 472, 507 },
				new int[] { 507, 473, 508 },
				new int[] { 508, 474, 509 },
				new int[] { 509, 475, 510 },
				new int[] { 510, 476, 511 },
				new int[] { 511, 477, 512 },
				new int[] { 512, 478, 513 },
				new int[] { 513, 479, 514 },
				new int[] { 514, 480, 515 },
				new int[] { 515, 481, 516 },
				new int[] { 516, 482, 517 },
				new int[] { 517, 483, 518 },
				new int[] { 518, 484, 519 },
				new int[] { 519, 485, 520 },
				new int[] { 520, 486, 521 },
				new int[] { 488, 489, 522 },
				new int[] { 489, 490, 523 },
				new int[] { 490, 491, 524 },
				new int[] { 491, 492, 525 },
				new int[] { 492, 493, 526 },
				new int[] { 493, 494, 527 },
				new int[] { 494, 495, 528 },
				new int[] { 495, 496, 529 },
				new int[] { 496, 497, 530 },
				new int[] { 497, 498, 531 },
				new int[] { 498, 499, 532 },
				new int[] { 499, 500, 533 },
				new int[] { 500, 501, 534 },
				new int[] { 501, 502, 535 },
				new int[] { 502, 503, 536 },
				new int[] { 503, 504, 537 },
				new int[] { 504, 505, 538 },
				new int[] { 505, 506, 538 },
				new int[] { 506, 507, 539 },
				new int[] { 507, 508, 540 },
				new int[] { 508, 509, 542 },
				new int[] { 509, 510, 543 },
				new int[] { 510, 511, 544 },
				new int[] { 511, 512, 545 },
				new int[] { 512, 513, 546 },
				new int[] { 513, 514, 547 },
				new int[] { 514, 515, 548 },
				new int[] { 515, 516, 549 },
				new int[] { 516, 517, 550 },
				new int[] { 517, 518, 550 },
				new int[] { 518, 519, 552 },
				new int[] { 519, 520, 553 },
				new int[] { 520, 521, 554 },
				new int[] { 522, 489, 523 },
				new int[] { 523, 490, 524 },
				new int[] { 524, 491, 525 },
				new int[] { 525, 492, 526 },
				new int[] { 526, 493, 527 },
				new int[] { 527, 494, 528 },
				new int[] { 528, 495, 529 },
				new int[] { 529, 496, 530 },
				new int[] { 530, 497, 531 },
				new int[] { 531, 498, 532 },
				new int[] { 532, 499, 533 },
				new int[] { 533, 500, 534 },
				new int[] { 534, 501, 535 },
				new int[] { 535, 502, 536 },
				new int[] { 536, 503, 537 },
				new int[] { 537, 504, 538 },
				new int[] { 538, 506, 539 },
				new int[] { 539, 507, 540 },
				new int[] { 540, 508, 541 },
				new int[] { 541, 508, 542 },
				new int[] { 542, 509, 543 },
				new int[] { 543, 510, 544 },
				new int[] { 544, 511, 545 },
				new int[] { 545, 512, 546 },
				new int[] { 546, 513, 547 },
				new int[] { 547, 514, 548 },
				new int[] { 548, 515, 549 },
				new int[] { 549, 516, 550 },
				new int[] { 550, 518, 551 },
				new int[] { 551, 518, 552 },
				new int[] { 552, 519, 553 },
				new int[] { 553, 520, 554 },
				new int[] { 522, 523, 556 },
				new int[] { 523, 524, 557 },
				new int[] { 524, 525, 558 },
				new int[] { 525, 526, 559 },
				new int[] { 526, 527, 559 },
				new int[] { 527, 528, 560 },
				new int[] { 528, 529, 561 },
				new int[] { 529, 530, 562 },
				new int[] { 530, 531, 563 },
				new int[] { 531, 532, 564 },
				new int[] { 532, 533, 565 },
				new int[] { 533, 534, 566 },
				new int[] { 534, 535, 567 },
				new int[] { 535, 536, 568 },
				new int[] { 536, 537, 569 },
				new int[] { 537, 538, 570 },
				new int[] { 538, 539, 570 },
				new int[] { 539, 540, 571 },
				new int[] { 540, 541, 572 },
				new int[] { 541, 542, 573 },
				new int[] { 542, 543, 574 },
				new int[] { 543, 544, 575 },
				new int[] { 544, 545, 576 },
				new int[] { 545, 546, 577 },
				new int[] { 546, 547, 578 },
				new int[] { 547, 548, 579 },
				new int[] { 548, 549, 580 },
				new int[] { 549, 550, 581 },
				new int[] { 550, 551, 582 },
				new int[] { 551, 552, 583 },
				new int[] { 552, 553, 584 },
				new int[] { 553, 554, 585 },
				new int[] { 555, 522, 556 },
				new int[] { 556, 523, 557 },
				new int[] { 557, 524, 558 },
				new int[] { 558, 525, 559 },
				new int[] { 559, 527, 560 },
				new int[] { 560, 528, 561 },
				new int[] { 561, 529, 562 },
				new int[] { 562, 530, 563 },
				new int[] { 563, 531, 564 },
				new int[] { 564, 532, 565 },
				new int[] { 565, 533, 566 },
				new int[] { 566, 534, 567 },
				new int[] { 567, 535, 568 },
				new int[] { 568, 536, 569 },
				new int[] { 569, 537, 570 },
				new int[] { 570, 539, 571 },
				new int[] { 571, 540, 572 },
				new int[] { 572, 541, 573 },
				new int[] { 573, 542, 574 },
				new int[] { 574, 543, 575 },
				new int[] { 575, 544, 576 },
				new int[] { 576, 545, 577 },
				new int[] { 577, 546, 578 },
				new int[] { 578, 547, 579 },
				new int[] { 579, 548, 580 },
				new int[] { 580, 549, 581 },
				new int[] { 581, 550, 582 },
				new int[] { 582, 551, 583 },
				new int[] { 583, 552, 584 },
				new int[] { 584, 553, 585 },
				new int[] { 555, 556, 586 },
				new int[] { 556, 557, 587 },
				new int[] { 557, 558, 588 },
				new int[] { 558, 559, 589 },
				new int[] { 559, 560, 590 },
				new int[] { 560, 561, 591 },
				new int[] { 561, 562, 592 },
				new int[] { 562, 563, 593 },
				new int[] { 563, 564, 594 },
				new int[] { 564, 565, 595 },
				new int[] { 565, 566, 596 },
				new int[] { 566, 567, 597 },
				new int[] { 567, 568, 598 },
				new int[] { 568, 569, 599 },
				new int[] { 569, 570, 600 },
				new int[] { 570, 571, 601 },
				new int[] { 571, 572, 602 },
				new int[] { 572, 573, 603 },
				new int[] { 573, 574, 604 },
				new int[] { 574, 575, 605 },
				new int[] { 575, 576, 606 },
				new int[] { 576, 577, 607 },
				new int[] { 577, 578, 608 },
				new int[] { 578, 579, 609 },
				new int[] { 579, 580, 610 },
				new int[] { 580, 581, 611 },
				new int[] { 581, 582, 612 },
				new int[] { 582, 583, 613 },
				new int[] { 583, 584, 614 },
				new int[] { 584, 585, 615 },
				new int[] { 586, 556, 587 },
				new int[] { 587, 557, 588 },
				new int[] { 588, 558, 589 },
				new int[] { 589, 559, 590 },
				new int[] { 590, 560, 591 },
				new int[] { 591, 561, 592 },
				new int[] { 592, 562, 593 },
				new int[] { 593, 563, 594 },
				new int[] { 594, 564, 595 },
				new int[] { 595, 565, 596 },
				new int[] { 596, 566, 597 },
				new int[] { 597, 567, 598 },
				new int[] { 598, 568, 599 },
				new int[] { 599, 569, 600 },
				new int[] { 600, 570, 601 },
				new int[] { 601, 571, 602 },
				new int[] { 602, 572, 603 },
				new int[] { 603, 573, 604 },
				new int[] { 604, 574, 605 },
				new int[] { 605, 575, 606 },
				new int[] { 606, 576, 607 },
				new int[] { 607, 577, 608 },
				new int[] { 608, 578, 609 },
				new int[] { 609, 579, 610 },
				new int[] { 610, 580, 611 },
				new int[] { 611, 581, 612 },
				new int[] { 612, 582, 613 },
				new int[] { 613, 583, 614 },
				new int[] { 614, 584, 615 },
				new int[] { 586, 587, 616 },
				new int[] { 587, 588, 617 },
				new int[] { 588, 589, 618 },
				new int[] { 589, 590, 619 },
				new int[] { 590, 591, 620 },
				new int[] { 591, 592, 621 },
				new int[] { 592, 593, 622 },
				new int[] { 593, 594, 623 },
				new int[] { 594, 595, 624 },
				new int[] { 595, 596, 625 },
				new int[] { 596, 597, 626 },
				new int[] { 597, 598, 627 },
				new int[] { 598, 599, 628 },
				new int[] { 599, 600, 629 },
				new int[] { 600, 601, 630 },
				new int[] { 601, 602, 631 },
				new int[] { 602, 603, 632 },
				new int[] { 603, 604, 633 },
				new int[] { 604, 605, 634 },
				new int[] { 605, 606, 635 },
				new int[] { 606, 607, 636 },
				new int[] { 607, 608, 637 },
				new int[] { 608, 609, 638 },
				new int[] { 609, 610, 639 },
				new int[] { 610, 611, 640 },
				new int[] { 611, 612, 641 },
				new int[] { 612, 613, 642 },
				new int[] { 613, 614, 643 },
				new int[] { 614, 615, 644 },
				new int[] { 616, 587, 617 },
				new int[] { 617, 588, 618 },
				new int[] { 618, 589, 619 },
				new int[] { 619, 590, 620 },
				new int[] { 620, 591, 621 },
				new int[] { 621, 592, 622 },
				new int[] { 622, 593, 623 },
				new int[] { 623, 594, 624 },
				new int[] { 624, 595, 625 },
				new int[] { 625, 596, 626 },
				new int[] { 626, 597, 627 },
				new int[] { 627, 598, 628 },
				new int[] { 628, 599, 629 },
				new int[] { 629, 600, 630 },
				new int[] { 630, 601, 631 },
				new int[] { 631, 602, 632 },
				new int[] { 632, 603, 633 },
				new int[] { 633, 604, 634 },
				new int[] { 634, 605, 635 },
				new int[] { 635, 606, 636 },
				new int[] { 636, 607, 637 },
				new int[] { 637, 608, 638 },
				new int[] { 638, 609, 639 },
				new int[] { 639, 610, 640 },
				new int[] { 640, 611, 641 },
				new int[] { 641, 612, 642 },
				new int[] { 642, 613, 643 },
				new int[] { 643, 614, 644 },
				new int[] { 616, 617, 645 },
				new int[] { 617, 618, 646 },
				new int[] { 618, 619, 647 },
				new int[] { 619, 620, 648 },
				new int[] { 620, 621, 649 },
				new int[] { 621, 622, 650 },
				new int[] { 622, 623, 651 },
				new int[] { 623, 624, 652 },
				new int[] { 624, 625, 653 },
				new int[] { 625, 626, 654 },
				new int[] { 626, 627, 655 },
				new int[] { 627, 628, 656 },
				new int[] { 628, 629, 657 },
				new int[] { 629, 630, 658 },
				new int[] { 630, 631, 659 },
				new int[] { 631, 632, 660 },
				new int[] { 632, 633, 661 },
				new int[] { 633, 634, 662 },
				new int[] { 634, 635, 663 },
				new int[] { 635, 636, 664 },
				new int[] { 636, 637, 665 },
				new int[] { 637, 638, 666 },
				new int[] { 638, 639, 667 },
				new int[] { 639, 640, 668 },
				new int[] { 640, 641, 669 },
				new int[] { 641, 642, 670 },
				new int[] { 642, 643, 671 },
				new int[] { 643, 644, 672 },
				new int[] { 645, 617, 646 },
				new int[] { 646, 618, 647 },
				new int[] { 647, 619, 648 },
				new int[] { 648, 620, 649 },
				new int[] { 649, 621, 650 },
				new int[] { 650, 622, 651 },
				new int[] { 651, 623, 652 },
				new int[] { 652, 624, 653 },
				new int[] { 653, 625, 654 },
				new int[] { 654, 626, 655 },
				new int[] { 655, 627, 656 },
				new int[] { 656, 628, 657 },
				new int[] { 657, 629, 658 },
				new int[] { 658, 630, 659 },
				new int[] { 659, 631, 660 },
				new int[] { 660, 632, 661 },
				new int[] { 661, 633, 662 },
				new int[] { 662, 634, 663 },
				new int[] { 663, 635, 664 },
				new int[] { 664, 636, 665 },
				new int[] { 665, 637, 666 },
				new int[] { 666, 638, 667 },
				new int[] { 667, 639, 668 },
				new int[] { 668, 640, 669 },
				new int[] { 669, 641, 670 },
				new int[] { 670, 642, 671 },
				new int[] { 671, 643, 672 },
				new int[] { 645, 646, 673 },
				new int[] { 646, 647, 674 },
				new int[] { 647, 648, 675 },
				new int[] { 648, 649, 676 },
				new int[] { 649, 650, 677 },
				new int[] { 650, 651, 678 },
				new int[] { 651, 652, 679 },
				new int[] { 652, 653, 680 },
				new int[] { 653, 654, 681 },
				new int[] { 654, 655, 682 },
				new int[] { 655, 656, 683 },
				new int[] { 656, 657, 684 },
				new int[] { 657, 658, 685 },
				new int[] { 658, 659, 685 },
				new int[] { 659, 660, 686 },
				new int[] { 660, 661, 687 },
				new int[] { 661, 662, 688 },
				new int[] { 662, 663, 689 },
				new int[] { 663, 664, 690 },
				new int[] { 664, 665, 691 },
				new int[] { 665, 666, 692 },
				new int[] { 666, 667, 693 },
				new int[] { 667, 668, 694 },
				new int[] { 668, 669, 695 },
				new int[] { 669, 670, 696 },
				new int[] { 670, 671, 697 },
				new int[] { 671, 672, 698 },
				new int[] { 673, 646, 674 },
				new int[] { 674, 647, 675 },
				new int[] { 675, 648, 676 },
				new int[] { 676, 649, 677 },
				new int[] { 677, 650, 678 },
				new int[] { 678, 651, 679 },
				new int[] { 679, 652, 680 },
				new int[] { 680, 653, 681 },
				new int[] { 681, 654, 682 },
				new int[] { 682, 655, 683 },
				new int[] { 683, 656, 684 },
				new int[] { 684, 657, 685 },
				new int[] { 685, 659, 686 },
				new int[] { 686, 660, 687 },
				new int[] { 687, 661, 688 },
				new int[] { 688, 662, 689 },
				new int[] { 689, 663, 690 },
				new int[] { 690, 664, 691 },
				new int[] { 691, 665, 692 },
				new int[] { 692, 666, 693 },
				new int[] { 693, 667, 694 },
				new int[] { 694, 668, 695 },
				new int[] { 695, 669, 696 },
				new int[] { 696, 670, 697 },
				new int[] { 697, 671, 698 },
				new int[] { 673, 674, 699 },
				new int[] { 674, 675, 700 },
				new int[] { 675, 676, 701 },
				new int[] { 676, 677, 702 },
				new int[] { 677, 678, 703 },
				new int[] { 678, 679, 704 },
				new int[] { 679, 680, 705 },
				new int[] { 680, 681, 706 },
				new int[] { 681, 682, 707 },
				new int[] { 682, 683, 708 },
				new int[] { 683, 684, 709 },
				new int[] { 684, 685, 710 },
				new int[] { 685, 686, 711 },
				new int[] { 686, 687, 712 },
				new int[] { 687, 688, 713 },
				new int[] { 688, 689, 714 },
				new int[] { 689, 690, 715 },
				new int[] { 690, 691, 716 },
				new int[] { 691, 692, 717 },
				new int[] { 692, 693, 718 },
				new int[] { 693, 694, 719 },
				new int[] { 694, 695, 720 },
				new int[] { 695, 696, 721 },
				new int[] { 696, 697, 722 },
				new int[] { 697, 698, 723 },
				new int[] { 699, 674, 700 },
				new int[] { 700, 675, 701 },
				new int[] { 701, 676, 702 },
				new int[] { 702, 677, 703 },
				new int[] { 703, 678, 704 },
				new int[] { 704, 679, 705 },
				new int[] { 705, 680, 706 },
				new int[] { 706, 681, 707 },
				new int[] { 707, 682, 708 },
				new int[] { 708, 683, 709 },
				new int[] { 709, 684, 710 },
				new int[] { 710, 685, 711 },
				new int[] { 711, 686, 712 },
				new int[] { 712, 687, 713 },
				new int[] { 713, 688, 714 },
				new int[] { 714, 689, 715 },
				new int[] { 715, 690, 716 },
				new int[] { 716, 691, 717 },
				new int[] { 717, 692, 718 },
				new int[] { 718, 693, 719 },
				new int[] { 719, 694, 720 },
				new int[] { 720, 695, 721 },
				new int[] { 721, 696, 722 },
				new int[] { 722, 697, 723 },
				new int[] { 699, 700, 724 },
				new int[] { 700, 701, 725 },
				new int[] { 701, 702, 726 },
				new int[] { 702, 703, 727 },
				new int[] { 703, 704, 728 },
				new int[] { 704, 705, 729 },
				new int[] { 705, 706, 730 },
				new int[] { 706, 707, 731 },
				new int[] { 707, 708, 732 },
				new int[] { 708, 709, 733 },
				new int[] { 709, 710, 734 },
				new int[] { 710, 711, 735 },
				new int[] { 711, 712, 736 },
				new int[] { 712, 713, 736 },
				new int[] { 713, 714, 737 },
				new int[] { 714, 715, 738 },
				new int[] { 715, 716, 739 },
				new int[] { 716, 717, 740 },
				new int[] { 717, 718, 741 },
				new int[] { 718, 719, 742 },
				new int[] { 719, 720, 743 },
				new int[] { 720, 721, 744 },
				new int[] { 721, 722, 745 },
				new int[] { 722, 723, 746 },
				new int[] { 724, 700, 725 },
				new int[] { 725, 701, 726 },
				new int[] { 726, 702, 727 },
				new int[] { 727, 703, 728 },
				new int[] { 728, 704, 729 },
				new int[] { 729, 705, 730 },
				new int[] { 730, 706, 731 },
				new int[] { 731, 707, 732 },
				new int[] { 732, 708, 733 },
				new int[] { 733, 709, 734 },
				new int[] { 734, 710, 735 },
				new int[] { 735, 711, 736 },
				new int[] { 736, 713, 737 },
				new int[] { 737, 714, 738 },
				new int[] { 738, 715, 739 },
				new int[] { 739, 716, 740 },
				new int[] { 740, 717, 741 },
				new int[] { 741, 718, 742 },
				new int[] { 742, 719, 743 },
				new int[] { 743, 720, 744 },
				new int[] { 744, 721, 745 },
				new int[] { 745, 722, 746 },
				new int[] { 724, 725, 747 },
				new int[] { 725, 726, 748 },
				new int[] { 726, 727, 749 },
				new int[] { 727, 728, 750 },
				new int[] { 728, 729, 751 },
				new int[] { 729, 730, 752 },
				new int[] { 730, 731, 753 },
				new int[] { 731, 732, 753 },
				new int[] { 732, 733, 754 },
				new int[] { 733, 734, 755 },
				new int[] { 734, 735, 756 },
				new int[] { 735, 736, 757 },
				new int[] { 736, 737, 758 },
				new int[] { 737, 738, 759 },
				new int[] { 738, 739, 760 },
				new int[] { 739, 740, 761 },
				new int[] { 740, 741, 762 },
				new int[] { 741, 742, 763 },
				new int[] { 742, 743, 764 },
				new int[] { 743, 744, 765 },
				new int[] { 744, 745, 766 },
				new int[] { 745, 746, 767 },
				new int[] { 747, 725, 748 },
				new int[] { 748, 726, 749 },
				new int[] { 749, 727, 750 },
				new int[] { 750, 728, 751 },
				new int[] { 751, 729, 752 },
				new int[] { 752, 730, 753 },
				new int[] { 753, 732, 754 },
				new int[] { 754, 733, 755 },
				new int[] { 755, 734, 756 },
				new int[] { 756, 735, 757 },
				new int[] { 757, 736, 758 },
				new int[] { 758, 737, 759 },
				new int[] { 759, 738, 760 },
				new int[] { 760, 739, 761 },
				new int[] { 761, 740, 762 },
				new int[] { 762, 741, 763 },
				new int[] { 763, 742, 764 },
				new int[] { 764, 743, 765 },
				new int[] { 765, 744, 766 },
				new int[] { 766, 745, 767 },
				new int[] { 747, 748, 768 },
				new int[] { 748, 749, 769 },
				new int[] { 749, 750, 770 },
				new int[] { 750, 751, 771 },
				new int[] { 751, 752, 772 },
				new int[] { 752, 753, 772 },
				new int[] { 753, 754, 773 },
				new int[] { 754, 755, 774 },
				new int[] { 755, 756, 775 },
				new int[] { 756, 757, 776 },
				new int[] { 757, 758, 777 },
				new int[] { 758, 759, 777 },
				new int[] { 759, 760, 778 },
				new int[] { 760, 761, 779 },
				new int[] { 761, 762, 780 },
				new int[] { 762, 763, 781 },
				new int[] { 763, 764, 782 },
				new int[] { 764, 765, 782 },
				new int[] { 765, 766, 783 },
				new int[] { 766, 767, 784 },
				new int[] { 768, 748, 769 },
				new int[] { 769, 749, 770 },
				new int[] { 770, 750, 771 },
				new int[] { 771, 751, 772 },
				new int[] { 772, 753, 773 },
				new int[] { 773, 754, 774 },
				new int[] { 774, 755, 775 },
				new int[] { 775, 756, 776 },
				new int[] { 776, 757, 777 },
				new int[] { 777, 759, 778 },
				new int[] { 778, 760, 779 },
				new int[] { 779, 761, 780 },
				new int[] { 780, 762, 781 },
				new int[] { 781, 763, 782 },
				new int[] { 782, 765, 783 },
				new int[] { 783, 766, 784 } };
		return facePatches;
	}

	/**
	 * Answer the face display model with the specified face object.
	 * 
	 * @param faceObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @category Face
	 */
	public static JunOpenGLDisplayModel FaceDisplayModelFor_(JunOpenGL3dObject faceObject) {
		JunOpenGLDisplayModel displayModel = new JunOpenGLDisplayModel(faceObject);
		displayModel.displayLights()[1] = JunOpenGLDisplayLight.ParallelLight_color_position_(true, displayModel.defaultLightColor(), displayModel.defaultLightPoint().negated());
		displayModel.defaultSightPoint_(new Jun3dPoint(0, 0, 0));
		displayModel.defaultEyePoint_(new Jun3dPoint(1000, 0, 0));
		displayModel.defaultUpVector_(new Jun3dPoint(0, 0, 1));
		displayModel.defaultZoomHeight_(300);
		return displayModel;
	}

	/**
	 * Create face illusion movie(1) and open it.
	 * 
	 * @return jp.co.sra.jun.goodies.movie.framework.JunMoviePlayer
	 * @category Face
	 */
	public static JunMoviePlayer FaceIllusionMovie1() {
		final JunOpenGLDisplayModel displayModel = FaceDisplayModelFor_(Face());
		displayModel.open();
		final Jun3dPoint eyePoint = displayModel.eyePoint();
		final Jun3dLine rotationLine = new Jun3dLine(new Jun3dPoint(0, 0, 0), new Jun3dPoint(0, 0, 1));
		final int aTick = 100;
		File aFile = new File("FaceIllusion1.mov");
		JunImagesToMovie.File_extent_do_(aFile, displayModel.getView().toComponent().getBounds().getSize(), new StBlockClosure() {
			public Object value_(Object obj) {
				final JunImagesToMovie imagesToMovie = (JunImagesToMovie) obj;
				for (int angle = 0; angle <= 360; angle = angle + 3) {
					Jun3dTransformation aTransformation = Jun3dTransformation.Rotate_around_(JunAngle.FromDeg_(angle), rotationLine);
					Jun3dPoint aPoint = eyePoint.transform_(aTransformation);
					displayModel.getWindow().setVisible(true);
					displayModel.eyePoint_(aPoint);
					final StImage anImage = displayModel.asImage();
					JunControlUtility.Do_forMilliseconds_(new StBlockClosure() {
						public Object value() {
							imagesToMovie.add_milliseconds_(anImage, aTick);
							return null;
						}
					}, aTick);
				}
				return null;
			}
		});

		JunMoviePlayer aMovie = new JunMoviePlayer(aFile);
		if (aMovie == null) {
			return null;
		}
		aMovie.trackerModel().loop();
		aMovie.openAndPlay();
		return aMovie;
	}

	/**
	 * Create face illusion movie(2) and open it.
	 * 
	 * @return jp.co.sra.jun.goodies.movie.framework.JunMoviePlayer
	 * @category Face
	 */
	public static JunMoviePlayer FaceIllusionMovie2() {
		final JunOpenGLDisplayModel displayModel = FaceDisplayModelFor_(Face());
		displayModel.open();
		final Jun3dPoint eyePoint = displayModel.eyePoint();
		final Jun3dLine rotationLine = new Jun3dLine(new Jun3dPoint(0, 0, 0), new Jun3dPoint(0, 1, 0));
		final int aTick = 100;
		File aFile = new File("FaceIllusion2.mov");
		JunImagesToMovie.File_extent_do_(aFile, displayModel.getView().toComponent().getBounds().getSize(), new StBlockClosure() {
			public Object value_(Object obj) {
				final JunImagesToMovie imagesToMovie = (JunImagesToMovie) obj;
				for (int angle = 0; angle <= 360; angle = angle + 3) {
					Jun3dTransformation aTransformation = Jun3dTransformation.Rotate_around_(JunAngle.FromDeg_(angle), rotationLine);
					Jun3dPoint aPoint = eyePoint.transform_(aTransformation);
					displayModel.getWindow().setVisible(true);
					displayModel.eyePoint_(aPoint);
					final StImage anImage = displayModel.asImage();
					JunControlUtility.Do_forMilliseconds_(new StBlockClosure() {
						public Object value() {
							imagesToMovie.add_milliseconds_(anImage, aTick);
							return null;
						}
					}, aTick);
				}
				return null;
			}
		});

		JunMoviePlayer aMovie = new JunMoviePlayer(aFile);
		if (aMovie == null) {
			return null;
		}
		aMovie.trackerModel().loop();
		aMovie.openAndPlay();
		return aMovie;
	}

	/**
	 * Answer the face with bounding box as JunOpenGL3dObject.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Face
	 */
	public static JunOpenGL3dObject FaceWithBoundingBox() {
		Object[] anArray = FaceBoundingBoxAndTriangles();
		Jun3dBoundingBox boundingBox = (Jun3dBoundingBox) anArray[0];
		Jun3dTriangle[] faceTriangles = (Jun3dTriangle[]) anArray[1];
		JunOpenGL3dCompoundObject faceObject = new JunOpenGL3dCompoundObject();
		for (int i = 0; i < faceTriangles.length; i++) {
			faceObject.add_(faceTriangles[i].asJunOpenGL3dObjectColor_(FaceColor()));
		}
		faceObject.add_(boundingBox.asJunOpenGL3dObjectColor_(new Color(0, 255, 255, 64)));
		return faceObject;
	}

	/**
	 * Answer the face with bounding box and axes as JunOpenGL3dObject.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Face
	 */
	public static JunOpenGL3dObject FaceWithBoundingBoxAndAxes() {
		Object[] anArray = FaceBoundingBoxAndTriangles();
		Jun3dBoundingBox boundingBox = (Jun3dBoundingBox) anArray[0];
		Jun3dTriangle[] faceTriangles = (Jun3dTriangle[]) anArray[1];
		JunOpenGL3dCompoundObject faceObject = new JunOpenGL3dCompoundObject();
		for (int i = 0; i < faceTriangles.length; i++) {
			faceObject.add_(faceTriangles[i].asJunOpenGL3dObjectColor_(FaceColor()));
		}
		faceObject.add_(boundingBox.asJunOpenGL3dObjectColor_(new Color(0, 255, 255, 64)));
		faceObject.add_(JunOpenGL3dObject.XyzArrows().scaledBy_(Math.max(Math.max(boundingBox.width(), boundingBox.height()), boundingBox.height()) * 0.5).translatedBy_(boundingBox.center()));
		return faceObject;
	}

	/**
	 * Create a new instance of <code>JunOpenGLIllusion</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunOpenGLIllusion() {
		super();
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.jun.system.framework.JunAbstractObject#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		fluxModel = null;
		factorOfStages = null;
	}

	/**
	 * Answer my current flux model.
	 * 
	 * @return jp.co.sra.jun.opengl.flux.JunOpenGLFluxModel
	 * @category accessing
	 */
	public JunOpenGLFluxModel fluxModel() {
		if (fluxModel == null) {
			fluxModel = this.makeFluxModel();
		}
		return fluxModel;
	}

	/**
	 * Answer my current factor of stages.
	 * 
	 * @return java.util.List
	 * @category accessing
	 */
	public int[] factorOfStages() {
		if (factorOfStages == null) {
			factorOfStages = this.defaultFactorsOfStages();
		}
		return factorOfStages;
	}

	/**
	 * Set my frame factor.
	 * 
	 * @param scaleFactor int
	 * @category accessing
	 */
	public void frameFactor_(int scaleFactor) {
		int size = this.defaultFramesOfStages().size();
		int[] anArray = new int[size];
		for (int i = 0; i < size; i++) {
			anArray[i] = scaleFactor;
		}
		factorOfStages = anArray;
	}

	/**
	 * Answer the number of frames of the specified stage.
	 * 
	 * @param anIndex int
	 * @return int
	 * @category accessing
	 */
	public int framesOfStageAt_(int anIndex) {
		return ((Number) this.defaultFramesOfStages().get(anIndex - 1)).intValue() * this.frameFactorOfStageAt_(anIndex) + 1;
	}

	/**
	 * Answer the frame factor of the specified stage.
	 * 
	 * @param anIndex int
	 * @return int
	 * @category accessing
	 */
	public int frameFactorOfStageAt_(int anIndex) {
		return this.factorOfStages()[anIndex - 1];
	}

	/**
	 * Set the frame factor of the specified stage.
	 * 
	 * @param anIndex int
	 * @param scaleFactor int
	 * @category accessing
	 */
	public void frameFactorOfStageAt_put_(int anIndex, int scaleFactor) {
		this.factorOfStages(); // to make sure the instance variable is initialized.
		factorOfStages[anIndex - 1] = scaleFactor;
	}

	/**
	 * Answer the frames per second.
	 * 
	 * @return int
	 * @category accessing
	 */
	public int framesPerSecond() {
		return this.fluxModel().framesPerSecond();
	}

	/**
	 * Set the frames per second.
	 * 
	 * @return aNumber int
	 * @category accessing
	 */
	public void framesPerSecond_(int aNumber) {
		this.fluxModel().framesPerSecond_(aNumber);
	}

	/**
	 * Answer my current number of frames.
	 * 
	 * @return int
	 * @category accessing
	 */
	public int numberOfFrames() {
		int numberOfFrames = 0;
		for (int index = 0; index < this.numberOfStages(); index++) {
			numberOfFrames += this.framesOfStageAt_(index);
		}
		return numberOfFrames;
	}

	/**
	 * Answer my current number of stages.
	 * 
	 * @return int
	 * @category accessing
	 */
	public int numberOfStages() {
		return this.defaultFramesOfStages().size();
	}

	/**
	 * Answer my default factors of stages.
	 * 
	 * @return int[]
	 * @category defaults
	 */
	protected int[] defaultFactorsOfStages() {
		int size = this.defaultFramesOfStages().size();
		int[] factors = new int[size];
		for (int i = 0; i < size; i++) {
			factors[i] = this.defaultFrameFactor();
		}
		return factors;
	}

	/**
	 * Answer my default frame factor.
	 * 
	 * @return int
	 * @category defaults
	 */
	protected int defaultFrameFactor() {
		return 1;
	}

	/**
	 * Answer my default frame factors of stages.
	 * 
	 * @return java.uitl.List
	 * @category defaults
	 */
	protected List defaultFramesOfStages() {
		return new ArrayList();
	}

	/**
	 * Answer my default eye point.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @category defaults
	 */
	protected Jun3dPoint defaultEyePoint() {
		return new Jun3dPoint(0, 0, 100);
	}

	/**
	 * Answer my default sight point.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @category defaults
	 */
	protected Jun3dPoint defaultSightPoint() {
		return new Jun3dPoint(0, 0, 0);
	}

	/**
	 * Answer my default up vector.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @category defaults
	 */
	protected Jun3dPoint defaultUpVector() {
		return new Jun3dPoint(0, 1, 0);
	}

	/**
	 * Answer my default zoom height.
	 * 
	 * @return double
	 * @category defaults
	 */
	protected double defaultZoomHeight() {
		return 12;
	}

	/**
	 * Show the JunOpenGLIllusion.
	 * 
	 * @return jp.co.sra.jun.opengl.flux.JunOpenGLFluxModel
	 * @category viewing
	 */
	public JunOpenGLFluxModel show() {
		JunOpenGLFluxModel aFluxModel = this.fluxModel();
		aFluxModel.trackerModel().backAndForth();
		aFluxModel.defaultEyePoint_(this.defaultEyePoint());
		aFluxModel.defaultSightPoint_(this.defaultSightPoint());
		aFluxModel.defaultUpVector_(this.defaultUpVector());
		aFluxModel.defaultZoomHeight_(this.defaultZoomHeight());
		aFluxModel.displayLight1().beOff();
		aFluxModel.displayLight5().beOff();
		aFluxModel.open();
		aFluxModel.parallelProjection();
		return aFluxModel;
	}

	/**
	 * Answer the array of Jun3dTransformations.
	 * 
	 * @param startPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param endPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param stepNumber int
	 * @return jp.co.sra.jun.geometry.transformations.Jun3dTransformation
	 * @category transforming
	 */
	protected Jun3dTransformation[] transformationsFrom_to_step_(Jun3dPoint startPoint, Jun3dPoint endPoint, int stepNumber) {
		ArrayList aList = new ArrayList(stepNumber);
		Jun3dPoint aPoint = startPoint;
		Jun3dTransformation aTransformation = Jun3dTransformation.Translate_(aPoint);
		aList.add(aTransformation);

		if (stepNumber > 1) {
			Jun3dPoint stepPoint = endPoint.minus_(startPoint).dividedBy_(stepNumber - 1);
			for (int i = 1; i < stepNumber; i++) {
				aPoint = aPoint.plus_(stepPoint);
				aTransformation = Jun3dTransformation.Translate_(aPoint);
				aList.add(aTransformation);
			}
		}

		return (Jun3dTransformation[]) aList.toArray(new Jun3dTransformation[aList.size()]);
	}

	/**
	 * Create my flux model.
	 * 
	 * @return jp.co.sra.jun.opengl.flux.JunOpenGLFluxModel
	 * @category making
	 */
	protected abstract JunOpenGLFluxModel makeFluxModel();
}
