package jp.co.sra.jun.opengl.rotation;

import java.awt.Color;
import java.awt.Cursor;
import java.io.File;
import java.io.IOException;

import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.opengl.display.JunOpenGLEmbeddedDisplayModel;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.jun.topology.elements.JunBody;

/**
 * JunOpenGLRotationApplicationModel class
 * 
 *  @author    nisinaka
 *  @created   1998/12/09 (by nisinaka)
 *  @updated   2004/09/22 (by nisinaka)
 *  @updated   2006/04/13 (by Mitsuhiro Asada)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLRotationApplicationModel.java,v 8.10 2008/02/20 06:32:49 nisinaka Exp $
 */
public class JunOpenGLRotationApplicationModel extends JunApplicationModel {
	/** The instance of JunOpenGLRotationModel. */
	protected JunOpenGLRotationModel rotationModel;

	/** The instance of JunOpenGLEmbeddedDisplayModel. */
	protected JunOpenGLEmbeddedDisplayModel displayModel;

	/** The number of divisions. */
	protected int divisions;

	/**
	 * Initialize the receiver when created.
	 * 
	 * @see jp.co.sra.smalltalk.StApplicationModel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		rotationModel = null;
		displayModel = null;
		divisions = Integer.MIN_VALUE;
	}

	/**
	 * Answer the instance of JunOpenGLEmbeddedDisplayModel.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLEmbeddedDisplayModel
	 * @category accessing
	 */
	public final JunOpenGLEmbeddedDisplayModel displayModel() {
		if (displayModel == null) {
			displayModel = new JunOpenGLEmbeddedDisplayModel();
		}
		return displayModel;
	}

	/**
	 * Answer the instance of JunOpenGLRotationModel.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLRotationModel
	 * @category accessing
	 */
	public JunOpenGLRotationModel rotationModel() {
		if (rotationModel == null) {
			rotationModel = new JunOpenGLRotationModel();
			rotationModel.openBlock_(new StBlockClosure() {
				public Object value_(Object anObject) {
					File aFile = (File) anObject;
					JunOpenGLRotationApplicationModel anApplicationModel = new JunOpenGLRotationApplicationModel();
					try {
						anApplicationModel.rotationModel().readFromLRT10_(aFile);
					} catch (IOException e) {
						System.err.println(e.getMessage());
						e.printStackTrace();
					}
					if (anApplicationModel.rotationModel().numVertices() > 0) {
						anApplicationModel.open();
					}
					return null;
				}
			});
			rotationModel.addDependent_(this);
		}

		return rotationModel;
	}

	/**
	 * Rotate the contents of the rotation model, create a body, and show it on a display model.
	 * 
	 * @category actions
	 */
	protected void doRotate() {
		JunCursors cursor = new JunCursors(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
		try {
			cursor._show();

			JunBody aBody = this.rotationModel.rotatedBody_(this.divisions());
			if (aBody != null) {
				JunOpenGL3dObject displayObject = aBody.asJunOpenGL3dObject();
				displayObject.paint_(Color.white);
				this.displayModel().displayObject_(displayObject);
			}
		} finally {
			cursor._restore();
		}
	}

	/**
	 * Answer the integer value as a division number.
	 * 
	 * @return int
	 * @category aspects
	 */
	public int divisions() {
		if (divisions == Integer.MIN_VALUE) {
			divisions = this.rotationModel().lastDivisions();
		}
		return divisions;
	}

	/**
	 * Set the number of divisions.
	 * 
	 * @param anInteger int
	 * @category aspects
	 */
	public void divisions_(int anInteger) {
		divisions = anInteger;
		this.changed_($("divisions"));
	}

	/**
	 * Answer a default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StApplicationModel#defaultView()
	 * @category defaults
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunOpenGLRotationApplicationViewAwt(this);
		} else {
			return new JunOpenGLRotationApplicationViewSwing(this);
		}
	}

	/**
	 * Create the windows for the receiver. .
	 * 
	 * @return java.lang.String
	 * @see jp.co.sra.smalltalk.StApplicationModel#windowTitle()
	 * @category interface opening
	 */
	protected String windowTitle() {
		return JunSystem.$String("Rotation Modeler");
	}

	/**
	 * Update the receiver according to the change notification from the model.
	 * 
	 * @param evt jp.co.sra.smalltalk.DependentEvent
	 * @see jp.co.sra.smalltalk.DependentListener#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @category updating
	 */
	public void update_(DependentEvent evt) {
		if (evt.getAspect() == $("polyline")) {
			this.divisions_(this.rotationModel().lastDivisions());
			this.displayModel().displayObject_(null);
		}
	}
}
