package jp.co.sra.jun.opengl.rotation;

import java.io.*;
import jp.co.sra.jun.geometry.basic.*;

/**
 * JunOpenGLRotationApplicationModelTestExamples class
 * 
 *  @author    nisinaka
 *  @created   1998/12/17 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLRotationApplicationModelTestExamples.java,v 8.10 2008/02/20 06:32:49 nisinaka Exp $
 */
public class JunOpenGLRotationApplicationModelTestExamples extends jp.co.sra.jun.system.support.JunTestExamples {

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 */
	public static boolean Example1() {
		(new JunOpenGLRotationApplicationModel()).open();

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 */
	public static boolean Example2() {
		JunOpenGLRotationApplicationModel model = new JunOpenGLRotationApplicationModel();
		int divisions = 30;

		for (int i = 0; i < divisions; i++) {
			JunAngle angle = JunAngle.FromDeg_((360 * i) / divisions);
			model.rotationModel().addVertex_(new Jun2dPoint(angle.cos(), angle.sin() + 2.0d));
		}

		model.rotationModel().polyline().loop_(true);
		model.divisions_(divisions);
		model.open();
		model.open();

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 */
	public static boolean Example3() {
		JunOpenGLRotationApplicationModel model = new JunOpenGLRotationApplicationModel();
		int divisions = 30;

		for (int i = 0; i <= divisions; i++) {
			JunAngle angle = JunAngle.FromDeg_((180 * i) / divisions);
			model.rotationModel().addVertex_(new Jun2dPoint(angle.cos(), angle.sin()));
		}

		model.divisions_(divisions);
		model.open();

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 */
	public static boolean Example4() {
		JunOpenGLRotationApplicationModel model = new JunOpenGLRotationApplicationModel();
		int divisions = 30;

		for (int i = 0; i <= divisions; i++) {
			JunAngle angle = JunAngle.FromDeg_((180 * i) / divisions);
			model.rotationModel().addVertex_(new Jun2dPoint(angle.cos(), (2.0d + angle.multipliedBy_(4).sin()) / 4));
		}

		model.divisions_(divisions);
		model.open();

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 */
	public static boolean Example5() {
		JunOpenGLRotationApplicationModel model = new JunOpenGLRotationApplicationModel();
		model.rotationModel().addVertex_(new Jun2dPoint(2.5 - 2.25, 0.0));
		model.rotationModel().addVertex_(new Jun2dPoint(2.5 - 2.0, 0.75));
		model.rotationModel().addVertex_(new Jun2dPoint(2.5 - 1.0, 1.5));
		model.rotationModel().addVertex_(new Jun2dPoint(2.5 - 0.0, 1.8));
		model.rotationModel().addVertex_(new Jun2dPoint(2.5 - 0.0, 2.0));
		model.rotationModel().addVertex_(new Jun2dPoint(2.5 - 1.2, 1.75));
		model.rotationModel().addVertex_(new Jun2dPoint(2.5 - 2.25, 1.0));
		model.rotationModel().addVertex_(new Jun2dPoint(2.5 - 2.75, 0.25));
		model.rotationModel().addVertex_(new Jun2dPoint(2.5 - 4.25, 0.25));
		model.rotationModel().addVertex_(new Jun2dPoint(2.5 - 5.0, 1.25));
		model.rotationModel().addVertex_(new Jun2dPoint(2.5 - 5.0, 1.75));
		model.rotationModel().addVertex_(new Jun2dPoint(2.5 - 5.25, 1.75));
		model.rotationModel().swapXY_(true);
		model.rotationModel().grid_(0.25);
		model.rotationModel().zoomOut();
		model.open();

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 */
	public static boolean Example6() {
		JunOpenGLRotationApplicationModel model = new JunOpenGLRotationApplicationModel();
		model.rotationModel().addVertex_(new Jun2dPoint(0.76d, 0.2d));
		model.rotationModel().addVertex_(new Jun2dPoint(0.66d, 0.2d));
		model.rotationModel().addVertex_(new Jun2dPoint(0.53d, 0.21d));
		model.rotationModel().addVertex_(new Jun2dPoint(0.41d, 0.27d));
		model.rotationModel().addVertex_(new Jun2dPoint(0.29d, 0.35d));
		model.rotationModel().addVertex_(new Jun2dPoint(0.21d, 0.47d));
		model.rotationModel().addVertex_(new Jun2dPoint(0.17d, 0.64d));
		model.rotationModel().addVertex_(new Jun2dPoint(0.17d, 0.86d));
		model.rotationModel().addVertex_(new Jun2dPoint(0.21d, 1.03d));
		model.rotationModel().addVertex_(new Jun2dPoint(0.28d, 1.13d));
		model.rotationModel().addVertex_(new Jun2dPoint(0.39d, 1.22d));
		model.rotationModel().addVertex_(new Jun2dPoint(0.48d, 1.31d));
		model.rotationModel().addVertex_(new Jun2dPoint(0.53d, 1.42d));
		model.rotationModel().addVertex_(new Jun2dPoint(0.53d, 1.57d));
		model.rotationModel().addVertex_(new Jun2dPoint(0.47d, 1.67d));
		model.rotationModel().addVertex_(new Jun2dPoint(0.38d, 1.73d));
		model.rotationModel().addVertex_(new Jun2dPoint(0.23d, 1.74d));
		model.rotationModel().addVertex_(new Jun2dPoint(0.06d, 1.7d));
		model.rotationModel().addVertex_(new Jun2dPoint(-0.1d, 1.56d));
		model.rotationModel().addVertex_(new Jun2dPoint(-0.25d, 1.39d));
		model.rotationModel().addVertex_(new Jun2dPoint(-0.34d, 1.25d));
		model.rotationModel().addVertex_(new Jun2dPoint(-0.47d, 1.17d));
		model.rotationModel().addVertex_(new Jun2dPoint(-0.67d, 1.15d));
		model.rotationModel().addVertex_(new Jun2dPoint(-0.88d, 1.16d));
		model.rotationModel().swapXY_(true);
		model.rotationModel().grid_(0.25);
		model.rotationModel().zoomOut();
		model.divisions_(30);
		model.open();

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 */
	public static boolean Example7() {
		StringWriter aStringWriter = new StringWriter();
		PrintWriter aPrintWriter = new PrintWriter(aStringWriter);
		aPrintWriter.println("%LRT V1.0 List Rotation Transmission (Lisp S Expression)");
		aPrintWriter.println("% This file was created by Jun170");
		aPrintWriter.println("% 98/03/11 10:54:03 AM");
		aPrintWriter.println();
		aPrintWriter.println("(JunOpenGLRotationModel (scale . 100)");
		aPrintWriter.println("  (swapXY . {true})");
		aPrintWriter.println("  (showXAxis . {true})");
		aPrintWriter.println("  (showYAxis . {true})");
		aPrintWriter.println("  (grid . {nil})");
		aPrintWriter.println("  (divisions . 30)");
		aPrintWriter.println("  (JunOpenGLRotationPolyline (loop . {false})");
		aPrintWriter.println("    (points {(-0.93d , 0.65d)}");
		aPrintWriter.println("      {(-0.89d , 0.65d)}");
		aPrintWriter.println("      {(-0.85d , 0.56d)}");
		aPrintWriter.println("      {(-0.83d , 0.41d)}");
		aPrintWriter.println("      {(-0.8d , 0.24d)}");
		aPrintWriter.println("      {(-0.73d , 0.15d)}");
		aPrintWriter.println("      {(-0.64d , 0.11d)}");
		aPrintWriter.println("      {(-0.11d , 0.11d)}");
		aPrintWriter.println("      {(-0.01d , 0.17d)}");
		aPrintWriter.println("      {(0.05d , 0.27d)}");
		aPrintWriter.println("      {(0.12d , 0.42d)}");
		aPrintWriter.println("      {(0.17d , 0.59d)}");
		aPrintWriter.println("      {(0.23d , 0.71d)}");
		aPrintWriter.println("      {(0.33d , 0.83d)}");
		aPrintWriter.println("      {(0.43d , 0.88d)}");
		aPrintWriter.println("      {(0.61d , 0.91d)}");
		aPrintWriter.println("      {(0.76d , 0.91d)}");
		aPrintWriter.println("      {(0.76d , 0.82d)}");
		aPrintWriter.println("      {(0.6d , 0.82d)}");
		aPrintWriter.println("      {(0.47d , 0.78d)}");
		aPrintWriter.println("      {(0.38d , 0.73d)}");
		aPrintWriter.println("      {(0.31d , 0.63d)}");
		aPrintWriter.println("      {(0.26d , 0.52d)}");
		aPrintWriter.println("      {(0.22d , 0.37d)}");
		aPrintWriter.println("      {(0.18d , 0.17d)})))");
		aPrintWriter.flush();

		StringReader aStringReader = new StringReader(aStringWriter.toString());
		BufferedReader aBufferedReader = new BufferedReader(aStringReader);
		JunOpenGLRotationApplicationModel anApplicationModel = new JunOpenGLRotationApplicationModel();

		try {
			anApplicationModel.rotationModel().loadFromLRT10_(aBufferedReader);
		} catch (IOException e) {
			return false;
		}

		anApplicationModel.open();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunOpenGLRotationApplicationModelTestExamples();
	}
}
