package jp.co.sra.jun.opengl.rotation;

import java.awt.Point;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.system.framework.JunAbstractView;

/**
 * JunOpenGLRotationView interface
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   2000/01/20 (by MATSUDA Ryouichi)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun473 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLRotationView.java,v 8.10 2008/02/20 06:32:49 nisinaka Exp $
 */
public interface JunOpenGLRotationView extends JunAbstractView {

	/**
	 * Answer the de-scaled vertex at the specified Point.
	 * 
	 * @param aPoint java.awt.Point
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint
	 */
	public Jun2dPoint descaledPoint_(Point aPoint);

	/**
	 * Answer the scaled point of the Jun2dPoint.
	 * 
	 * @param aJun2dPoint jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * 
	 * @return java.awt.Point
	 */
	public Point scaledPoint_(Jun2dPoint aJun2dPoint);

	/**
	 * Answer the index of the vertex at the specified point. If there is no
	 * such vertex, return -1.
	 * 
	 * @param aPoint java.awt.Point
	 * 
	 * @return int
	 */
	public int scaledVertexIndex_(Point aPoint);

}
