package jp.co.sra.jun.opengl.roughsketch;

import java.awt.Color;
import java.awt.Point;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.smalltalk.StView;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.forms.JunFormTriangulation2;
import jp.co.sra.jun.geometry.surfaces.Jun2dTriangle;
import jp.co.sra.jun.geometry.surfaces.Jun3dTriangle;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.goodies.button.JunButtonModel;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolylineLoop;
import jp.co.sra.jun.system.framework.JunDialog;

/**
 * JunOpenGLRoughSketch class
 * 
 *  @author    nisinaka
 *  @created   2005/10/25 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun608 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLRoughSketch.java,v 8.10 2008/02/20 06:32:49 nisinaka Exp $
 */
public class JunOpenGLRoughSketch extends JunOpenGLDisplayModel {

	public static final Color NibColor = Color.red;
	public static final float NibWidth = 1;
	public static final double MinimumDistance = 4;

	/**
	 * Answer my pencil button.
	 * 
	 * @return jp.co.sra.jun.goodies.button.JunButtonModel
	 * @category buttons
	 */
	public JunButtonModel pencilButton() {
		if (this.pushButtons().containsKey($("pencil")) == false) {
			JunButtonModel button = new JunButtonModel();
			button.value_(false);
			button.visual_(JunCursors.PencilCursorImage());
			button.action_(new StBlockClosure() {
				public Object value_(Object o) {
					JunButtonModel model = (JunButtonModel) o;
					setButtonState($("pencil"), !model.value());
					return null;
				}
			});
			this.pushButtons().put($("pencil"), button);
		}
		return (JunButtonModel) this.pushButtons().get($("pencil"));
	}

	/**
	 * Answer my default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StApplicationModel#defaultView()
	 * @category interface opening
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunOpenGLRoughSketchViewAwt(this);
		} else {
			return new JunOpenGLRoughSketchViewSwing(this);
		}
	}

	/**
	 * Answer my window title.
	 * 
	 * @return java.lang.String
	 * @see jp.co.sra.smalltalk.StApplicationModel#windowTitle()
	 * @category interface opening
	 */
	protected String windowTitle() {
		return $String("Rough Sketch");
	}

	/**
	 * Draw with the opened points.
	 * 
	 * @param points java.awt.Point[]
	 * @param aController jp.co.sra.jun.opengl.roughsketch.JunOpenGLRoughSketchController
	 * @category pencil
	 */
	protected void pencilOpenedPoints(Point[] points, JunOpenGLRoughSketchController aController) {
		if (points == null || points.length < 3) {
			return;
		}
		if (aController == null) {
			return;
		}
	}

	/**
	 * Draw with the closed points.
	 * 
	 * @param points java.awt.Point[]
	 * @param aController jp.co.sra.jun.opengl.roughsketch.JunOpenGLRoughSketchController
	 * @category pencil
	 */
	protected void pencilClosedPoints(Point[] points, JunOpenGLRoughSketchController aController) {
		if (points == null || points.length < 3) {
			return;
		}
		if (aController == null) {
			return;
		}

		JunFormTriangulation2 formTriangulation = null;
		try {
			formTriangulation = this.createFormTriangulation(points);
		} catch (Exception e) {
			JunDialog.Warn_($String("Could not perform triangulation."));
			return;
		}

		Jun3dPoint[] polyline = null;
		Jun3dTriangle[] triangles = null;
		try {
			Object[] anArray = this.convert(points, formTriangulation.triangles(), aController);
			polyline = (Jun3dPoint[]) anArray[0];
			triangles = (Jun3dTriangle[]) anArray[1];
		} catch (Exception e) {
			JunDialog.Warn_($String("Could not perform conversion.."));
			return;
		}

		JunOpenGL3dObject anObject = this.polyline_triangles_from_(polyline, triangles);
		if (this.displayObject() != null) {
			anObject = new JunOpenGL3dCompoundObject(this.displayObject(), anObject);
		}
		this.displayObject_(anObject);
		this.changed_($("object"));
	}

	/**
	 * Create my JunFormTriangulation2.
	 * 
	 * @param points java.awt.Point[]
	 * @return jp.co.sra.jun.geometry.forms.JunFormTriangulation2
	 * @category private
	 */
	protected JunFormTriangulation2 createFormTriangulation(Point[] points) {
		Jun2dPoint[] anArrayofPoints = new Jun2dPoint[points.length];
		for (int i = 0; i < points.length; i++) {
			anArrayofPoints[i] = new Jun2dPoint(points[i]);
		}
		return new JunFormTriangulation2(anArrayofPoints);
	}

	/**
	 * Convert to the display object.
	 * 
	 * @param points java.awt.Point[]
	 * @param triangles jp.co.sra.jun.geometry.surfaces.Jun2dTriangle[]
	 * @param aController jp.co.sra.jun.opengl.roughsketch.JunOpenGLRoughSketchController
	 * @return java.lang.Object[]
	 * @category private
	 */
	protected Object[] convert(Point[] points, Jun2dTriangle[] triangles, JunOpenGLRoughSketchController aController) {
		Jun3dPoint[] anArrayOfPoints = new Jun3dPoint[points.length];
		for (int i = 0; i < points.length; i++) {
			anArrayOfPoints[i] = this.convertPoint(aController.regularizePoint_(points[i]));
		}

		Jun3dTriangle[] anArrayOfTriangles = new Jun3dTriangle[triangles.length];
		for (int i = 0; i < triangles.length; i++) {
			Jun3dPoint p1 = this.convertPoint(aController.regularizePoint_(triangles[i].p1()._toPoint()));
			Jun3dPoint p2 = this.convertPoint(aController.regularizePoint_(triangles[i].p2()._toPoint()));
			Jun3dPoint p3 = this.convertPoint(aController.regularizePoint_(triangles[i].p3()._toPoint()));
			Jun3dTriangle aTriangle = Jun3dTriangle.First_second_third_(p1, p2, p3);
			if (aTriangle.asPlane().valueF_(this.eyePoint()) < 0) {
				aTriangle = aTriangle.reversed();
			}
			anArrayOfTriangles[i] = aTriangle;
		}

		return new Object[] { anArrayOfPoints, anArrayOfTriangles };
	}

	/**
	 * Convert the regularized 2D point to a 3D point.
	 * 
	 * @param aPoint jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @category private
	 */
	private Jun3dPoint convertPoint(Jun2dPoint aPoint) {
		return this.displayProjection().translateTo3dPointFromPoint_(aPoint).minus_(this.sightPoint());
	}

	/**
	 * Create a 3D object with triangles.
	 * 
	 * @param polyline jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @param triangles jp.co.sra.jun.geometry.surfaces.Jun3dTriangle[]
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category private
	 */
	protected JunOpenGL3dObject polyline_triangles_from_(Jun3dPoint[] polyline, Jun3dTriangle[] triangles) {
		Jun3dLine aLine = this.sightPoint().to_(this.eyePoint()).normalized();
		Jun3dTransformation aTransformation0 = Jun3dTransformation.Translate_(aLine.atT_(0));
		Jun3dTransformation aTransformation1 = Jun3dTransformation.Translate_(aLine.atT_(0.001));
		Jun3dTransformation aTransformation2 = Jun3dTransformation.Translate_(aLine.atT_(0.002));

		JunOpenGL3dCompoundObject anObject = new JunOpenGL3dCompoundObject();
		for (int i = 0; i < triangles.length; i++) {
			JunOpenGL3dObject aTriangle = triangles[i].asJunOpenGL3dObject();
			aTriangle.paint_(StColorValue.Blend(StColorValue.Blend(NibColor, Color.white), Color.white));
			anObject.add_(aTriangle.transform_(aTransformation0));

			JunOpenGL3dPolylineLoop aPolylineLoop = new JunOpenGL3dPolylineLoop(new Jun3dPoint[] { triangles[i].p1(), triangles[i].p2(), triangles[i].p3() });
			aPolylineLoop.lineWidth_(NibWidth);
			aPolylineLoop.paint_(StColorValue.Blend(NibColor, Color.white));
			anObject.add_(aPolylineLoop.transform_(aTransformation1));

			aPolylineLoop = new JunOpenGL3dPolylineLoop(polyline);
			aPolylineLoop.lineWidth_(NibWidth);
			aPolylineLoop.paint_(NibColor);
			anObject.add_(aPolylineLoop.transform_(aTransformation2));
		}
		return anObject;
	}

}
