package jp.co.sra.jun.opengl.support;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;

import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLEventListener;

import jp.co.sra.smalltalk.DependentEvent;

/**
 * JOGLCanvas class
 * 
 *  @author    nisinaka
 *  @created   2007/08/20 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JOGLCanvas.java,v 8.5 2008/02/20 06:32:49 nisinaka Exp $
 */
public class JOGLCanvas extends GLCanvas implements JunOpenGLDrawable, GLEventListener {

	protected JunOpenGLInterface openGLInterface;
	protected JunOpenGLRenderer renderer;

	/**
	 * Create a new instance of JOGLCanvas and initialize it.
	 *
	 * @category Instance creation
	 */
	public JOGLCanvas() {
		this(null);
	}

	/**
	 * Create a new instance of JOGLCanvas and initialize it.
	 *
	 * @param anOpenGLRenderer jp.co.sra.jun.opengl.support.JunOpenGLRenderer
	 * @category Instance creation
	 */
	public JOGLCanvas(JunOpenGLRenderer anOpenGLRenderer) {
		this.initialize();
		this.setRenderer(anOpenGLRenderer);
		this.addGLEventListener(this);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @category initialize-release
	 */
	protected void initialize() {
		openGLInterface = null;
		renderer = null;
	}

	/**
	 * Answer my current OpenGL interface.
	 * 
	 * @return jp.co.sra.jun.opengl.support.JunOpenGLInterface
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLDrawable#getOpenGLInterface()
	 * @category accessing 
	 */
	public JunOpenGLInterface getOpenGLInterface() {
		return openGLInterface;
	}

	/**
	 * Answer my current background color.
	 * 
	 * @return java.awt.Color
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLDrawable#getBackgroundColor()
	 * @category accessing
	 */
	public Color getBackgroundColor() {
		return this.getBackground();
	}

	/**
	 * Set my new renderer.
	 * 
	 * @param anOpenGLRenderer jp.co.sra.jun.opengl.support.JunOpenGLRenderer
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLDrawable#setRenderer(jp.co.sra.jun.opengl.support.JunOpenGLRenderer)
	 * @category accessing
	 */
	public void setRenderer(JunOpenGLRenderer anOpenGLRenderer) {
		if (renderer == anOpenGLRenderer) {
			return;
		}

		renderer = anOpenGLRenderer;
		this.redisplay();
	}

	/**
	 * Convert to a component.
	 * 
	 * @return java.awt.Component
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLDrawable#toComponent()
	 * @category converting
	 */
	public Component toComponent() {
		return this;
	}

	/**
	 * Render the receiver on the rendering context.
	 * 
	 * @param aRenderingContext jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLDrawable#renderOn_(jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext)
	 * @category rendering
	 */
	public void renderOn_(JunOpenGLRenderingContext aRenderingContext) {
		if (renderer != null) {
			renderer.renderOn_(aRenderingContext);
		}
	}

	/**
	 * Paint the receiver on the graphics.
	 * 
	 * @param aGraphics java.awt.Graphics
	 * @see javax.media.opengl.GLCanvas#paint(java.awt.Graphics)
	 * @category painting
	 */
	public void paint(Graphics aGraphics) {
		super.paint(aGraphics);

		if (renderer != null) {
			renderer.superimposeOn_(aGraphics, this);
		}
	}

	/**
	 * Display the entire contents again.
	 * 
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLDrawable#redisplay()
	 * @category displaying
	 */
	public void redisplay() {
		if (this.isShowing()) {
			this.repaint();
		}
	}

	/**
	 * Display the entire contents again immediately.
	 * 
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLDrawable#redisplayImmediately()
	 * @category displaying
	 */
	public void redisplayImmediately() {
		if (this.isShowing() == false) {
			return;
		}

		Graphics aGraphics = null;
		try {
			aGraphics = this.getGraphics();
			this.paint(aGraphics);
		} finally {
			if (aGraphics != null) {
				aGraphics.dispose();
			}
		}
	}

	/**
	 * Update for the change notice.
	 * 
	 * @param e jp.co.sra.smalltalk.DependentEvent
	 * @see jp.co.sra.smalltalk.DependentListener#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @category updating
	 */
	public void update_(DependentEvent e) {
		this.redisplay();
	}

	/**
	 * Called by the drawable immediately after the OpenGL context is initialized.
	 * 
	 * @param drawable javax.media.opengl.GLAutoDrawable
	 * @see javax.media.opengl.GLEventListener#init(javax.media.opengl.GLAutoDrawable)
	 * @category gl actions
	 */
	public void init(GLAutoDrawable drawable) {
		openGLInterface = new JOGLInterface(drawable.getGL());
	}

	/**
	 * Called by the drawable to initiate OpenGL rendering by the client.
	 * 
	 * @param drawable javax.media.opengl.GLAutoDrawable
	 * @see javax.media.opengl.GLEventListener#display(javax.media.opengl.GLAutoDrawable)
	 * @category gl actions
	 */
	public void display(GLAutoDrawable drawable) {
		JunOpenGLRenderingContext renderingContext = new JunOpenGLRenderingContext(this);
		this.renderOn_(renderingContext);
	}

	/**
	 * Called by the drawable during the first repaint after the component has been resized.
	 * 
	 * @param drawable javax.media.opengl.GLAutoDrawable
	 * @param x int
	 * @param y int
	 * @param width int
	 * @param height int
	 * @see javax.media.opengl.GLEventListener#reshape(javax.media.opengl.GLAutoDrawable, int, int, int, int)
	 * @category gl actions
	 */
	public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
		JunOpenGLRenderingContext renderingContext = new JunOpenGLRenderingContext(this);
		this.renderOn_(renderingContext);
	}

	/**
	 * Called by the drawable when the display mode or the display device associated with the GLAutoDrawable has changed.
	 * 
	 * @param drawable javax.media.opengl.GLAutoDrawable
	 * @param modeChanged boolean
	 * @param deviceChanged boolean
	 * @see javax.media.opengl.GLEventListener#displayChanged(javax.media.opengl.GLAutoDrawable, boolean, boolean)
	 * @category gl actions
	 */
	public void displayChanged(GLAutoDrawable drawable, boolean modeChanged, boolean deviceChanged) {
		//
	}

}
