package jp.co.sra.jun.system.dialog;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StRectangle;

import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.display.JunDisplayView;
import jp.co.sra.jun.goodies.utilities.JunSensorUtility;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunTextInputFieldTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2006/10/16 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun651 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunTextInputFieldTestExamples.java,v 8.11 2008/02/20 06:32:50 nisinaka Exp $
 */
public class JunTextInputFieldTestExamples extends JunTestExamples {

	/**
	 * Example1:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1_PopUpIn() {
		String aString = JunTextInputField.PopUpIn_(new Rectangle(200, 250, 150, 24));
		System.out.println(aString);

		return true;
	}

	/**
	 * Example2:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2_PopUpIn_initialAnswer() {
		String aString = JunTextInputField.PopUpIn_initialAnswer_(new Rectangle(200, 250, 150, 24), "Jun");
		System.out.println(aString);

		return true;
	}

	/**
	 * Example3:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3_PopUpIn_forView() {
		String aString = JunTextInputField.PopUpIn_forView_(new Rectangle(0, 0, 150, JunTextInputField.LineGrid()), LookForView());
		System.out.println(aString);

		return true;
	}

	/**
	 * Example4:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4_PopUpIn_forView_initialAnswer() {
		String aString = JunTextInputField.PopUpIn_forView_initialAnswer_(new Rectangle(0, 0, 150, JunTextInputField.LineGrid()), LookForView(), "jun");
		System.out.println(aString);

		return true;
	}

	/**
	 * Example5:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example5_PopUpForView_initialAnswer() {
		String aString = JunTextInputField.PopUpForView_initialAnswer_(LookForView(), "jun");
		System.out.println(aString);

		return true;
	}

	/**
	 * Example6:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example6() {
		Point aPoint = new Point(0, 0);
		JunCursors cursor = new JunCursors(JunCursors.LeftClickMouseCursor());
		try {
			cursor._show();
			aPoint = JunSensorUtility.WaitClickButton();
		} finally {
			cursor._restore();
		}

		StRectangle aBox = new StRectangle(0, 0, 150, 24);
		aBox = aBox.align_with_(aBox.center(), aPoint);

		JunTextInputField aDialog = new JunTextInputField();
		aDialog.compute_(new StBlockClosure() {
			public Object value_(Object anObject) {
				System.out.println(anObject);
				return null;
			}
		});
		aDialog.popUpIn_initialAnswer_(aBox, "jun");
		String aString = (String) aDialog.answer();
		System.out.println(aString);

		return true;
	}

	/**
	 * Example7:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example7() {
		Point aPoint = new Point(0, 0);
		JunCursors cursor = new JunCursors(JunCursors.LeftClickMouseCursor());
		try {
			cursor._show();
			aPoint = JunSensorUtility.WaitClickButton();
		} finally {
			cursor._restore();
		}

		StRectangle aBox = new StRectangle(0, 0, 150, 24);
		aBox = aBox.align_with_(aBox.center(), aPoint);

		JunTextInputField aDialog = new JunTextInputField();
		aDialog.check_(new StBlockClosure() {
			public Object value_value_(Object aCharacter, Object aString) {
				System.out.print(Integer.toHexString(((Character) aCharacter).charValue()));
				System.out.print(" ");
				System.out.println(aString);
				return null;
			}
		});
		aDialog.popUpIn_initialAnswer_(aBox, "jun");
		String aString = (String) aDialog.answer();
		System.out.println(aString);

		return true;
	}

	/**
	 * Search for a view.
	 * 
	 * @return java.awt.Component
	 * @category Examples
	 */
	protected static Component LookForView() {
		Frame[] frames = Frame.getFrames();
		for (int i = 0; i < frames.length; i++) {
			if (frames[i].isActive()) {
				return LookForView(frames[i]);
			}
		}
		return null;
	}

	/**
	 * Search for a view.
	 * 
	 * @return java.awt.Component
	 * @category Examples
	 */
	protected static Component LookForView(Component aComponent) {
		if (aComponent instanceof JunDisplayView) {
			return ((JunDisplayView) aComponent).canvasComponent();
		} else if (aComponent instanceof Container) {
			Component[] components = ((Container) aComponent).getComponents();
			for (int i = 0; i < components.length; i++) {
				Component component = LookForView(components[i]);
				if (component != null) {
					return component;
				}
			}
		}
		return null;
	}

	/**
	 * Execute the test examples.
	 *
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunTextInputFieldTestExamples();
	}

}
