package jp.co.sra.jun.terrain.support;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.system.framework.JunAbstractObject;

/**
 * JunTerrainField class
 * 
 *  @author    nisinaka
 *  @created   2002/01/22 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunTerrainField.java,v 8.11 2008/02/20 06:33:00 nisinaka Exp $
 */
public class JunTerrainField extends JunAbstractObject {
	protected JunTerrainTriangle[] triangles;

	/**
	 * Create a new instance of JunTerrainField and initialize it with
	 * triangles.
	 * 
	 * @param anArrayOfJunTerrainTriangle
	 *        jp.co.sra.jun.terrain.support.JunTerrainTriangle[]
	 */
	public JunTerrainField(JunTerrainTriangle[] anArrayOfJunTerrainTriangle) {
		super();
		this.setTriangles_(anArrayOfJunTerrainTriangle);
	}

	/**
	 * Convert to a JunOpenGL3dObject.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 */
	public JunOpenGL3dObject asJunOpenGL3dObject() {
		JunOpenGL3dCompoundObject anObject = new JunOpenGL3dCompoundObject();

		for (int i = 0; i < triangles.length; i++) {
			anObject.add_(triangles[i].asJunOpenGL3dObject());
		}

		return anObject;
	}

	/**
	 * Answer the normal vector at the specified point.
	 * 
	 * @param aJun2dPoint jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 */
	public Jun3dPoint normalVectorAt2dPoint_(Jun2dPoint aJun2dPoint) {
		for (int i = 0; i < triangles.length; i++) {
			if (triangles[i].contains2dPoint_(aJun2dPoint)) {
				return triangles[i].normalVector();
			}
		}

		return null;
	}

	/**
	 * Answer the z-coordinate at the specified point.
	 * 
	 * @param aJun2dPoint jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * 
	 * @return double
	 */
	public double zAt2dPoint_(Jun2dPoint aJun2dPoint) {
		for (int i = 0; i < triangles.length; i++) {
			if (triangles[i].contains2dPoint_(aJun2dPoint)) {
				return triangles[i].zAt2dPoint_(aJun2dPoint);
			}
		}

		return Double.NaN;
	}

	/**
	 * Set my triangles.
	 * 
	 * @param anArrayOfJunTerrainTriangle
	 *        jp.co.sra.jun.terrain.support.JunTerrainTriangle[]
	 */
	protected void setTriangles_(JunTerrainTriangle[] anArrayOfJunTerrainTriangle) {
		triangles = anArrayOfJunTerrainTriangle;
	}
}
