package jp.co.sra.jun.threeDImage.basic;

import java.awt.Color;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext;
import jp.co.sra.jun.system.framework.JunAbstractObject;
import jp.co.sra.jun.threeDImage.colors.JunColorValue;
import jp.co.sra.jun.threeDImage.support.Jun3dGraphicsContext;

/**
 * Jun3dImage class
 * 
 *  @author    kondo
 *  @created   1999/09/06 (by kondo)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun697 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: Jun3dImage.java,v 8.11 2008/02/20 06:33:00 nisinaka Exp $
 */
public class Jun3dImage extends JunAbstractObject {
	private Color background;
	private Color[][] colors;
	private Jun3dPoint extent;
	private int yStep;

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJun3dPoint
	 * 
	 * @return Jun3dImage
	 */
	public static Jun3dImage Extent_(Jun3dPoint aJun3dPoint) {
		Jun3dImage image = new Jun3dImage();
		image.initialize();
		image.extent_(aJun3dPoint);

		return image;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param anInteger1
	 * @param anInteger2 DOCUMENT ME!
	 * @param anInteger3 DOCUMENT ME!
	 * @param aJunColorValue DOCUMENT ME!
	 */
	public void atX_y_z_put_(int anInteger1, int anInteger2, int anInteger3, Color aJunColorValue) {
		this.colors[this.indexAtX_y_(anInteger1, anInteger2)][anInteger3 + 1] = aJunColorValue;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return Color
	 */
	public Color background() {
		return this.background;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunColorValue
	 */
	public void background_(Color aJunColorValue) {
		this.background = aJunColorValue;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return int
	 */
	public int depth() {
		return (int) this.extent().z();
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return Jun3dPoint
	 */
	public Jun3dPoint extent() {
		return this.extent();
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return Jun3dGraphicsContext
	 */
	public Jun3dGraphicsContext graphicsContext() {
		return Jun3dGraphicsContext.On_(this);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return int
	 */
	public int height() {
		return (int) this.extent().y();
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return int
	 */
	public int width() {
		return (int) this.extent().x();
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param anInteger1
	 * @param anInteger2 DOCUMENT ME!
	 * @param anInteger3 DOCUMENT ME!
	 * 
	 * @return Color
	 */
	private Color atX_y_z_(int anInteger1, int anInteger2, int anInteger3) {
		Color color = this.colors[this.indexAtX_y_(anInteger1, anInteger2)][anInteger3 + 1];

		if (color == null) {
			return this.background();
		} else {
			return color;
		}
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param anArrayOfColor
	 * 
	 * @return DOCUMENT ME!
	 */
	private Color composeColorFromColors_(Color[] anArrayOfColor) {
		Color color = JunColorValue.Transparent();

		for (int index = 0; index < anArrayOfColor.length; index++) {
			Color c = anArrayOfColor[index];
			Color underColor;

			if (c == null) {
				underColor = JunColorValue.Transparent();
			} else {
				underColor = c;
			}

			color = JunColorValue.BlendOver_(color, underColor);

			if (JunColorValue.IsSolid_(color)) {
				return color;
			}
		}

		return JunColorValue.BlendOver_(color, this.background());
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return DOCUMENT ME!
	 */
	private Color defaultBackground() {
		return Color.white;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aContext DOCUMENT ME!
	 * @param aPoint DOCUMENT ME!
	 */
	private void displayOn_at_(JunOpenGLRenderingContext aContext, Jun3dPoint aPoint) {
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJun3dPoint
	 */
	private void extent_(Jun3dPoint aJun3dPoint) {
		this.extent = aJun3dPoint;
		this.yStep = (int) aJun3dPoint.x();

		int size = (int) (aJun3dPoint.x() * aJun3dPoint.y());
		int zSize = (int) aJun3dPoint.z();
		this.colors = new Color[size][zSize];
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param anInteger1
	 * @param anInteger2 DOCUMENT ME!
	 * 
	 * @return int
	 */
	private int indexAtX_y_(int anInteger1, int anInteger2) {
		return anInteger1 + 1 + (anInteger2 * this.yStep);
	}

	/**
	 * Initialize the receiver when created.
	 * 
	 * @see jp.co.sra.jun.system.framework.JunAbstractObject#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		this.background = this.defaultBackground();
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJun3dPoint
	 * 
	 * @return Color
	 */
	private Color valueAtPoint_(Jun3dPoint aJun3dPoint) {
		return this.atX_y_z_((int) aJun3dPoint.x(), (int) aJun3dPoint.y(), (int) aJun3dPoint.z());
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJun3dPoint
	 * @param aJunColorValue DOCUMENT ME!
	 */
	private void valueAtPoint_put_(Jun3dPoint aJun3dPoint, Color aJunColorValue) {
		this.atX_y_z_put_((int) aJun3dPoint.x(), (int) aJun3dPoint.y(), (int) aJun3dPoint.z(), aJunColorValue);
	}
}
