package jp.co.sra.jun.topology.abstracts;

import jp.co.sra.jun.topology.elements.JunBody;

/**
 * JunTopologicalElementOrProxy interface
 * 
 *  @author    nisinaka
 *  @created   1998/11/06 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunTopologicalElementOrProxy.java,v 8.10 2008/02/20 06:33:01 nisinaka Exp $
 */
public interface JunTopologicalElementOrProxy {

	/**
	 * Convert the receiver as a proxy in aBody.
	 * 
	 * @param aBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aTopologicalElementProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementProxy
	 * 
	 * @return jp.co.sra.jun.topology.abstracts.JunTopologicalElementProxy
	 */
	JunTopologicalElementProxy asProxyIn_advise_(JunBody aBody, JunTopologicalElementProxy aTopologicalElementProxy);

	/**
	 * Answer true if the receiver is a kind of geometry, otherwise false.
	 * 
	 * @return boolean
	 */
	boolean isTopologicalProxy();
}
