package jp.co.sra.jun.topology.compositeoperators;

/*
 * @(#)JunCompoundOperator.java        1.0 98/9/17
 */
import jp.co.sra.jun.topology.abstracts.JunAbstractOperator;
import jp.co.sra.jun.topology.elements.JunBody;

/**
 * JunCompoundOperator class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCompoundOperator.java,v 8.10 2008/02/20 06:33:01 nisinaka Exp $
 */
public class JunCompoundOperator extends JunAbstractOperator {
	/** An array of the sub operators. */
	protected JunAbstractOperator[] suboperators = null;

	/** A flag of the inversability. */
	protected boolean inversable = false;

	/**
	 * Create a new JunCompoundOperator with a JunBody and an array of
	 * JunAbstractOperators.
	 * 
	 * @param aBody jp.co.sra.jun.topology.elements.JunBody
	 * @param anArrayOfJunAbstractOperator
	 *        jp.co.sra.jun.topology.abstracts.JunAbstractOperator[]
	 * 
	 * @return jp.co.sra.jun.topology.compositeoperators.JunCompoundOperator
	 */
	public static JunCompoundOperator Body_suboperators_(JunBody aBody, JunAbstractOperator[] anArrayOfJunAbstractOperator) {
		JunCompoundOperator anOperator;
		anOperator = new JunCompoundOperator();
		anOperator.body_(aBody);
		anOperator.setSuboperators_(anArrayOfJunAbstractOperator);

		return anOperator;
	}

	/**
	 * Execute all of the operaters.
	 */
	public void execute() {
		for (int i = 0; i < suboperators.length; i++) {
			suboperators[i].doOperation();
		}
	}

	/**
	 * Answer the inverse operation of the receiver.
	 * 
	 * @return jp.co.sra.jun.topology.abstracts.JunAbstractOperator
	 */
	public JunAbstractOperator inverse() {
		int size = suboperators.length;
		JunAbstractOperator[] operators = new JunAbstractOperator[size];

		for (int i = 0; i < size; i++) {
			operators[i] = suboperators[size - 1 - i].inverse();
		}

		return Body_suboperators_(this.body(), operators);
	}

	/**
	 * Answer true if the receiver can be inverted.
	 * 
	 * @return boolean
	 */
	public boolean isInversable() {
		return inversable;
	}

	/**
	 * Set the receivers sub-operators and initialize the inversable flag.
	 * 
	 * @param anArrayOfJunAbstractOperators
	 *        jp.co.sra.jun.topology.abstracts.JunAbstractOperator[]
	 */
	public void setSuboperators_(JunAbstractOperator[] anArrayOfJunAbstractOperators) {
		suboperators = anArrayOfJunAbstractOperators;
		inversable = true;

		for (int i = 0; i < suboperators.length; i++) {
			inversable = inversable && suboperators[i].isInversable();

			if (!inversable) {
				break;
			}
		}
	}
}
