package jp.co.sra.jun.topology.euleroperators;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.system.support.JunTestExamples;
import jp.co.sra.jun.topology.elements.*;
import jp.co.sra.jun.topology.geometricoperators.JunTV;

/**
 * JunKDEVTestExamples class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   1999/04/16 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunKDEVTestExamples.java,v 8.10 2008/02/20 06:33:01 nisinaka Exp $
 */
public class JunKDEVTestExamples extends JunTestExamples {

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static boolean example1() {
		JunBody body;
		JunVertex v000 = null;
		JunVertex v100 = null;
		JunVertex v010 = null;
		JunEdge edge1;
		JunEdge edge2;
		JunMDEV mdev;
		JunKDEV kdev;
		Jun3dPoint[] a3dPoint = new Jun3dPoint[4];

		a3dPoint[0] = new Jun3dPoint(0, 0, 0);
		a3dPoint[1] = new Jun3dPoint(1, 0, 0);
		a3dPoint[2] = new Jun3dPoint(0, 1, 0);
		a3dPoint[3] = new Jun3dPoint(0, 0, 1);
		body = JunBody.Tetrahedron_(a3dPoint);

		JunVertex[] temp = body.vertexes();

		for (int i = 0; i < temp.length; i++) {
			if ((temp[i].point()).equals(new Jun3dPoint(0, 0, 0))) {
				v000 = temp[i];

				break;
			}
		}

		for (int i = 0; i < temp.length; i++) {
			if ((temp[i].point()).equals(new Jun3dPoint(1, 0, 0))) {
				v100 = temp[i];

				break;
			}
		}

		for (int i = 0; i < temp.length; i++) {
			if ((temp[i].point()).equals(new Jun3dPoint(0, 1, 0))) {
				v010 = temp[i];

				break;
			}
		}

		edge1 = body.edgeForVertex_and_(v000, v100);
		edge2 = body.edgeForVertex_and_(v000, v010);
		mdev = JunMDEV.Body_vertex_edge_edge_(body, v000, edge1, edge2);
		mdev.doOperation();
		kdev = JunKDEV.Body_edge_(body, mdev.newEdge());
		kdev.doOperation();
		body.show();

		//      return kdev;
		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunKDEVTestExamples();
	}

	/**
	 * The example on JunKDEV.htm
	 * 
	 * @return boolean.
	 */
	public static boolean ManualExample1() {
		JunBody body = new JunBody();

		//
		JunMEVVL mevvl = JunMEVVL.Body_point_point_(body, new Jun3dPoint(1, 0, 0), new Jun3dPoint(0, 1, 0));
		mevvl.doOperation();

		JunLoop loop = mevvl.newLoop();
		JunVertex vertex100 = mevvl.newVertex1();
		JunVertex vertex010 = mevvl.newVertex2();

		//
		JunMEV mev = JunMEV.Body_vertex_loop_point_(body, vertex100, loop, new Jun3dPoint(0, 0, 0));
		mev.doOperation();

		JunVertex vertex000 = mev.newVertex();
		JunEdge edge1 = mev.newEdge();

		//
		JunMEL mel = JunMEL.Body_loop_vertex_vertex_(body, loop, vertex010, vertex000);
		mel.doOperation();

		JunEdge edge2 = mel.newEdge();

		//
		JunMDEV mdev = JunMDEV.Body_vertex_edge_edge_(body, vertex000, edge1, edge2);
		mdev.doOperation();
		vertex000 = mdev.newVertex();

		JunEdge edge = mdev.newEdge();

		//
		JunTV tv = JunTV.Body_vertex_vector_(body, vertex000, new Jun3dPoint(1, 1, 0));
		tv.doOperation();

		JunVertex vertex110 = mdev.newVertex();

		//
		body.show().wireframePresentation();

		JunKDEV kdev = JunKDEV.Body_edge_killVertex_(body, edge, vertex110);
		kdev.doOperation();
		body.show().wireframePresentation();

		//
		System.out.println("-------- #killedEdge");
		System.out.println(kdev.killedEdge());
		System.out.println("-------- #killedVertex");
		System.out.println(kdev.killedVertex());
		System.out.println("-------- #vertex2");
		System.out.println(kdev.vertex2());
		System.out.println("-------- #edge2");
		System.out.println(kdev.edge2());
		System.out.println("-------- #edge3");
		System.out.println(kdev.edge3());

		//
		return true;
	}
}
