package jp.co.sra.jun.topology.euleroperators;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.system.support.JunTestExamples;
import jp.co.sra.jun.topology.elements.JunBody;
import jp.co.sra.jun.topology.elements.JunEdge;
import jp.co.sra.jun.topology.elements.JunLoop;
import jp.co.sra.jun.topology.elements.JunVertex;

/**
 * JunKVETestExamples class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunKVETestExamples.java,v 8.11 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunKVETestExamples extends JunTestExamples {
	/**
	 * Example.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean example1() {
		JunBody body = new JunBody();
		JunMEVVL mevvl = JunMEVVL.Body_point_point_(body, new Jun3dPoint(0, 0, 0), new Jun3dPoint(0, 0, 1));
		mevvl.doOperation();
		JunVertex v000 = mevvl.vertex1();
		JunVertex v001 = mevvl.vertex2();
		// JunEdge edge000001 = mevvl.edge();
		mevvl.edge();
		JunLoop loop1 = mevvl.loop();

		JunMEV mev1 = JunMEV.Body_vertex_loop_point_(body, v001, loop1, new Jun3dPoint(0, 1, 0));
		mev1.doOperation();
		JunVertex v010 = mev1.vertex1();
		JunEdge edge001010 = mev1.edge();

		JunMEV mev2 = JunMEV.Body_vertex_loop_point_(body, v010, loop1, new Jun3dPoint(1, 0, 0));
		mev2.doOperation();
		JunVertex v100 = mev2.vertex1();
		// JunEdge edge010100 = mev2.edge();
		mev2.edge();

		JunMEL mel = JunMEL.Body_loop_vertex_vertex_(body, loop1, v100, v000);
		mel.doOperation();
//		JunEdge edge100000 = mel.edge();
		mel.edge();
//		JunLoop loop2 = mel.loop1();
		mel.loop1();

		JunMVE mve = JunMVE.Body_edge_point_(body, edge001010, new Jun3dPoint(1, 1, 1));
		mve.doOperation();

		/*
		 for (int i = 0; i < 100; i++) {
		 JunKVE kve = (JunKVE) (mve.inverse());
		 kve.doOperation();
		 mve = (JunMVE) (kve.inverse());
		 mve.doOperation();
		 }
		 */

		for (int i = 0; i < 1; i++) {
			mve.undoOperation();
			mve.doOperation();
		}
		mve.body().show();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunKVETestExamples();
	}
}
