package jp.co.sra.jun.topology.euleroperators;

import jp.co.sra.jun.topology.abstracts.*;

/*
 * @ (#) JunMCLKPL.java 1.0 98/9/26
 */
import jp.co.sra.jun.topology.elements.*;

/**
 * JunMCLKPL class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMCLKPL.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunMCLKPL extends JunEulerOperator {
	protected JunLoopProxy loopProxy1;
	protected JunLoopProxy loopProxy2;

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aLoopOrProxy1
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aLoopOrProxy2
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * 
	 * @return jp.co.sra.jun.topology.euleroperators.JunMCLKPL
	 */
	public static final JunMCLKPL Body_loop_loop_(JunBody aJunBody, JunTopologicalElementOrProxy aLoopOrProxy1, JunTopologicalElementOrProxy aLoopOrProxy2) {
		JunMCLKPL anOperator;
		anOperator = new JunMCLKPL();
		anOperator.body_(aJunBody);
		anOperator.loop1_(aLoopOrProxy1);
		anOperator.loop2_(aLoopOrProxy2);

		return anOperator;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public void execute() {
		this.loop1().addChildLoop_(this.loop2());
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.abstracts.JunAbstractOperator
	 */
	public JunAbstractOperator inverse() {
		return (JunAbstractOperator) (JunKCLMPL.Body_loop_adviseLoop_(this.body(), this.loopProxy2, this.loopProxy1));
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunLoop
	 */
	public JunLoop loop1() {
		return (JunLoop) this.getTopologicalElement_(this.loopProxy1);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunLoopOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void loop1_(JunTopologicalElementOrProxy aJunLoopOrProxy) {
		this.loopProxy1 = (JunLoopProxy) this.getTopologicalElementProxy_advise_(aJunLoopOrProxy, this.loopProxy1);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunLoop
	 */
	public JunLoop loop2() {
		return (JunLoop) this.getTopologicalElement_(loopProxy2);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunLoopOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void loop2_(JunTopologicalElementOrProxy aJunLoopOrProxy) {
		this.loopProxy2 = (JunLoopProxy) this.getTopologicalElementProxy_advise_(aJunLoopOrProxy, this.loopProxy2);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return boolean
	 */
	public boolean precondition() {
		JunLoop loop1;
		JunLoop loop2;
		loop1 = this.loop1();

		if (loop1 == null) {
			return false;
		}

		loop2 = this.loop2();

		if (loop2 == null) {
			return false;
		}

		return (super.precondition() && loop1.isParentLoop() && loop2.isParentLoop());
	}
}
