package jp.co.sra.jun.topology.euleroperators;

import jp.co.sra.jun.topology.abstracts.*;
import jp.co.sra.jun.topology.elements.*;

/**
 * JunMEL class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   1999/08/23 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMEL.java,v 8.11 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunMEL extends JunEulerOperator {
	protected JunEdgeProxy edgeProxy;
	protected JunLoopProxy loopProxy1;
	protected JunLoopProxy loopProxy2;
	protected JunVertexProxy vertexProxy1;
	protected JunVertexProxy vertexProxy2;
	protected JunEdgeProxy edgeProxy2;
	protected JunEdgeProxy edgeProxy3;

	/**
	 * Create a new instance of JunMEL.
	 * 
	 * @param aJunBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aJunLoopOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunVertexOrProxy1
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunVertexOrProxy2
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * 
	 * @return jp.co.sra.jun.topology.euleroperators.JunMEL
	 */
	public static JunMEL Body_loop_vertex_vertex_(JunBody aJunBody, JunTopologicalElementOrProxy aJunLoopOrProxy, JunTopologicalElementOrProxy aJunVertexOrProxy1, JunTopologicalElementOrProxy aJunVertexOrProxy2) {
		return Body_loop_vertex_vertex_adviseEdge_loop_edge_edge_(aJunBody, aJunLoopOrProxy, aJunVertexOrProxy1, aJunVertexOrProxy2, null, null, null, null);
	}

	/**
	 * Create a new instance of JunMEL.
	 * 
	 * @param aJunBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aJunLoopOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunVertexOrProxy1
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunVertexOrProxy2
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunLoopOrProxy2
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunEdgeOrProxy2
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunEdgeOrProxy3
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * 
	 * @return jp.co.sra.jun.topology.euleroperators.JunMEL
	 */
	public static final JunMEL Body_loop_vertex_vertex_adviseEdge_loop_edge_edge_(
		JunBody aJunBody,
		JunTopologicalElementOrProxy aJunLoopOrProxy,
		JunTopologicalElementOrProxy aJunVertexOrProxy1,
		JunTopologicalElementOrProxy aJunVertexOrProxy2,
		JunTopologicalElementOrProxy aJunEdgeOrProxy,
		JunTopologicalElementOrProxy aJunLoopOrProxy2,
		JunTopologicalElementOrProxy aJunEdgeOrProxy2,
		JunTopologicalElementOrProxy aJunEdgeOrProxy3) {
		JunMEL anOperator = new JunMEL();
		anOperator.body_(aJunBody);
		anOperator.loop1_(aJunLoopOrProxy2);
		anOperator.loop2_(aJunLoopOrProxy);
		anOperator.vertex1_(aJunVertexOrProxy1);
		anOperator.vertex2_(aJunVertexOrProxy2);
		anOperator.edge_(aJunEdgeOrProxy);
		anOperator.edge2_(aJunEdgeOrProxy2);
		anOperator.edge3_(aJunEdgeOrProxy3);

		return anOperator;
	}

	/**
	 * Answer my edge.
	 * 
	 * @return jp.co.sra.jun.topology.elements.Junedge
	 */
	public JunEdge edge() {
		return (JunEdge) this.getTopologicalElement_(edgeProxy);
	}

	/**
	 * Set my edge.
	 * 
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void edge_(JunTopologicalElementOrProxy aJunEdgeOrProxy) {
		edgeProxy = (JunEdgeProxy) this.getTopologicalElementProxy_advise_(aJunEdgeOrProxy, edgeProxy);
	}

	/**
	 * Answer my edge2.
	 * 
	 * @return jp.co.sra.jun.topology.elements.Junedge
	 */
	public JunEdge edge2() {
		return (JunEdge) this.getTopologicalElement_(edgeProxy2);
	}

	/**
	 * Set my edge2.
	 * 
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void edge2_(JunTopologicalElementOrProxy aJunEdgeOrProxy) {
		edgeProxy2 = (JunEdgeProxy) this.getTopologicalElementProxy_advise_(aJunEdgeOrProxy, edgeProxy2);
	}

	/**
	 * Answer my edge3.
	 * 
	 * @return jp.co.sra.jun.topology.elements.Junedge
	 */
	public JunEdge edge3() {
		return (JunEdge) this.getTopologicalElement_(edgeProxy3);
	}

	/**
	 * Set my edge3.
	 * 
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void edge3_(JunTopologicalElementOrProxy aJunEdgeOrProxy) {
		edgeProxy3 = (JunEdgeProxy) this.getTopologicalElementProxy_advise_(aJunEdgeOrProxy, edgeProxy3);
	}

	/**
	 * Execute the operation.
	 */
	public void execute() {
		this.edge_(JunEdge.StartVertex_endVertex_(this.vertex2(), this.vertex1()));
		this.loop1_(JunLoop.Edge_(this.edge()));

		JunVertex targetVertex = this.vertex1();

		JunVertex directionVertex;

		JunVertex prevVertex;
		JunEdge prevEdge;
		JunEdge currentEdge;
		JunEdge fromEdge1;
		JunEdge toEdge1;
		JunEdge fromEdge2;
		JunEdge toEdge2;

		if (this.edge2() == null) {
			fromEdge2 = this.loop2().edgeToVertex_(this.vertex2());
			directionVertex = this.vertex2();
			prevEdge = fromEdge2;
			currentEdge = prevEdge.nextEdgeWithVertex_(directionVertex);
			prevVertex = directionVertex;
			directionVertex = currentEdge.oppositeVertexOfVertex_(prevVertex);
			toEdge2 = currentEdge;
			if (prevVertex == this.vertex2()) {
				fromEdge2 = prevEdge;
				toEdge2 = currentEdge;
			}
			while (prevVertex != targetVertex) {
				prevEdge = currentEdge;
				currentEdge = currentEdge.nextEdgeWithVertex_(directionVertex);
				prevVertex = directionVertex;
				directionVertex = currentEdge.oppositeVertexOfVertex_(prevVertex);
				if (prevVertex == this.vertex2()) {
					fromEdge2 = prevEdge;
					toEdge2 = currentEdge;
				}
			}
			fromEdge1 = prevEdge;
			toEdge1 = currentEdge;
		} else {
			fromEdge1 = this.edge2();
			toEdge1 = fromEdge1.nextEdgeWithVertex_(this.vertex1());
			fromEdge2 = this.edge3();
			toEdge2 = fromEdge2.nextEdgeWithVertex_(this.vertex2());
		}

		directionVertex = this.vertex2();
		prevEdge = fromEdge2;
		currentEdge = toEdge2;
		prevVertex = directionVertex;
		directionVertex = currentEdge.oppositeVertexOfVertex_(prevVertex);
		while ((prevVertex == targetVertex && currentEdge == toEdge1) == false) {
			currentEdge.setLoop_toVertex_(this.newLoop(), directionVertex);
			prevEdge = currentEdge;
			currentEdge = currentEdge.nextEdgeWithVertex_(directionVertex);
			prevVertex = directionVertex;
			directionVertex = currentEdge.oppositeVertexOfVertex_(prevVertex);
		}
		fromEdge2.setNextEdge_withVertex_(this.edge(), this.vertex2());
		this.edge().setNextEdge_withVertex_(toEdge1, this.vertex1());
		this.edge().setNextEdge_withVertex_(toEdge2, this.vertex2());
		fromEdge1.setNextEdge_withVertex_(this.edge(), this.vertex1());
		this.edge().setLoop_toVertex_(this.loop1(), this.vertex2());
		this.edge().setLoop_toVertex_(this.loop2(), this.vertex1());
		this.loop2().edge_(this.edge());
		this.body().addEdge_(this.edge());
		this.body().addLoop_(this.loop1());
	}

	/**
	 * Answer my inverse operation.
	 * 
	 * @return jp.co.sra.jun.topology.abstracts.JunAbstractOperator
	 */
	public JunAbstractOperator inverse() {
		return JunKEL.Body_edge_adviseLoop_loop_vertex_vertex_(this.body(), edgeProxy, loopProxy1, loopProxy2, vertexProxy1, vertexProxy2);
	}

	/**
	 * Answer my loop1.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunLoop
	 */
	public JunLoop loop1() {
		return (JunLoop) this.getTopologicalElement_(loopProxy1);
	}

	/**
	 * Set my loop1.
	 * 
	 * @param aJunLoopOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void loop1_(JunTopologicalElementOrProxy aJunLoopOrProxy) {
		loopProxy1 = (JunLoopProxy) this.getTopologicalElementProxy_advise_(aJunLoopOrProxy, loopProxy1);
	}

	/**
	 * Answer my loop2.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunLoop
	 */
	public JunLoop loop2() {
		return (JunLoop) this.getTopologicalElement_(loopProxy2);
	}

	/**
	 * Set my loop2.
	 * 
	 * @param aJunLoopOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void loop2_(JunTopologicalElementOrProxy aJunLoopOrProxy) {
		loopProxy2 = (JunLoopProxy) this.getTopologicalElementProxy_advise_(aJunLoopOrProxy, loopProxy2);
	}

	/**
	 * Answer my new edge.
	 * 
	 * @return jp.co.sra.jun.topology.elements.Junedge
	 */
	public JunEdge newEdge() {
		return this.edge();
	}

	/**
	 * Answer my new loop.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunLoop
	 */
	public JunLoop newLoop() {
		return this.loop1();
	}

	/**
	 * Answer my original loop.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunLoop
	 */
	public JunLoop originalLoop() {
		return this.loop2();
	}

	/**
	 * Check the precondition.
	 * 
	 * @return boolean
	 */
	public boolean precondition() {
		if (super.precondition() == false) {
			return false;
		}

		if (this.edge() != null) {
			return false;
		}

		if (this.loop1() != null) {
			return false;
		}

		JunLoop loop2 = this.loop2();

		if (loop2 == null) {
			return false;
		}

		JunVertex vertex1 = this.vertex1();

		if (vertex1 == null) {
			return false;
		}

		JunVertex vertex2 = this.vertex2();

		if (vertex2 == null) {
			return false;
		}

		if (loop2.includesVertex_(vertex1) == false) {
			return false;
		}

		if (loop2.includesVertex_(vertex2) == false) {
			return false;
		}

		return true;
	}

	/**
	 * Answer my vertex1.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunVertex
	 */
	public JunVertex vertex1() {
		return (JunVertex) getTopologicalElement_(vertexProxy1);
	}

	/**
	 * Set my vertex1.
	 * 
	 * @param aJunVertexOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void vertex1_(JunTopologicalElementOrProxy aJunVertexOrProxy) {
		vertexProxy1 = (JunVertexProxy) this.getTopologicalElementProxy_advise_(aJunVertexOrProxy, vertexProxy1);
	}

	/**
	 * Answer my vertex2.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunVertex
	 */
	public JunVertex vertex2() {
		return (JunVertex) getTopologicalElement_(vertexProxy2);
	}

	/**
	 * Set my vertex2.
	 * 
	 * @param aJunVertexOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void vertex2_(JunTopologicalElementOrProxy aJunVertexOrProxy) {
		vertexProxy2 = (JunVertexProxy) this.getTopologicalElementProxy_advise_(aJunVertexOrProxy, vertexProxy2);
	}
}
