package jp.co.sra.jun.topology.euleroperators;

import jp.co.sra.jun.geometry.basic.*;
import jp.co.sra.jun.topology.abstracts.*;
import jp.co.sra.jun.topology.elements.*;

/**
 * JunMEV class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMEV.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunMEV extends JunEulerOperator {
	protected JunEdgeProxy edgeProxy;
	protected JunVertexProxy vertexProxy1;
	protected JunVertexProxy vertexProxy2;
	protected JunLoopProxy loopProxy;
	protected Jun3dPoint point;
	protected JunEdgeProxy edgeProxy2;

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aJunVertexOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunLoopOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJun3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * 
	 * @return jp.co.sra.jun.topology.euleroperators.JunMEV
	 */
	public static JunMEV Body_vertex_loop_point_(JunBody aJunBody, JunTopologicalElementOrProxy aJunVertexOrProxy, JunTopologicalElementOrProxy aJunLoopOrProxy, Jun3dPoint aJun3dPoint) {
		return Body_vertex_loop_point_adviseEdge_vertex_(aJunBody, aJunVertexOrProxy, aJunLoopOrProxy, aJun3dPoint, null, null);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aJunVertexOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunLoopOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJun3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunVertexOrProxy2
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * 
	 * @return jp.co.sra.jun.topology.euleroperators.JunMEV
	 */
	public static final JunMEV Body_vertex_loop_point_adviseEdge_vertex_(
		JunBody aJunBody,
		JunTopologicalElementOrProxy aJunVertexOrProxy,
		JunTopologicalElementOrProxy aJunLoopOrProxy,
		Jun3dPoint aJun3dPoint,
		JunTopologicalElementOrProxy aJunEdgeOrProxy,
		JunTopologicalElementOrProxy aJunVertexOrProxy2) {
		JunMEV anOperator;
		anOperator = new JunMEV();
		anOperator.body_(aJunBody);
		anOperator.vertex1_(aJunVertexOrProxy2);
		anOperator.vertext2_(aJunVertexOrProxy);
		anOperator.loop_(aJunLoopOrProxy);
		anOperator.point_(aJun3dPoint);
		anOperator.edge_(aJunEdgeOrProxy);

		return anOperator;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aJunVertexOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunLoopOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJun3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunVertexOrProxy2
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunEdgeOrProxy2
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * 
	 * @return jp.co.sra.jun.topology.euleroperators.JunMEV
	 */
	public static final JunMEV Body_vertex_loop_point_adviseEdge_vertex_edge_(
		JunBody aJunBody,
		JunTopologicalElementOrProxy aJunVertexOrProxy,
		JunTopologicalElementOrProxy aJunLoopOrProxy,
		Jun3dPoint aJun3dPoint,
		JunTopologicalElementOrProxy aJunEdgeOrProxy,
		JunTopologicalElementOrProxy aJunVertexOrProxy2,
		JunTopologicalElementOrProxy aJunEdgeOrProxy2) {
		JunMEV anOperator;
		anOperator = new JunMEV();
		anOperator.body_(aJunBody);
		anOperator.vertex1_(aJunVertexOrProxy2);
		anOperator.vertext2_(aJunVertexOrProxy);
		anOperator.loop_(aJunLoopOrProxy);
		anOperator.point_(aJun3dPoint);
		anOperator.edge_(aJunEdgeOrProxy);
		anOperator.edge2_(aJunEdgeOrProxy2);

		return anOperator;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.Junedge
	 */
	public JunEdge edge() {
		return (JunEdge) this.getTopologicalElement_(edgeProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void edge_(JunTopologicalElementOrProxy aJunEdgeOrProxy) {
		this.edgeProxy = (JunEdgeProxy) this.getTopologicalElementProxy_advise_(aJunEdgeOrProxy, this.edgeProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.Junedge
	 */
	public JunEdge edge2() {
		return (JunEdge) this.getTopologicalElement_(edgeProxy2);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void edge2_(JunTopologicalElementOrProxy aJunEdgeOrProxy) {
		this.edgeProxy2 = (JunEdgeProxy) this.getTopologicalElementProxy_advise_(aJunEdgeOrProxy, this.edgeProxy2);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public void execute() {
		JunEdge fromEdge;
		JunEdge toEdge;

		this.vertex1_(JunVertex.Point_(this.point()));
		this.edge_(JunEdge.StartVertex_endVertex_(this.vertex1(), this.vertex2()));
		this.vertex1().edge_(this.edge());
		this.edge().leftLoop_(this.loop());
		this.edge().rightLoop_(this.loop());

		if (this.edge2() == null) {
			fromEdge = this.loop().edgeToVertex_(this.vertex2());
			this.edge2_(fromEdge);
		} else {
			fromEdge = this.edge2();
		}

		toEdge = fromEdge.nextEdgeWithVertex_(this.vertex2());
		fromEdge.setNextEdge_withVertex_(this.edge(), this.vertex2());
		this.edge().setNextEdge_withVertex_(this.edge(), this.vertex1());
		this.edge().setNextEdge_withVertex_(toEdge, this.vertex2());
		this.body().addVertex_(this.vertex1());
		this.body().addEdge_(this.edge());
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.abstracts.JunAbstractOperator
	 */
	public JunAbstractOperator inverse() {
		return (JunAbstractOperator) (JunKEV.Body_edge_vertex_adviseEdge_(this.body(), this.edgeProxy, this.vertexProxy1, this.edgeProxy2));
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunLoop
	 */
	public JunLoop loop() {
		return (JunLoop) this.getTopologicalElement_(this.loopProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunLoopOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void loop_(JunTopologicalElementOrProxy aJunLoopOrProxy) {
		this.loopProxy = (JunLoopProxy) this.getTopologicalElementProxy_advise_(aJunLoopOrProxy, this.loopProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.Junedge
	 */
	public JunEdge newEdge() {
		return this.edge();
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunVertex
	 */
	public JunVertex newVertex() {
		return this.vertex1();
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.Geometry.basic.Jun3dPoint
	 */
	public Jun3dPoint point() {
		return this.point;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param a3dPoint jp.co.sra.jun.Geometry.basic.Jun3dPoint
	 */
	public void point_(Jun3dPoint a3dPoint) {
		this.point = a3dPoint;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return boolean
	 */
	public boolean precondition() {
		JunLoop loop;
		JunVertex vertex2;

		if (this.edge() != null) {
			return false;
		}

		loop = this.loop();

		if (loop == null) {
			return false;
		}

		if (this.vertex1() != null) {
			return false;
		}

		vertex2 = this.vertex2();

		if (vertex2 == null) {
			return false;
		}

		return (super.precondition() && loop.includesVertex_(vertex2));
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunVertex
	 */
	public JunVertex vertex1() {
		return (JunVertex) this.getTopologicalElement_(this.vertexProxy1);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunVertexOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void vertex1_(JunTopologicalElementOrProxy aJunVertexOrProxy) {
		this.vertexProxy1 = (JunVertexProxy) this.getTopologicalElementProxy_advise_(aJunVertexOrProxy, this.vertexProxy1);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunVertex
	 */
	public JunVertex vertex2() {
		return (JunVertex) this.getTopologicalElement_(this.vertexProxy2);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunVertexOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void vertext2_(JunTopologicalElementOrProxy aJunVertexOrProxy) {
		this.vertexProxy2 = (JunVertexProxy) this.getTopologicalElementProxy_advise_(aJunVertexOrProxy, this.vertexProxy2);
	}
}
