package jp.co.sra.jun.topology.euleroperators;

import jp.co.sra.jun.geometry.basic.*;
import jp.co.sra.jun.topology.abstracts.*;
import jp.co.sra.jun.topology.elements.*;

/**
 * JunMEVVL class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   1999/08/04 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMEVVL.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunMEVVL extends JunEulerOperator {
	protected JunEdgeProxy edgeProxy;
	protected JunVertexProxy vertexProxy1;
	protected JunVertexProxy vertexProxy2;
	protected JunLoopProxy loopProxy;
	protected Jun3dPoint point1;
	protected Jun3dPoint point2;

	/**
	 * Create a new instance of JunMEVVL and initialize it with a JunBody.
	 * 
	 * @param aBody jp.co.sra.jun.topology.elements.JunBody
	 */
	public JunMEVVL(JunBody aBody) {
		super(aBody);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aJun3dPoint1 jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aJun3dPoint2 jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * 
	 * @return jp.co.sra.jun.topology.euleroperators.JunMEVVL
	 */
	public static JunMEVVL Body_point_point_(JunBody aJunBody, Jun3dPoint aJun3dPoint1, Jun3dPoint aJun3dPoint2) {
		return Body_point_point_adviseEdge_vertex_vertex_loop_(aJunBody, aJun3dPoint1, aJun3dPoint2, null, null, null, null);
	}

	/**
	 * Create a new instance of JunMEVVL and initialize it.
	 * 
	 * @param aJunBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aJun3dPoint1 jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aJun3dPoint2 jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunVertexOrProxy1
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunVertexOrProxy2
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxyOrProxy1
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunLoopOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * 
	 * @return jp.co.sra.jun.topology.euleroperators.JunMEVVL
	 */
	public static final JunMEVVL Body_point_point_adviseEdge_vertex_vertex_loop_(
		JunBody aJunBody,
		Jun3dPoint aJun3dPoint1,
		Jun3dPoint aJun3dPoint2,
		JunTopologicalElementOrProxy aJunEdgeOrProxy,
		JunTopologicalElementOrProxy aJunVertexOrProxy1,
		JunTopologicalElementOrProxy aJunVertexOrProxy2,
		JunTopologicalElementOrProxy aJunLoopOrProxy) {
		JunMEVVL anOperator = new JunMEVVL(aJunBody);
		anOperator.point1_(aJun3dPoint1);
		anOperator.point2_(aJun3dPoint2);
		anOperator.edge_(aJunEdgeOrProxy);
		anOperator.vertex1_(aJunVertexOrProxy1);
		anOperator.vertex2_(aJunVertexOrProxy2);
		anOperator.loop_(aJunLoopOrProxy);

		return anOperator;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunEdge
	 */
	public JunEdge edge() {
		return (JunEdge) this.getTopologicalElement_(edgeProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void edge_(JunTopologicalElementOrProxy aJunEdgeOrProxy) {
		this.edgeProxy = (JunEdgeProxy) this.getTopologicalElementProxy_advise_(aJunEdgeOrProxy, this.edgeProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public void execute() {
		this.vertex1_(JunVertex.Point_(this.point1()));
		this.vertex2_(JunVertex.Point_(this.point2()));
		this.edge_(JunEdge.StartVertex_endVertex_(this.vertex1(), this.vertex2()));
		this.vertex1().edge_(this.edge());
		this.vertex2().edge_(this.edge());
		this.loop_(JunLoop.Edge_(this.edge()));
		this.vertex1().edge_(this.edge());
		this.vertex2().edge_(this.edge());
		this.edge().startRightEdge_(this.edge());
		this.edge().endLeftEdge_(this.edge());
		this.edge().leftLoop_(this.loop());
		this.edge().rightLoop_(this.loop());
		this.body().addVertex_(this.vertex1());
		this.body().addVertex_(this.vertex2());
		this.body().addEdge_(this.edge());
		this.body().addLoop_(this.loop());
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.abstracts.JunAbstractOperator
	 */
	public JunAbstractOperator inverse() {
		return (JunAbstractOperator) (JunKEVVL.Body_edge_(this.body(), this.edgeProxy));
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunLoop
	 */
	public JunLoop loop() {
		return (JunLoop) this.getTopologicalElement_(loopProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunLoopOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void loop_(JunTopologicalElementOrProxy aJunLoopOrProxy) {
		this.loopProxy = (JunLoopProxy) this.getTopologicalElementProxy_advise_(aJunLoopOrProxy, this.loopProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunEdge
	 */
	public JunEdge newEdge() {
		return this.edge();
	}

	/**
	 * Answer my new loop.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunLoop
	 */
	public JunLoop newLoop() {
		return this.loop();
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunVertex
	 */
	public JunVertex newVertex1() {
		return this.vertex1();
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunVertex
	 */
	public JunVertex newVertex2() {
		return this.vertex2();
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 */
	public Jun3dPoint point1() {
		return this.point1;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param a3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 */
	public void point1_(Jun3dPoint a3dPoint) {
		this.point1 = a3dPoint;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 */
	public Jun3dPoint point2() {
		return this.point2;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param a3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 */
	public void point2_(Jun3dPoint a3dPoint) {
		this.point2 = a3dPoint;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return boolean
	 */
	public boolean precondition() {
		if (this.edge() != null) {
			return false;
		} else if (this.vertex1() != null) {
			return false;
		} else if (this.vertex2() != null) {
			return false;
		} else if (this.loop() != null) {
			return false;
		} else {
			return (super.precondition());
		}
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunVertex
	 */
	public JunVertex vertex1() {
		return (JunVertex) this.getTopologicalElement_(this.vertexProxy1);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunVertexOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void vertex1_(JunTopologicalElementOrProxy aJunVertexOrProxy) {
		this.vertexProxy1 = (JunVertexProxy) this.getTopologicalElementProxy_advise_(aJunVertexOrProxy, this.vertexProxy1);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunVertex
	 */
	public JunVertex vertex2() {
		return (JunVertex) this.getTopologicalElement_(this.vertexProxy2);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunVertexOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void vertex2_(JunTopologicalElementOrProxy aJunVertexOrProxy) {
		this.vertexProxy2 = (JunVertexProxy) this.getTopologicalElementProxy_advise_(aJunVertexOrProxy, this.vertexProxy2);
	}
}
