package jp.co.sra.jun.topology.geometricoperators;

import jp.co.sra.jun.collections.sequences.*;
import jp.co.sra.jun.geometry.basic.*;
import jp.co.sra.jun.geometry.surfaces.*;
import jp.co.sra.jun.system.support.*;
import jp.co.sra.jun.topology.elements.*;
import jp.co.sra.jun.topology.euleroperators.*;

/**
 * JunKSFTestExamples class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunKSFTestExamples.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunKSFTestExamples extends JunTestExamples {

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static boolean Example1() {
		JunBody body;
		JunMEVVL mevvl;
		JunMEL mel;
		JunMVE mve;
		JunMatrix matrix;
		JunNurbsSurface surface;
		JunMSF msf;
		JunLoop loop;
		JunKSF ksf;

		//
		body = new JunBody();
		mevvl = JunMEVVL.Body_point_point_(body, new Jun3dPoint(0, 0, 0), new Jun3dPoint(1, 0, 0));
		mevvl.doOperation();
		mel = JunMEL.Body_loop_vertex_vertex_(body, mevvl.loop(), mevvl.vertex1(), mevvl.vertex2());
		mel.doOperation();
		loop = mel.newLoop();
		mve = JunMVE.Body_edge_point_(body, mel.newEdge(), new Jun3dPoint(0, -1, 0));
		mve.doOperation();
		matrix = new JunMatrix(3);
		matrix._put(0, 0, new Jun3dPoint(0, 0, 0));
		matrix._put(0, 1, new Jun3dPoint(0.5, 0, 0));
		matrix._put(0, 2, new Jun3dPoint(1, 0, 0));
		matrix._put(1, 0, new Jun3dPoint(0.25, -0.25, 0));
		matrix._put(1, 1, new Jun3dPoint(0.375, -0.375, 1));
		matrix._put(1, 2, new Jun3dPoint(0.5, -0.5, 0));
		matrix._put(2, 0, new Jun3dPoint(0, -0.5, 0));
		matrix._put(2, 1, new Jun3dPoint(0, -0.75, 0));
		matrix._put(2, 2, new Jun3dPoint(0, -1, 0));
		surface = JunNurbsSurface.BezierControlPoints_(matrix);
		msf = JunMSF.Body_loop_surface_(body, loop, surface);
		msf.doOperation();
		body.show();
		ksf = JunKSF.Body_loop_(body, loop);
		ksf.doOperation();
		body.show();

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param args DOCUMENT ME!
	 */
	public static void main(String[] args) {
		new JunKSFTestExamples();
	}
} //the end of JunKSFExamples
