package jp.co.sra.jun.topology.geometricoperators;

import jp.co.sra.jun.geometry.basic.*;
import jp.co.sra.jun.geometry.curves.*;
import jp.co.sra.jun.system.support.*;
import jp.co.sra.jun.topology.elements.*;
import jp.co.sra.jun.topology.euleroperators.*;

/**
 * JunTCVTestExamples class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunTCVTestExamples.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunTCVTestExamples extends JunTestExamples {

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static boolean Example1() {
		JunBody body;
		JunMEVVL mevvl;
		JunEdge edge;
		JunMEL mel;
		JunMVE mve;
		JunNurbsCurve curve;
		JunMCV mcv;
		JunTCV tcv;

		//
		body = new JunBody();
		mevvl = JunMEVVL.Body_point_point_(body, new Jun3dPoint(0, 0, 0), new Jun3dPoint(1, 0, 0));
		mevvl.doOperation();
		edge = mevvl.edge();
		mel = JunMEL.Body_loop_vertex_vertex_(body, mevvl.loop(), mevvl.vertex1(), mevvl.vertex2());
		mel.doOperation();
		mve = JunMVE.Body_edge_point_(body, mel.newEdge(), new Jun3dPoint(0, -1, 0));
		mve.doOperation();
		curve = JunNurbsCurve.BezierControlPoints_(new Jun3dPoint[] { new Jun3dPoint(0, 0, 0), new Jun3dPoint(0.5, 0, 0.5), new Jun3dPoint(1, 0, 0)});
		mcv = JunMCV.Body_edge_curve_(body, edge, curve);
		mcv.doOperation();
		body.asWireframedOpenGL3dObject().show();
		tcv = JunTCV.Body_edge_number_vector_(body, edge, 1, new Jun3dPoint(0, 0, -1));
		tcv.doOperation();
		body.asWireframedOpenGL3dObject().show();

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param args DOCUMENT ME!
	 */
	public static void main(String[] args) {
		new JunTCVTestExamples();
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static boolean ManualExample1() {
		JunBody body = new JunBody();

		JunMEVVL mevvl = JunMEVVL.Body_point_point_(body, new Jun3dPoint(1, 0, 0), new Jun3dPoint(0, 1, 0));
		mevvl.doOperation();

		JunEdge edge = mevvl.newEdge();
		JunVertex vertex100 = mevvl.newVertex1();
		JunVertex vertex010 = mevvl.newVertex2();

		JunMEV mev = JunMEV.Body_vertex_loop_point_(body, vertex100, mevvl.loop(), new Jun3dPoint(0, 0, 0));
		mev.doOperation();

		JunVertex vertex000 = mev.newVertex();

		JunMEL mel = JunMEL.Body_loop_vertex_vertex_(body, mevvl.loop(), vertex010, vertex000);
		mel.doOperation();

		JunNurbsCurve curve = JunNurbsCurve.BezierControlPoints_(new Jun3dPoint[] { new Jun3dPoint(1, 0, 0), new Jun3dPoint(0.5, 0.5, -0.5), new Jun3dPoint(0, 1, 0)});
		JunMCV mcv = JunMCV.Body_edge_curve_(body, edge, curve);
		mcv.doOperation();

		body.show();

		JunTCV tcv = JunTCV.Body_edge_number_vector_(body, edge, 2, new Jun3dPoint(0, 0, 1));
		tcv.doOperation();
		body.show();

		System.out.println("-------- edge");
		System.out.println(tcv.edge());
		System.out.println("-------- number");
		System.out.println(tcv.number());
		System.out.println("-------- vector");
		System.out.println(tcv.vector());

		return true;
	}
}
