package jp.co.sra.jun.topology.globaloperators;

import java.util.Vector;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.surfaces.Jun3dPolygon;
import jp.co.sra.jun.topology.abstracts.JunAbstractOperator;
import jp.co.sra.jun.topology.abstracts.JunGlobalOperator;
import jp.co.sra.jun.topology.elements.JunBody;
import jp.co.sra.jun.topology.elements.JunEdge;
import jp.co.sra.jun.topology.elements.JunLoop;

/**
 * JunNEGATE class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunNEGATE.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunNEGATE extends JunGlobalOperator {

	/**
	 * Create a new instance of JunNEGATE and initialize it with a body.
	 * 
	 * @param aBody jp.co.sra.jun.topology.elements.JunBody
	 */
	public JunNEGATE(JunBody aBody) {
		super(aBody);
	}

	/**
	 * Create a new instance of JunNEGATE and initialize it with a body.
	 * 
	 * @param aBody jp.co.sra.jun.topology.elements.JunBody
	 * 
	 * @return DOCUMENT ME!
	 */
	public static final JunNEGATE Body_(JunBody aBody) {
		return new JunNEGATE(aBody);
	}

	/**
	 * Execute the operation.
	 */
	public void execute() {
		final Vector connections = new Vector(body.numberOfEdges());
		body.edgesDo_(new StBlockClosure() {
			public Object value_(Object anObject) {
				JunEdge edge = (JunEdge) anObject;
				JunEdge rightPrev = edge.prevEdgeWithVertex_(edge.startVertex());
				JunEdge leftPrev = edge.prevEdgeWithVertex_(edge.endVertex());
				JunEdge[] anArray = { edge, rightPrev, leftPrev };
				connections.addElement(anArray);

				return null;
			}
		});

		int size = connections.size();

		for (int i = 0; i < size; i++) {
			JunEdge[] edgeRightLeft = (JunEdge[]) connections.elementAt(i);
			JunEdge edge = edgeRightLeft[0];
			JunEdge startRightEdge = edgeRightLeft[1];
			JunEdge endLeftEdge = edgeRightLeft[2];
			edge.startRightEdge_(startRightEdge);
			edge.endLeftEdge_(endLeftEdge);

			JunLoop leftLoop = edge.leftLoop();
			JunLoop rightLoop = edge.rightLoop();
			edge.leftLoop_(rightLoop);
			edge.rightLoop_(leftLoop);
		}

		body.edgesDo_(new StBlockClosure() {
			public Object value_(Object anObject) {
				JunEdge edge = (JunEdge) anObject;
				Jun3dLine curve = (Jun3dLine) edge.basicCurve();

				if (curve != null) {
					edge.setCurve_(curve.reversed());
				}

				return null;
			}
		});
		body.loopsDo_(new StBlockClosure() {
			public Object value_(Object anObject) {
				JunLoop loop = (JunLoop) anObject;
				Jun3dPolygon surface = (Jun3dPolygon) loop.basicSurface();

				if (surface != null) {
					loop.setSurface_(surface.reversed());
				}

				return null;
			}
		});
	}

	/**
	 * Answer the inverse operation of the receiver.
	 * 
	 * @return jp.co.sra.jun.topology.abstracts.JunAbstractOperator
	 */
	public JunAbstractOperator inverse() {
		return new JunNEGATE(this.body());
	}
}
