package jp.co.sra.jun.topology.globaloperators;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.jun.geometry.abstracts.JunCurve;
import jp.co.sra.jun.geometry.abstracts.JunSurface;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.surfaces.Jun3dPolygon;
import jp.co.sra.jun.topology.abstracts.JunAbstractOperator;
import jp.co.sra.jun.topology.abstracts.JunGlobalOperator;
import jp.co.sra.jun.topology.elements.JunBody;
import jp.co.sra.jun.topology.elements.JunEdge;
import jp.co.sra.jun.topology.elements.JunLoop;
import jp.co.sra.jun.topology.elements.JunVertex;
import jp.co.sra.jun.topology.support.JunGeometryTransformer;

/**
 * JunPointSCALE class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunPointSCALE.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunPointSCALE extends JunGlobalOperator {
	protected Jun3dPoint point;
	protected double factor;

	/**
	 * Create a new instance of JunPointSCALE and initialize it.
	 * 
	 * @param aJunBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aNumber double
	 * 
	 * @return jp.co.sra.jun.topology.globaloperators.JunPointSCALE
	 */
	public static final JunPointSCALE Body_factor_(JunBody aJunBody, double aNumber) {
		return JunPointSCALE.Body_point_factor_(aJunBody, Jun3dPoint.Zero(), aNumber);
	}

	/**
	 * Create a new instance of JunPointSCALE and initialize it.
	 * 
	 * @param aJunBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aJun3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aNumber double
	 * 
	 * @return jp.co.sra.jun.topology.globaloperators.JunPointSCALE
	 */
	public static final JunPointSCALE Body_point_factor_(JunBody aJunBody, Jun3dPoint aJun3dPoint, double aNumber) {
		JunPointSCALE anOperator = new JunPointSCALE();
		anOperator.body_(aJunBody);
		anOperator.point_(aJun3dPoint);
		anOperator.factor_(aNumber);

		return anOperator;
	}

	/**
	 * Execute the receiver.
	 */
	public void execute() {
		final JunPointSCALE self = this;
		StBlockClosure scaleBlock = new StBlockClosure() {
			public Object value_(Object anObject) {
				Jun3dPoint p = (Jun3dPoint) anObject;
				Jun3dPoint relativePosition = (Jun3dPoint) (p.minus_(self.point()));

				return relativePosition.multipliedBy_(factor).plus_(self.point());
			}
		};

		final JunGeometryTransformer transformer = JunGeometryTransformer.Block_(scaleBlock);
		this.body().vertexesDo_(new StBlockClosure() {
			public Object value_(Object anObject) {
				JunVertex vertex = (JunVertex) anObject;

				if (vertex.point() != null) {
					vertex.point_((Jun3dPoint) vertex.point().transform_(transformer));
				}

				return null;
			}
		});
		this.body().edgesDo_(new StBlockClosure() {
			public Object value_(Object anObject) {
				JunEdge edge = (JunEdge) anObject;
				Jun3dLine curve = (Jun3dLine) edge.basicCurve();

				if (curve != null) {
					edge.setCurve_((JunCurve) curve.transform_(transformer));
				}

				return null;
			}
		});
		this.body().loopsDo_(new StBlockClosure() {
			public Object value_(Object anObject) {
				JunLoop loop = (JunLoop) anObject;
				Jun3dPolygon surface = (Jun3dPolygon) loop.basicSurface();

				if (surface != null) {
					loop.setSurface_((JunSurface) surface.transform_(transformer));
				}

				return null;
			}
		});
	}

	/**
	 * Answer the factor.
	 * 
	 * @return double
	 */
	public final double factor() {
		return factor;
	}

	/**
	 * Set the factor.
	 * 
	 * @param aNumber double
	 */
	public final void factor_(double aNumber) {
		factor = aNumber;
	}

	/**
	 * Answer the inverse operation of the receiver.
	 * 
	 * @return jp.co.sra.jun.topology.abstracts.JunAbstractOperator
	 */
	public JunAbstractOperator inverse() {
		return JunPointSCALE.Body_point_factor_(this.body(), this.point(), 1.0d / this.factor());
	}

	/**
	 * Answer the point.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 */
	public final Jun3dPoint point() {
		return point;
	}

	/**
	 * Set the point.
	 * 
	 * @param aJun3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 */
	public final void point_(Jun3dPoint aJun3dPoint) {
		point = aJun3dPoint;
	}
}
