package jp.co.sra.jun.topology.setoperators;

import java.util.Vector;
import jp.co.sra.jun.topology.abstracts.JunSetOperator;
import jp.co.sra.jun.topology.elements.JunBody;
import jp.co.sra.jun.topology.globaloperators.JunNEGATE;
import jp.co.sra.jun.topology.setoperators.JunUNION;

/**
 * JunDIFF class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunDIFF.java,v 8.10 2008/02/20 06:33:13 nisinaka Exp $
 */
public class JunDIFF extends JunSetOperator {
	/** Another JunBody on which the receiver operate. */
	protected JunBody body2 = null;

	/**
	 * Create a new instance of JunDIFF and initialize it with two bodies.
	 * 
	 * @param aBody1 jp.co.sra.jun.topology.elements.JunBody
	 * @param aBody2 jp.co.sra.jun.topology.elements.JunBody
	 */
	public JunDIFF(JunBody aBody1, JunBody aBody2) {
		this.body_(aBody1);
		this.body2_(aBody2);
	}

	/**
	 * Create an instance of JunDIFF with two bodies.
	 * 
	 * @param aJunBody1 jp.co.sra.jun.topology.elements.JunBody
	 * @param aJunBody2 jp.co.sra.jun.topology.elements.JunBody
	 * 
	 * @return jp.co.sra.jun.topology.setoperators.JunDIFF
	 */
	public static final JunDIFF Body_body_(JunBody aJunBody1, JunBody aJunBody2) {
		return new JunDIFF(aJunBody1, aJunBody2);
	}

	/**
	 * Answer the second body of the receiver.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunBody
	 */
	public JunBody body2() {
		return body2;
	}

	/**
	 * Set the second body of the receiver.
	 * 
	 * @param aJunBody jp.co.sra.jun.topology.elements.JunBody
	 */
	public void body2_(JunBody aJunBody) {
		body2 = aJunBody;
	}

	/**
	 * DOCUMENT ME!
	 */
	public void execute() {
		JunNEGATE negate1 = new JunNEGATE(this.body());
		negate1.doOperation();

		JunUNION union = new JunUNION(this.body(), this.body2());
		union.doOperation();

		JunNEGATE negate2 = new JunNEGATE(this.body());
		negate2.doOperation();

		int size = union.suboperators().size();
		suboperators = new Vector(size + 2);
		suboperators.addElement(negate1);

		for (int index = 0; index < size; index++) {
			suboperators.addElement(union.suboperators().elementAt(index));
		}

		suboperators.addElement(negate2);
	}
}
