package jp.co.sra.jun.topology.setoperators;

import java.awt.Color;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.system.support.JunTestExamples;
import jp.co.sra.jun.topology.elements.JunBody;

/**
 * JunINTERTestExamples class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   1999/06/25 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunINTERTestExamples.java,v 8.10 2008/02/20 06:33:13 nisinaka Exp $
 */
public class JunINTERTestExamples extends JunTestExamples {

	/**
	 * JunINTER example1.
	 * 
	 * @return boolean.
	 */
	public static boolean Example1() {
		Jun3dPoint[] points = { new Jun3dPoint(0, 0, 0), new Jun3dPoint(1.5, 0, 0), new Jun3dPoint(0, 1.5, 0), new Jun3dPoint(0, 0, 1.5)};
		JunBody body1 = JunBody.Tetrahedron_(points);
		JunBody body2 = JunBody.UnitCube();
		(new JunINTER(body1, body2)).doOperation();

		JunOpenGL3dObject object = body1.asJunOpenGL3dObject();
		object.paint_(Color.blue);
		object.show();

		return true;
	}

	/**
	 * JunINTER example2.
	 * 
	 * @return boolean.
	 */
	public static boolean Example2() {
		JunBody body1 = JunBody.CubeOrigin_corner_(new Jun3dPoint(-1, -1, -1), new Jun3dPoint(1, 1, 1));
		JunBody body2 = JunBody.CubeOrigin_corner_(new Jun3dPoint(0, 0, 0), new Jun3dPoint(2, 2, 2));
		(new JunINTER(body1, body2)).doOperation();
		body1.show();

		return true;
	}

	/**
	 * JunINTER example3.
	 * 
	 * @return boolean.
	 */
	public static boolean Example3() {
		JunBody body1 = JunBody.CubeOrigin_corner_(new Jun3dPoint(-1, -1, -1), new Jun3dPoint(2, 1, 1));
		JunBody body2 = JunBody.CubeOrigin_corner_(new Jun3dPoint(0, 0, 0), new Jun3dPoint(1, 2, 2));
		(new JunINTER(body1, body2)).doOperation();

		JunOpenGL3dObject object = body1.asJunOpenGL3dObject();
		object.paint_(Color.blue);
		object.show();

		return true;
	}

	/**
	 * JunINTER example4.
	 * 
	 * @return boolean.
	 */
	public static boolean Example4() {
		JunBody body1 = JunBody.CubeOrigin_corner_(new Jun3dPoint(-3, -1, -1), new Jun3dPoint(1, 3, 1));
		JunBody body2 = JunBody.GlobeLatitudes_longitudes_center_radius_(9, 18, new Jun3dPoint(0, 0, 0), 2.0);
		JunINTER conj = new JunINTER(body1, body2);
		conj.doOperation();

		JunOpenGL3dObject object = body1.asJunOpenGL3dObject();
		object.paint_(Color.blue);
		object.show();

		return true;
	}

	/**
	 * JunINTER example5.
	 * 
	 * @return boolean.
	 */
	public static boolean Example5() {
		JunBody body1 = JunBody.GlobeLatitudes_longitudes_center_radius_(9, 18, new Jun3dPoint(2, 1, 0), 2.01);
		JunBody body2 = JunBody.GlobeLatitudes_longitudes_center_radius_(9, 18, new Jun3dPoint(0, 0, 0), 2.01);
		(new JunINTER(body1, body2)).doOperation();

		JunOpenGL3dObject object = body1.asJunOpenGL3dObject();
		object.paint_(Color.blue);
		object.show();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunINTERTestExamples();
	}
}
