package jp.co.sra.jun.topology.support;

import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.collections.sequences.JunDoubleMatrix;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunPoint;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;

/**
 * JunGeometryTransformer class
 * 
 *  @author    nisinaka
 *  @created   1998/12/02 (by nisinaka)
 *  @updated   2000/01/06 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun697 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunGeometryTransformer.java,v 8.11 2008/02/20 06:33:14 nisinaka Exp $
 */
public class JunGeometryTransformer extends Jun3dTransformation {
	/** The block closure to be used for a transformation. */
	protected StBlockClosure block = null;

	/**
	 * Create a new instance of JunGeometryTransformer and initialize it with
	 * the StBlockClosure.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 */
	public JunGeometryTransformer(StBlockClosure aBlock) {
		super();
		this.block_(aBlock);
	}

	/**
	 * Can not create an instance without specifying a StBlockClosure.
	 * 
	 * @category Instance creation
	 */
	private JunGeometryTransformer() {
		super();
	}

	/**
	 * Create a new instance of JunGeometryTransformer and initialize it with
	 * the StBlockClosure.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * 
	 * @return jp.co.sra.jun.topology.support.JunGeometryTransformer
	 */
	public static JunGeometryTransformer Block_(StBlockClosure aBlock) {
		return new JunGeometryTransformer(aBlock);
	}

	/**
	 * Apply this transformation to aPoint and return the result.
	 * 
	 * @param aPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 */
	public Jun3dPoint applyToPoint_(JunPoint aPoint) {
		return (Jun3dPoint) block.value_(aPoint);
	}

	/**
	 * Convert this transformation as an array.
	 * 
	 * @return double[]
	 * @see jp.co.sra.jun.geometry.transformations.Jun3dTransformation#asArray()
	 * @category converting
	 */
	public double[] asArray() {
		throw SmalltalkException.ShouldNotImplement();
	}

	/**
	 * Convert this transformation as a matrix.
	 * 
	 * @return jp.co.sra.jun.collections.sequences.JunDoubleMatrix
	 * @see jp.co.sra.jun.geometry.transformations.Jun3dTransformation#asMatrix()
	 * @category converting
	 */
	public JunDoubleMatrix asMatrix() {
		throw SmalltalkException.ShouldNotImplement();
	}

	/**
	 * Answer true if aTransformation is equal to this point, otherwise false.
	 * 
	 * @param anObject java.lang.Object
	 * @return boolean
	 * @see jp.co.sra.jun.geometry.transformations.Jun3dTransformation#equals(java.lang.Object)
	 * @category comparing
	 */
	public boolean equals(Object anObject) {
		throw SmalltalkException.ShouldNotImplement();
	}

	/**
	 * Set the instance variable "block".
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 */
	private void block_(StBlockClosure aBlock) {
		block = aBlock;
	}
}
