package jp.co.sra.jun.voronoi.twoD.diagram;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Random;

import javax.swing.JFrame;
import javax.swing.JPanel;

import jp.co.sra.smalltalk.StApplicationModel;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StColorValue;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.surfaces.Jun2dCircle;
import jp.co.sra.jun.geometry.surfaces.Jun2dPolygon;
import jp.co.sra.jun.goodies.image.framework.JunImageDisplayModel;
import jp.co.sra.jun.goodies.utilities.JunImageUtility;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunDelaunay2dDiagramTestExamples class
 * 
 *  @author    NISHIHARA Satoshi
 *  @created   2000/02/07 (by NISHIHARA Satoshi)
 *  @updated   2006/11/09 (by nisinaka)
 *  @updated   2007/05/13 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun662 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunDelaunay2dDiagramTestExamples.java,v 8.11 2008/02/20 06:33:14 nisinaka Exp $
 */
public class JunDelaunay2dDiagramTestExamples extends JunTestExamples {
	/**
	 * Example1:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunDelaunay2dDiagram diagram = new JunDelaunay2dDiagram(200, 200);
		for (int i = 0; i < 50; i++) {
			Jun2dPoint aPoint = new Jun2dPoint(Math.random() * diagram.width(), Math.random() * diagram.height());
			diagram.add_(aPoint);
		}

		System.out.println("area: " + diagram.area());
		diagram.show();

		return true;
	}

	/**
	 * Example2:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunDelaunay2dDiagram diagram = new JunDelaunay2dDiagram(200, 200);
		for (int i = 0; i < 50; i++) {
			Jun2dPoint aPoint = new Jun2dPoint(Math.random() * diagram.width(), Math.random() * diagram.height());
			diagram.add_(aPoint);
		}

		diagram.show();
		diagram.asVoronoiDiagram().show();
		System.out.println("area: " + diagram.area());

		return true;
	}

	/**
	 * Example3:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		final JunDelaunay2dDiagram diagram = new JunDelaunay2dDiagram(200, 200);

		final JPanel canvas = new JPanel() {
			public void paint(Graphics aGraphics) {
				diagram.displayOn_(aGraphics);
			}
		};
		canvas.setPreferredSize(new Dimension(200, 200));

		JFrame aFrame = new JFrame();
		aFrame.setTitle(diagram.labelString());
		aFrame.getContentPane().setLayout(new BorderLayout());
		aFrame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				e.getWindow().dispose();
			}
		});
		aFrame.getContentPane().add(canvas);
		aFrame.pack();
		StApplicationModel._ShowAtMousePoint(aFrame);

		Thread aThread = new Thread() {
			public void run() {
				while (canvas.isShowing()) {
					diagram.add_(new Jun2dPoint(Math.random() * diagram.width(), Math.random() * diagram.height()));
					canvas.paintImmediately(canvas.getBounds());
					Thread.yield();
				}
			}
		};
		aThread.setPriority(Thread.NORM_PRIORITY - 1);
		aThread.start();

		return true;
	}

	/**
	 * Example4: Low precision
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		JunDelaunay2dDiagram diagram = new JunDelaunay2dDiagram(200, 200);

		Jun2dPoint[] points = new Jun2dPoint[9];
		points[0] = new Jun2dPoint(0.1d, 0.1d);
		points[1] = new Jun2dPoint(0.1d, 0.9d);
		points[2] = new Jun2dPoint(0.9d, 0.1d);
		points[3] = new Jun2dPoint(0.9d, 0.9d);
		points[4] = new Jun2dPoint(0.5d, 0.5d);
		points[5] = new Jun2dPoint(0.1d, 0.5d);
		points[6] = new Jun2dPoint(0.9d, 0.5d);
		points[7] = new Jun2dPoint(0.5d, 0.1d);
		points[8] = new Jun2dPoint(0.5d, 0.9d);

		for (int i = 0; i < points.length; i++) {
			double x = points[i].x() * diagram.width();
			double y = points[i].y() * diagram.height();
			diagram.add_(new Jun2dPoint(x, y));
		}

		System.out.println("area: " + diagram.area());
		diagram.show();

		return true;
	}

	/**
	 * Example5: Low precision
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example5() {
		JunDelaunay2dDiagram diagram = new JunDelaunay2dDiagram(200, 200);

		int count = 0;
		for (int y = 0; y <= 10; y++) {
			for (int x = 0; x <= 10; x++) {
				if (count % 2 == 0) {
					double px = x / 10.0 * diagram.width();
					double py = y / 10.0 * diagram.height();
					diagram.add_(new Jun2dPoint(px, py));
				}
				count++;
			}
		}

		System.out.println("area: " + diagram.area());
		diagram.show();

		return true;
	}

	/**
	 * Example6: Low precision
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example6() {
		JunDelaunay2dDiagram diagram = new JunDelaunay2dDiagram(200, 200);

		ArrayList aList = new ArrayList();
		aList.add(new Jun2dPoint(0, 0));
		int step = 10;
		for (int degrees = 0; degrees <= 360; degrees += step) {
			JunAngle angle = JunAngle.FromDeg_(degrees);
			aList.add(new Jun2dPoint(angle.cos(), angle.sin()));
			angle = JunAngle.FromDeg_(degrees + step / 2);
			aList.add(new Jun2dPoint(angle.cos() * 0.5, angle.sin() * 0.5));
		}
		Jun2dPoint[] points = (Jun2dPoint[]) aList.toArray(new Jun2dPoint[aList.size()]);
		for (int i = 0; i < points.length; i++) {
			double x = (points[i].x() + 1) * diagram.width() / 2;
			double y = (points[i].y() + 1) * diagram.height() / 2;
			diagram.add_(new Jun2dPoint(x, y));
		}

		System.out.println("area: " + diagram.area());
		diagram.show();

		return true;
	}

	/**
	 * Example7:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example7() {
		return JunVoronoi2dDiagramTestExamples.Example7();
	}

	/**
	 * Example8:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example8() {
		return JunVoronoi2dDiagramTestExamples.Example8();
	}

	/**
	 * Example9:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example9() {
		JunDelaunay2dDiagram diagram = new JunDelaunay2dDiagram(200, 200);
		diagram.add_(new Jun2dPoint(50, 100));
		diagram.add_(new Jun2dPoint(150, 100));

		System.out.println("area: " + diagram.area());
		diagram.show();

		return true;
	}

	/**
	 * ExampleA:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ExampleA() {
		Dimension extent = new Dimension(200, 200);
		int numOfPoints = 50;
		final Color hullColor = StColorValue.Navy;
		final JunDelaunay2dDiagram delaunay = new JunDelaunay2dDiagram(extent);
		Image image = JunImageUtility.ImageExtent_(extent);
		JunImageDisplayModel model = JunImageDisplayModel.Show_label_(image, "Convex Hull");
		Random random = new Random();
		for (int i = 0; i < numOfPoints; i++) {
			delaunay.add_(new Jun2dPoint(random.nextDouble() * extent.width, random.nextDouble() * extent.height));
			image = JunImageUtility.ImageExtent_displayBlock_(extent, new StBlockClosure() {
				public Object value_(Object obj) {
					Graphics graphicsContext = (Graphics) obj;
					delaunay.displayOn_(graphicsContext);
					Jun2dPolygon convexHull = delaunay.convexHull();
					Jun2dPoint[] convexHullVertexes = convexHull.points();
					int[] xPoints = new int[convexHullVertexes.length + 1];
					int[] yPoints = new int[convexHullVertexes.length + 1];
					for (int j = 0; j < convexHullVertexes.length; j++) {
						xPoints[j] = (int) Math.round(convexHullVertexes[j].x());
						yPoints[j] = (int) Math.round(convexHullVertexes[j].y());
					}
					xPoints[xPoints.length - 1] = (int) Math.round(convexHullVertexes[0].x());
					yPoints[yPoints.length - 1] = (int) Math.round(convexHullVertexes[0].y());
					graphicsContext.setColor(hullColor);
					graphicsContext.drawPolyline(xPoints, yPoints, xPoints.length);

					return null;
				}
			});
			model.image_(image);
			model.redisplay();
		}

		return true;
	}

	/**
	 * ExampleB:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ExampleB() {
		Dimension pointsExtent = new Dimension(200, 200);
		int numOfPoints = 50;
		final Color pointColor = Color.blue;
		final Color minimalEnclosingCircleColor = Color.green;
		final Dimension minimalEnclosingCircleCenterExtent = new Dimension(3, 3);
		final int pointDiameter = 4;
		int value = (int) Math.ceil(new Jun2dPoint(0, 0).distance_(new Jun2dPoint(pointsExtent.width, pointsExtent.height)));
		Dimension displayExtent = new Dimension(value, value);
		final Point displayOriginOffset = new Point((displayExtent.width - pointsExtent.width) / 2, (displayExtent.height - pointsExtent.height) / 2);
		Random random = new Random();
		final Jun2dPoint[] points = new Jun2dPoint[numOfPoints];

		final JunDelaunay2dDiagram delaunay = new JunDelaunay2dDiagram(pointsExtent);
		Image image = JunImageUtility.ImageExtent_(displayExtent);
		JunImageDisplayModel model = JunImageDisplayModel.Show_label_(image, "Minimal Enclosing Circle");
		for (int i = 0; i < numOfPoints; i++) {
			Jun2dPoint newPoint = new Jun2dPoint(random.nextDouble() * pointsExtent.width, random.nextDouble() * pointsExtent.height);
			points[i] = newPoint;
			delaunay.add_(newPoint);
			final Jun2dCircle minimalEnclosingCircle = delaunay.minimalEnclosingCircle();

			image = JunImageUtility.ImageExtent_displayBlock_(displayExtent, new StBlockClosure() {
				public Object value_(Object obj) {
					Graphics2D gc = (Graphics2D) ((Graphics) obj).create();
					try {
						gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
						gc.translate(displayOriginOffset.x, displayOriginOffset.y);
						gc.setColor(pointColor);
						for (int j = 0; j < points.length; j++) {
							if (points[j] == null) {
								break;
							}
							int xo = ((int) Math.round(points[j].x() * 2 - pointDiameter + 1)) / 2;
							int yo = ((int) Math.round(points[j].y() * 2 - pointDiameter + 1)) / 2;
							gc.drawArc(xo, yo, pointDiameter, pointDiameter, 0, 360);
						}
						gc.setColor(minimalEnclosingCircleColor);
						gc.drawArc((int) (minimalEnclosingCircle.center().x() - minimalEnclosingCircle.radius()), (int) (minimalEnclosingCircle.center().y() - minimalEnclosingCircle.radius()), (int) (minimalEnclosingCircle.radius() * 2),
								(int) (minimalEnclosingCircle.radius() * 2), 0, 360);
						Rectangle centerMark = new Rectangle((int) (minimalEnclosingCircle.center().x() - minimalEnclosingCircleCenterExtent.width / 2.0), (int) (minimalEnclosingCircle.center().y() - minimalEnclosingCircleCenterExtent.height / 2.0),
								minimalEnclosingCircleCenterExtent.width, minimalEnclosingCircleCenterExtent.height);
						gc.drawRect(centerMark.x, centerMark.y, centerMark.width, centerMark.height);
					} finally {
						if (gc != null) {
							gc.dispose();
						}
					}

					return null;
				}
			});
			model.image_(image);
			model.redisplay();
		}

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunDelaunay2dDiagramTestExamples();
	}
}
