package jp.co.sra.jun.voronoi.twoD.diagram;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;

import javax.swing.JFrame;
import javax.swing.JPanel;

import jp.co.sra.smalltalk.StApplicationModel;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StRectangle;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.goodies.image.framework.JunImageDisplayModel;
import jp.co.sra.jun.goodies.movie.support.JunImagesToMovie;
import jp.co.sra.jun.goodies.utilities.JunImageUtility;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunVoronoi2dDiagramTestExamples class
 * 
 *  @author    NISHIHARA Satoshi
 *  @created   2000/02/07 (by NISHIHARA Satoshi)
 *  @updated   2006/11/06 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun661 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVoronoi2dDiagramTestExamples.java,v 8.12 2008/02/20 06:33:14 nisinaka Exp $
 */
public class JunVoronoi2dDiagramTestExamples extends JunTestExamples {
	/**
	 * Example1:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunVoronoi2dDiagram diagram = new JunVoronoi2dDiagram(200, 200);
		for (int i = 0; i < 50; i++) {
			Jun2dPoint aPoint = new Jun2dPoint(Math.random() * diagram.width(), Math.random() * diagram.height());
			diagram.add_(aPoint);
		}

		System.out.println("area: " + diagram.area());
		diagram.show();

		return true;
	}

	/**
	 * Example2:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunVoronoi2dDiagram diagram = new JunVoronoi2dDiagram(200, 200);
		for (int i = 0; i < 50; i++) {
			Jun2dPoint aPoint = new Jun2dPoint(Math.random() * diagram.width(), Math.random() * diagram.height());
			diagram.add_(aPoint);
		}

		diagram.show();
		diagram.asDelaunayDiagram().show();
		System.out.println("area: " + diagram.area());

		return true;
	}

	/**
	 * Example3:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		final JunVoronoi2dDiagram diagram = new JunVoronoi2dDiagram(200, 200);

		final JPanel canvas = new JPanel() {
			public void paint(Graphics aGraphics) {
				diagram.displayOn_(aGraphics);
			}
		};
		canvas.setPreferredSize(new Dimension(200, 200));

		JFrame aFrame = new JFrame();
		aFrame.setTitle(diagram.labelString());
		aFrame.getContentPane().setLayout(new BorderLayout());
		aFrame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				e.getWindow().dispose();
			}
		});
		aFrame.getContentPane().add(canvas);
		aFrame.pack();
		StApplicationModel._ShowAtMousePoint(aFrame);

		Thread aThread = new Thread() {
			public void run() {
				while (canvas.isShowing()) {
					diagram.add_(new Jun2dPoint(Math.random() * diagram.width(), Math.random() * diagram.height()));
					canvas.paintImmediately(canvas.getBounds());
					Thread.yield();
				}
			}
		};
		aThread.setPriority(Thread.NORM_PRIORITY - 1);
		aThread.start();

		return true;
	}

	/**
	 * Example4: Low precision
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		JunVoronoi2dDiagram diagram = new JunVoronoi2dDiagram(200, 200);

		Jun2dPoint[] points = new Jun2dPoint[9];
		points[0] = new Jun2dPoint(0.1d, 0.1d);
		points[1] = new Jun2dPoint(0.1d, 0.9d);
		points[2] = new Jun2dPoint(0.9d, 0.1d);
		points[3] = new Jun2dPoint(0.9d, 0.9d);
		points[4] = new Jun2dPoint(0.5d, 0.5d);
		points[5] = new Jun2dPoint(0.1d, 0.5d);
		points[6] = new Jun2dPoint(0.9d, 0.5d);
		points[7] = new Jun2dPoint(0.5d, 0.1d);
		points[8] = new Jun2dPoint(0.5d, 0.9d);

		for (int i = 0; i < points.length; i++) {
			double x = points[i].x() * diagram.width();
			double y = points[i].y() * diagram.height();
			diagram.add_(new Jun2dPoint(x, y));
		}

		System.out.println("area: " + diagram.area());
		diagram.show();

		return true;
	}

	/**
	 * Example5: Low precision
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example5() {
		JunVoronoi2dDiagram diagram = new JunVoronoi2dDiagram(200, 200);

		int count = 0;
		for (int y = 0; y <= 10; y++) {
			for (int x = 0; x <= 10; x++) {
				if (count % 2 == 0) {
					double px = x / 10.0 * diagram.width();
					double py = y / 10.0 * diagram.height();
					diagram.add_(new Jun2dPoint(px, py));
				}
				count++;
			}
		}

		System.out.println("area: " + diagram.area());
		diagram.show();

		return true;
	}

	/**
	 * Example6: Low precision
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example6() {
		JunVoronoi2dDiagram diagram = new JunVoronoi2dDiagram(200, 200);

		ArrayList aList = new ArrayList();
		aList.add(new Jun2dPoint(0, 0));
		int step = 10;
		for (int degrees = 0; degrees <= 360; degrees += step) {
			JunAngle angle = JunAngle.FromDeg_(degrees);
			aList.add(new Jun2dPoint(angle.cos(), angle.sin()));
			angle = JunAngle.FromDeg_(degrees + step / 2);
			aList.add(new Jun2dPoint(angle.cos() * 0.5, angle.sin() * 0.5));
		}
		Jun2dPoint[] points = (Jun2dPoint[]) aList.toArray(new Jun2dPoint[aList.size()]);
		for (int i = 0; i < points.length; i++) {
			double x = (points[i].x() + 1) * diagram.width() / 2;
			double y = (points[i].y() + 1) * diagram.height() / 2;
			diagram.add_(new Jun2dPoint(x, y));
		}

		System.out.println("area: " + diagram.area());
		diagram.show();

		return true;
	}

	/**
	 * Example7:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example7() {
		ArrayList models = new ArrayList();
		Dimension extent = new Dimension(300, 300);
		final JunVoronoi2dDiagram voronoi = new JunVoronoi2dDiagram(extent);
		JunImageDisplayModel model = JunImageDisplayModel.Show_label_at_(new StImage(extent), "Voronoi (" + extent.width + "x" + extent.height + ")", new Point(100, 200));
		models.add(model);
		model.closeTogether_(models);
		final JunDelaunay2dDiagram delaunay = new JunDelaunay2dDiagram(extent);
		model = JunImageDisplayModel.Show_label_at_(new StImage(extent), "Delaunay (" + extent.width + "x" + extent.height + ")", new Point(100 + extent.width + 50, 200));
		models.add(model);
		model.closeTogether_(models);

		ArrayList aList = new ArrayList();
		StRectangle box = new StRectangle(voronoi.extent());
		for (int y = box.originY(); y <= box.cornerY(); y += 10) {
			for (int x = box.originX(); x <= box.cornerX(); x += 10) {
				Jun2dPoint p = new Jun2dPoint(x + Math.random() * 5 - 2.5, y + Math.random() * 5 - 2.5);
				double d = p.distance_(new Jun2dPoint(extent.width / 2, extent.height / 2));
				if (d < extent.width / 2 - 10 && d < extent.height / 2 - 10) {
					aList.add(p);
				}
			}
		}
		Collections.shuffle(aList);
		Jun2dPoint[] points = (Jun2dPoint[]) aList.toArray(new Jun2dPoint[aList.size()]);
		for (int count = 0; count < points.length; count++) {
			voronoi.add_(points[count]);
			delaunay.add_(points[count]);
			if (count % 10 == 0) {
				BufferedImage image = JunImageUtility.ImageExtent_displayBlock_(voronoi.extent(), new StBlockClosure() {
					public Object value_(Object graphics) {
						voronoi.displayOn_((Graphics) graphics);
						return null;
					}
				});
				((JunImageDisplayModel) models.get(0)).image_(image);
				((JunImageDisplayModel) models.get(0)).redisplay();

				image = JunImageUtility.ImageExtent_displayBlock_(delaunay.extent(), new StBlockClosure() {
					public Object value_(Object graphics) {
						delaunay.displayOn_((Graphics) graphics);
						return null;
					}
				});
				((JunImageDisplayModel) models.get(1)).image_(image);
				((JunImageDisplayModel) models.get(1)).redisplay();
			}
		}

		BufferedImage image = JunImageUtility.ImageExtent_displayBlock_(voronoi.extent(), new StBlockClosure() {
			public Object value_(Object graphics) {
				voronoi.displayOn_((Graphics) graphics);
				return null;
			}
		});
		((JunImageDisplayModel) models.get(0)).image_(image);
		((JunImageDisplayModel) models.get(0)).redisplay();

		image = JunImageUtility.ImageExtent_displayBlock_(delaunay.extent(), new StBlockClosure() {
			public Object value_(Object graphics) {
				delaunay.displayOn_((Graphics) graphics);
				return null;
			}
		});
		((JunImageDisplayModel) models.get(1)).image_(image);
		((JunImageDisplayModel) models.get(1)).redisplay();

		return true;
	}

	/**
	 * Example8:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example8() {
		final Dimension extent = new Dimension(300, 300);
		final JunVoronoi2dDiagram voronoi = new JunVoronoi2dDiagram(extent);
		final JunDelaunay2dDiagram delaunay = new JunDelaunay2dDiagram(extent);
		final Dimension imageExtent = new Dimension(extent.width * 2 + 15, extent.height + 10);
		final JunImageDisplayModel model = JunImageDisplayModel.Show_label_at_(new StImage(imageExtent), "Voronoi and Delaunay", new Point(100, 200));

		ArrayList aList = new ArrayList();
		StRectangle box = new StRectangle(voronoi.extent());
		for (int y = box.originY(); y <= box.cornerY(); y += 10) {
			for (int x = box.originX(); x <= box.cornerX(); x += 10) {
				Jun2dPoint p = new Jun2dPoint(x + Math.random() * 5 - 2.5, y + Math.random() * 5 - 2.5);
				double d = p.distance_(new Jun2dPoint(extent.width / 2, extent.height / 2));
				if (d < extent.width / 2 - 10 && d < extent.height / 2 - 10) {
					aList.add(p);
				}
			}
		}
		Collections.shuffle(aList);
		final Jun2dPoint[] points = (Jun2dPoint[]) aList.toArray(new Jun2dPoint[aList.size()]);

		final int tick = 50;
		File aFile = new File("VoronoiAndDelaunay.mov");
		JunImagesToMovie.File_extent_do_(aFile, imageExtent, new StBlockClosure() {
			public Object value_(Object anObject) {
				JunImagesToMovie imagesToMovie = (JunImagesToMovie) anObject;

				for (int count = 0; count < points.length; count++) {
					voronoi.add_(points[count]);
					delaunay.add_(points[count]);
					if (count % 10 == 0) {
						BufferedImage image = JunImageUtility.ImageExtent_displayBlock_(imageExtent, new StBlockClosure() {
							public Object value_(Object graphics) {
								voronoi.displayOn_at_((Graphics) graphics, new Point(5, 5));
								delaunay.displayOn_at_((Graphics) graphics, new Point(extent.width + 10, 5));
								return null;
							}
						});
						model.image_(image);
						model.redisplay();
						imagesToMovie.add_milliseconds_(new StImage(image), tick);
					}
				}
				BufferedImage image = JunImageUtility.ImageExtent_displayBlock_(imageExtent, new StBlockClosure() {
					public Object value_(Object graphics) {
						voronoi.displayOn_at_((Graphics) graphics, new Point(5, 5));
						delaunay.displayOn_at_((Graphics) graphics, new Point(extent.width + 10, 5));
						return null;
					}
				});
				model.image_(image);
				model.redisplay();
				imagesToMovie.add_milliseconds_(new StImage(image), tick);

				return null;
			}
		});

		return true;
	}

	/**
	 * Example9:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example9() {
		JunVoronoi2dDiagram diagram = new JunVoronoi2dDiagram(200, 200);
		diagram.add_(new Jun2dPoint(50, 100));
		diagram.add_(new Jun2dPoint(150, 100));
		System.out.println("area: " + diagram.area());
		diagram.show();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunVoronoi2dDiagramTestExamples();
	}
}
