package jp.co.sra.jun.vrml.field.mf;

import java.awt.Color;
import java.util.Vector;

/**
 * JunVrmlMFColorField class
 * 
 *  @author    ASTI Beijing
 *  @created   UNKNOWN
 *  @updated   2000/03/27 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlMFColorField.java,v 8.11 2008/02/20 06:33:14 nisinaka Exp $
 */
public class JunVrmlMFColorField extends jp.co.sra.jun.vrml.field.abstracts.JunVrmlMFField {
	protected float[] value;

	/**
	 * Create a new instance of JunVrmlMFColorField and initialize it.
	 * 
	 * @param numbers float[]
	 */
	public JunVrmlMFColorField(float[] numbers) {
		super();
		this.value_(numbers);
	}

	/**
	 * Create a JunVrmlMFColorField and initialize it.
	 * 
	 * @param anObject java.lang.Object
	 */
	public JunVrmlMFColorField(Object anObject) {
		this((Vector) anObject);
	}

	/**
	 * Create a JunVrmlMFColorField and initialize it.
	 * 
	 * @param aVector java.util.Vector
	 */
	public JunVrmlMFColorField(Vector aVector) {
		super();
		this.value_(aVector);
	}

	/**
	 * Convert to an array of Color.
	 * 
	 * @return java.awt.Color[]
	 */
	public Color[] asColors() {
		Color[] colorArray = new Color[value.length / 3];

		for (int i = 0; i < value.length; i += 3) {
			colorArray[i / 3] = new Color(value[i], value[i + 1], value[i + 2]);
		}

		return colorArray;
	}

	/**
	 * Answer my value.
	 * 
	 * @return float[]
	 */
	public float[] value() {
		return value;
	}

	/**
	 * Set my value.
	 * 
	 * @param numbers float[]
	 */
	public void value_(float[] numbers) {
		value = numbers;
	}

	/**
	 * Set my value.
	 * 
	 * @param aVector java.util.Vector
	 */
	public void value_(Vector aVector) {
		Number[] numbers = new Number[aVector.size()];
		aVector.copyInto(numbers);
		value = new float[numbers.length];

		for (int i = 0; i < numbers.length; i++) {
			value[i] = numbers[i].floatValue();
		}
	}
}
