package jp.co.sra.jun.vrml.field.mf;

import java.util.Vector;

/**
 * JunVrmlMFLongField class
 * 
 *  @author    ASTI Beijing
 *  @created   UNKNOWN
 *  @updated   2000/03/27 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlMFLongField.java,v 8.11 2008/02/20 06:33:14 nisinaka Exp $
 */
public class JunVrmlMFLongField extends jp.co.sra.jun.vrml.field.abstracts.JunVrmlMFField {
	protected long[] value;

	/**
	 * Create a new instance of JunVrmlMFLongField and initialize it.
	 * 
	 * @param numbers long[]
	 */
	public JunVrmlMFLongField(long[] numbers) {
		super();
		this.value_(numbers);
	}

	/**
	 * Create a JunVrmlMFLongField and initialize it.
	 * 
	 * @param anObject java.lang.Object
	 */
	public JunVrmlMFLongField(Object anObject) {
		this((Vector) anObject);
	}

	/**
	 * Create a JunVrmlMFLongField and initialize it.
	 * 
	 * @param aVector java.util.Vector
	 */
	public JunVrmlMFLongField(Vector aVector) {
		super();
		this.value_(aVector);
	}

	/**
	 * Convert the value to a point array.
	 * 
	 * @return long[][]
	 */
	public long[][] asPointArray() {
		Vector collection = new Vector();
		int lastIndex = 0;

		for (int i = 0; i < value.length; i++) {
			if (value[i] < 0) {
				int size = i - lastIndex;
				long[] array = new long[size];

				for (int j = 0; j < size; j++) {
					array[j] = value[lastIndex + j];
				}

				collection.addElement(array);
				lastIndex = i + 1;
			}
		}

		if (lastIndex < value.length) {
			int size = value.length - lastIndex;
			long[] array = new long[size];

			for (int j = 0; j < size; j++) {
				array[j] = value[lastIndex + j];
			}

			collection.addElement(array);
		}

		//
		int size = collection.size();
		long[][] pointArray = new long[size][];
		collection.copyInto(pointArray);

		return pointArray;
	}

	/**
	 * Answer my value.
	 * 
	 * @return long[]
	 */
	public long[] value() {
		return value;
	}

	/**
	 * Set my value.
	 * 
	 * @param numbers long[]
	 */
	public void value_(long[] numbers) {
		value = numbers;
	}

	/**
	 * Set my value.
	 * 
	 * @param aVector java.util.Vector
	 */
	public void value_(Vector aVector) {
		Number[] numbers = new Number[aVector.size()];
		aVector.copyInto(numbers);
		value = new long[numbers.length];

		for (int i = 0; i < numbers.length; i++) {
			value[i] = numbers[i].longValue();
		}
	}
}
