package jp.co.sra.jun.vrml.node.geometry20;

import java.util.Hashtable;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.vrml.field.sf.JunVrmlSFVec3fField;
import jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor;

/**
 * JunVrmlBoxNode class
 * 
 *  @author    ASTI Beijing
 *  @created   UNKNOWN
 *  @updated   2000/03/28 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlBoxNode.java,v 8.10 2008/02/20 06:33:16 nisinaka Exp $
 */
public class JunVrmlBoxNode extends jp.co.sra.jun.vrml.node.abstracts.JunVrmlAbstractGeometryNode {
	protected JunVrmlSFVec3fField sizeField;

	/**
	 * Create a new instance of JunVrmlBoxNode and initialize it.
	 * 
	 * @param aDictionary java.util.Hashtable
	 */
	public JunVrmlBoxNode(Hashtable aDictionary) {
		if (aDictionary.containsKey($("size"))) {
			sizeField = new JunVrmlSFVec3fField(aDictionary.get($("size")));
		}
	}

	/**
	 * Answer the default value of size.
	 * 
	 * @return float[]
	 */
	public static final float[] DefaultSize() {
		return new float[] { 2, 2, 2 };
	}

	/**
	 * Convert to a JunOpenGL3dObject.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 */
	public JunOpenGL3dObject asJunOpenGL3dObject() {
		Jun3dPoint aPoint = this.sizeAs3dPoint();
		JunOpenGL3dObject aBox = JunOpenGL3dObject.Box_(aPoint);
		aBox = aBox.translatedBy_(aPoint.dividedBy_(-2.0));

		return aBox;
	}

	/**
	 * Process myself with the generator.
	 * 
	 * @param aVisitor jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor
	 */
	public void nodeDo_(JunVrmlNodeVisitor aVisitor) {
		try {
			aVisitor.perform_with_("doBox_", this);
		} catch (Exception e) {
			super.nodeDo_(aVisitor);
		}
	}

	/**
	 * Answer the size.
	 * 
	 * @return float[]
	 */
	public float[] size() {
		return this.sizeField().value();
	}

	/**
	 * Answer the size as a Jun3dPoint.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 */
	public Jun3dPoint sizeAs3dPoint() {
		return this.sizeField().as3dPoint();
	}

	/**
	 * Answer the size field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFVec3fField
	 */
	protected JunVrmlSFVec3fField sizeField() {
		if (sizeField == null) {
			sizeField = new JunVrmlSFVec3fField(DefaultSize());
		}

		return sizeField;
	}
}
