package jp.co.sra.jun.vrml.node.geometry20;

import java.util.Hashtable;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCylinder;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.vrml.field.sf.*;

/**
 * JunVrmlCylinderNode class
 * 
 *  @author    nisinaka
 *  @created   2000/04/17 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlCylinderNode.java,v 8.10 2008/02/20 06:33:16 nisinaka Exp $
 */
public class JunVrmlCylinderNode extends jp.co.sra.jun.vrml.node.abstracts.JunVrmlAbstractGeometryNode {

	protected JunVrmlSFBoolField bottomField;
	protected JunVrmlSFFloatField heightField;
	protected JunVrmlSFFloatField radiusField;
	protected JunVrmlSFBoolField sideField;
	protected JunVrmlSFBoolField topField;

	/**
	 * Create a new instance of JunVrmlCylinderNode and initialize it.
	 * 
	 * @param aDictionary java.util.Hashtable
	 * @category Instance creation
	 */
	public JunVrmlCylinderNode(Hashtable aDictionary) {
		if (aDictionary.containsKey($("bottom"))) {
			bottomField = new JunVrmlSFBoolField(aDictionary.get($("bottom")));
		}

		if (aDictionary.containsKey($("height"))) {
			heightField = new JunVrmlSFFloatField(aDictionary.get($("height")));
		}

		if (aDictionary.containsKey($("radius"))) {
			radiusField = new JunVrmlSFFloatField(aDictionary.get($("radius")));
		}

		if (aDictionary.containsKey($("side"))) {
			sideField = new JunVrmlSFBoolField(aDictionary.get($("side")));
		}

		if (aDictionary.containsKey($("top"))) {
			topField = new JunVrmlSFBoolField(aDictionary.get($("top")));
		}
	}

	/**
	 * Answer the default value of bottom.
	 * 
	 * @return boolean
	 * @category Defaults
	 */
	public static final boolean DefaultBottom() {
		return true;
	}

	/**
	 * Answer the default value of height.
	 * 
	 * @return float
	 * @category Defaults
	 */
	public static final float DefaultHeight() {
		return 2;
	}

	/**
	 * Answer the default value of radius.
	 * 
	 * @return float
	 * @category Defaults
	 */
	public static final float DefaultRadius() {
		return 1;
	}

	/**
	 * Answer the default value of side.
	 * 
	 * @return boolean
	 * @category Defaults
	 */
	public static final boolean DefaultSide() {
		return true;
	}

	/**
	 * Answer the default value of top.
	 * 
	 * @return boolean
	 * @category Defaults
	 */
	public static final boolean DefaultTop() {
		return true;
	}

	/**
	 * Answer the bottom.
	 * 
	 * @return boolean
	 * @category accessing
	 */
	public boolean bottom() {
		return this.bottomField().value();
	}

	/**
	 * Answer the height.
	 * 
	 * @return float
	 * @category accessing
	 */
	public float height() {
		return this.heightField().value();
	}

	/**
	 * Answer the radius.
	 * 
	 * @return float
	 * @category accessing
	 */
	public float radius() {
		return this.radiusField().value();
	}

	/**
	 * Answer the side.
	 * 
	 * @return boolean
	 * @category accessing
	 */
	public boolean side() {
		return this.sideField().value();
	}

	/**
	 * Answer the top.
	 * 
	 * @return boolean
	 * @category accessing
	 */
	public boolean top() {
		return this.topField().value();
	}

	/**
	 * Answer the bottom field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFBoolField
	 * @category accessing
	 */
	protected JunVrmlSFBoolField bottomField() {
		if (bottomField == null) {
			bottomField = new JunVrmlSFBoolField(DefaultBottom());
		}

		return bottomField;
	}

	/**
	 * Answer the height.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFFloatField
	 * @category accessing
	 */
	protected JunVrmlSFFloatField heightField() {
		if (heightField == null) {
			heightField = new JunVrmlSFFloatField(DefaultHeight());
		}

		return heightField;
	}

	/**
	 * Answer the radius.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFFloatField
	 * @category accessing
	 */
	protected JunVrmlSFFloatField radiusField() {
		if (radiusField == null) {
			radiusField = new JunVrmlSFFloatField(DefaultRadius());
		}

		return radiusField;
	}

	/**
	 * Answer the side field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFBoolField
	 * @category accessing
	 */
	protected JunVrmlSFBoolField sideField() {
		if (sideField == null) {
			sideField = new JunVrmlSFBoolField(DefaultSide());
		}

		return sideField;
	}

	/**
	 * Answer the top field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFBoolField
	 * @category accessing
	 */
	protected JunVrmlSFBoolField topField() {
		if (topField == null) {
			topField = new JunVrmlSFBoolField(DefaultTop());
		}

		return topField;
	}

	/**
	 * Convert to a JunOpenGL3dObject.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category code generation
	 */
	public JunOpenGL3dObject asJunOpenGL3dObject() {
		return new JunOpenGL3dCylinder(this.radius(), this.height());
	}

}
