package jp.co.sra.jun.vrml.node.grouping20;

import java.util.*;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.vrml.field.sf.*;
import jp.co.sra.jun.vrml.node.abstracts.JunVrmlNode;
import jp.co.sra.jun.vrml.support.*;

/**
 * JunVrmlTransformNode class
 * 
 *  @author    ASTI Beijing
 *  @created   UNKNOWN
 *  @updated   2000/04/17 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlTransformNode.java,v 8.10 2008/02/20 06:33:16 nisinaka Exp $
 */
public class JunVrmlTransformNode extends jp.co.sra.jun.vrml.node.abstracts.JunVrmlAbstractGroupingNode {

	protected JunVrmlSFVec3fField centerField;
	protected JunVrmlNode[] children;
	protected JunVrmlSFRotationField rotationField;
	protected JunVrmlSFVec3fField scaleField;
	protected JunVrmlSFRotationField scaleOrientationField;
	protected JunVrmlSFVec3fField translationField;
	protected JunVrmlSFVec3fField bboxCenterField;
	protected JunVrmlSFVec3fField bboxSizeField;

	/**
	 * The default constructor.
	 * 
	 * @category Instance creation
	 */
	public JunVrmlTransformNode() {
	}

	/**
	 * Create a new instance of JunVrmlTransformNode and initialize it.
	 * 
	 * @param aDictionary java.util.Hashtable
	 * @category Instance creation
	 */
	public JunVrmlTransformNode(Hashtable aDictionary) {
		if (aDictionary.containsKey($("center"))) {
			centerField = new JunVrmlSFVec3fField(aDictionary.get($("center")));
		}

		if (aDictionary.containsKey($("children"))) {
			this.children_(aDictionary.get($("children")));
		}

		if (aDictionary.containsKey($("rotation"))) {
			rotationField = new JunVrmlSFRotationField(aDictionary.get($("rotation")));
		}

		if (aDictionary.containsKey($("scale"))) {
			scaleField = new JunVrmlSFVec3fField(aDictionary.get($("scale")));
		}

		if (aDictionary.containsKey($("scaleOrientation"))) {
			scaleOrientationField = new JunVrmlSFRotationField(aDictionary.get($("scaleOrientation")));
		}

		if (aDictionary.containsKey($("translation"))) {
			translationField = new JunVrmlSFVec3fField(aDictionary.get($("translation")));
		}

		if (aDictionary.containsKey($("bboxCenter"))) {
			bboxCenterField = new JunVrmlSFVec3fField(aDictionary.get($("bboxCenter")));
		}

		if (aDictionary.containsKey($("bboxSize"))) {
			bboxSizeField = new JunVrmlSFVec3fField(aDictionary.get($("bboxSize")));
		}
	}

	/**
	 * Answer the default value of bboxCenter.
	 * 
	 * @return java.lang.Integer[]
	 * @category Defaults
	 */
	public static final float[] DefaultBboxCenter() {
		return new float[] { 0, 0, 0 };
	}

	/**
	 * Answer the default value of bboxSize.
	 * 
	 * @return java.lang.Integer[]
	 * @category Defaults
	 */
	public static final float[] DefaultBboxSize() {
		return new float[] { -1, -1, -1 };
	}

	/**
	 * Answer the default value of center.
	 * 
	 * @return java.lang.Integer[]
	 * @category Defaults
	 */
	public static final float[] DefaultCenter() {
		return new float[] { 0, 0, 0 };
	}

	/**
	 * Answer the default value of rotation.
	 * 
	 * @return java.lang.Integer[]
	 * @category Defaults
	 */
	public static final float[] DefaultRotation() {
		return new float[] { 0, 0, 1, 0 };
	}

	/**
	 * Answer the default value of scale.
	 * 
	 * @return java.lang.Integer[]
	 * @category Defaults
	 */
	public static final float[] DefaultScale() {
		return new float[] { 1, 1, 1 };
	}

	/**
	 * Answer the default value of scaleOrientation.
	 * 
	 * @return java.lang.Integer[]
	 * @category Defaults
	 */
	public static final float[] DefaultScaleOrientation() {
		return new float[] { 0, 0, 1, 0 };
	}

	/**
	 * Answer the default value of translation.
	 * 
	 * @return java.lang.Integer[]
	 * @category Defaults
	 */
	public static final float[] DefaultTranslation() {
		return new float[] { 0, 0, 0 };
	}

	/**
	 * Answer the bboxCenter.
	 * 
	 * @return float[]
	 * @category accessing
	 */
	public float[] bboxCenter() {
		return this.bboxCenterField().value();
	}

	/**
	 * Answer the bboxSize.
	 * 
	 * @return float[]
	 * @category accessing
	 */
	public float[] bboxSize() {
		return this.bboxSizeField().value();
	}

	/**
	 * Answer the center.
	 * 
	 * @return float[]
	 * @category accessing
	 */
	public float[] center() {
		return this.centerField().value();
	}

	/**
	 * Answer the children.
	 * 
	 * @return jp.co.sra.jun.vrml.node.abstracts.JunVrmlNode[]
	 * @category accessing
	 */
	public JunVrmlNode[] children() {
		return children;
	}

	/**
	 * Set the children nodes.
	 * 
	 * @param aNode java.lang.Object
	 * @throws jp.co.sra.smalltalk.SmalltalkException if the parameter is invalid.
	 * @category accessing
	 */
	public void children_(Object aNode) {
		if (aNode instanceof JunVrmlNode) {
			children = new JunVrmlNode[] {(JunVrmlNode) aNode };
		} else if (aNode instanceof Vector) {
			Vector collection = (Vector) aNode;
			children = new JunVrmlNode[collection.size()];
			collection.copyInto(children);
		} else {
			throw new jp.co.sra.smalltalk.SmalltalkException();
		}
	}

	/**
	 * Answer the rotation.
	 * 
	 * @return float[]
	 * @category accessing
	 */
	public float[] rotation() {
		return this.rotationField().value();
	}

	/**
	 * Answer the scale.
	 * 
	 * @return float[]
	 * @category accessing
	 */
	public float[] scale() {
		return this.scaleField().value();
	}

	/**
	 * Answer the scaleOrientation.
	 * 
	 * @return float[]
	 * @category accessing
	 */
	public float[] scaleOrientation() {
		return this.scaleOrientationField().value();
	}

	/**
	 * Answer the translation.
	 * 
	 * @return float[]
	 * @category accessing
	 */
	public float[] translation() {
		return this.translationField().value();
	}

	/**
	 * Answer the bboxCenter field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFVec3fField
	 * @category accessing
	 */
	protected JunVrmlSFVec3fField bboxCenterField() {
		if (bboxCenterField == null) {
			bboxCenterField = new JunVrmlSFVec3fField(DefaultBboxCenter());
		}
		return bboxCenterField;
	}

	/**
	 * Answer the bboxSize field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFVec3fField
	 * @category accessing
	 */
	protected JunVrmlSFVec3fField bboxSizeField() {
		if (bboxSizeField == null) {
			bboxSizeField = new JunVrmlSFVec3fField(DefaultBboxSize());
		}
		return bboxSizeField;
	}

	/**
	 * Answer the center field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFVec3fField
	 * @category accessing
	 */
	protected JunVrmlSFVec3fField centerField() {
		if (centerField == null) {
			centerField = new JunVrmlSFVec3fField(DefaultCenter());
		}
		return centerField;
	}

	/**
	 * Answer the rotation field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFRotationField
	 * @category accessing
	 */
	protected JunVrmlSFRotationField rotationField() {
		if (rotationField == null) {
			rotationField = new JunVrmlSFRotationField(DefaultRotation());
		}
		return rotationField;
	}

	/**
	 * Answer the scale field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFVec3fField
	 * @category accessing
	 */
	protected JunVrmlSFVec3fField scaleField() {
		if (scaleField == null) {
			scaleField = new JunVrmlSFVec3fField(DefaultScale());
		}
		return scaleField;
	}

	/**
	 * Answer the scaleOrientation field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFRotationField
	 * @category accessing
	 */
	protected JunVrmlSFRotationField scaleOrientationField() {
		if (scaleOrientationField == null) {
			scaleOrientationField = new JunVrmlSFRotationField(DefaultScaleOrientation());
		}
		return scaleOrientationField;
	}

	/**
	 * Answer the translation field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFVec3fField
	 * @category accessing
	 */
	protected JunVrmlSFVec3fField translationField() {
		if (translationField == null) {
			translationField = new JunVrmlSFVec3fField(DefaultTranslation());
		}
		return translationField;
	}

	/**
	 * Convert to the Jun3dTransformation.
	 * 
	 * @return jp.co.sra.jun.geometry.transformations.Jun3dTransformation
	 * @category code generation
	 */
	public Jun3dTransformation transformation() {
		Jun3dTransformation t = Jun3dTransformation.Translate_(this.centerField().as3dPoint().multipliedBy_(-1));
		t = t.product_(this.scaleOrientationField().asReverse3dTransformation());
		t = t.product_(Jun3dTransformation.Scale_(this.scaleField().as3dPoint()));
		t = t.product_(this.scaleOrientationField().as3dTransformation());
		t = t.product_(this.rotationField().as3dTransformation());
		t = t.product_(Jun3dTransformation.Translate_(this.centerField().as3dPoint()));
		t = t.product_(Jun3dTransformation.Translate_(this.translationField().as3dPoint()));
		return t;
	}

	/**
	 * Process myself with the generator.
	 * 
	 * @param aVisitor jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor
	 * @category enumerating
	 */
	public void nodeDo_(JunVrmlNodeVisitor aVisitor) {
		try {
			aVisitor.perform_with_("doTransform_", this);
		} catch (Exception e) {
			super.nodeDo_(aVisitor);
		}
	}

}
