package jp.co.sra.jun.vrml.node.property20;

import java.util.Hashtable;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.vrml.node.abstracts.*;
import jp.co.sra.jun.vrml.node.grouping20.JunVrmlTransformNode;
import jp.co.sra.jun.vrml.node.property20.JunVrmlMaterialNode20;
import jp.co.sra.jun.vrml.support.*;

/**
 * JunVrmlAppearanceNode class
 * 
 *  @author    ASTI Beijing
 *  @created   UNKNOWN
 *  @updated   2000/04/14 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlAppearanceNode.java,v 8.10 2008/02/20 06:33:17 nisinaka Exp $
 */
public class JunVrmlAppearanceNode extends JunVrmlAbstractPropertyNode {
	protected JunVrmlMaterialNode20 material;
	protected JunVrmlTransformNode textureTransform;
	protected JunVrmlPixelTextureNode texture;

	/**
	 * Create a new instance of JunVrmlAppearanceNode and initialize it.
	 * 
	 * @param aDictionary java.util.Hashtable
	 */
	public JunVrmlAppearanceNode(Hashtable aDictionary) {
		if (aDictionary.containsKey($("material"))) {
			this.material_((JunVrmlMaterialNode20) aDictionary.get($("material")));
		}

		if (aDictionary.containsKey($("texture"))) {
			this.texture_((JunVrmlPixelTextureNode) aDictionary.get($("texture")));
		}

		if (aDictionary.containsKey($("textureTransform"))) {
			this.textureTransform_((JunVrmlTransformNode) aDictionary.get($("textureTransform")));
		}
	}

	/**
	 * Answer the material node.
	 * 
	 * @return jp.co.sra.jun.vrml.node.property20.JunVrmlMaterialNode20
	 */
	public JunVrmlMaterialNode20 material() {
		return material;
	}

	/**
	 * Set the material node.
	 * 
	 * @param aJunVrmlMaterialNode
	 *        jp.co.sra.jun.vrml.node.property20.JunVrmlMaterialNode20
	 */
	public void material_(JunVrmlMaterialNode20 aJunVrmlMaterialNode) {
		material = aJunVrmlMaterialNode;
	}

	/**
	 * Process myself with the generator.
	 * 
	 * @param aVisitor jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor
	 */
	public void nodeDo_(JunVrmlNodeVisitor aVisitor) {
		try {
			aVisitor.perform_with_("doAppearance_", this);
		} catch (Exception e) {
			super.nodeDo_(aVisitor);
		}
	}

	/**
	 * Set my properties on the JunOpenGL3dObject.
	 * 
	 * @param a3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 */
	public void propertyOn_(JunOpenGL3dObject a3dObject) {
		if (this.material() != null) {
			this.material().propertyOn_(a3dObject);
		}

		if (this.texture() != null) {
			this.texture().propertyOn_(a3dObject);
		}
	}

	/**
	 * Answer the texture.
	 * 
	 * @return jp.co.sra.jun.vrml.node.property20.JunVrmlPixelTextureNode
	 */
	public JunVrmlPixelTextureNode texture() {
		return texture;
	}

	/**
	 * Set the texture.
	 * 
	 * @param aJunVrmlTextureNode
	 *        jp.co.sra.jun.vrml.node.property20.JunVrmlPixelTextureNode
	 */
	public void texture_(JunVrmlPixelTextureNode aJunVrmlTextureNode) {
		texture = aJunVrmlTextureNode;
	}

	/**
	 * Answer the texture transform.
	 * 
	 * @return jp.co.sra.jun.vrml.node.group20.JunVrmlTransformNode
	 */
	public JunVrmlTransformNode textureTransform() {
		return textureTransform;
	}

	/**
	 * Set the texture transform.
	 * 
	 * @param aJunVrmlTextureTransformNode
	 *        jp.co.sra.jun.vrml.node.group20.JunVrmlTransformNode
	 */
	public void textureTransform_(JunVrmlTransformNode aJunVrmlTextureTransformNode) {
		textureTransform = aJunVrmlTextureTransformNode;
	}
}
