package jp.co.sra.jun.vrml.node.property20;

import java.awt.Color;
import java.util.Hashtable;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.vrml.field.mf.JunVrmlMFColorField;
import jp.co.sra.jun.vrml.node.abstracts.JunVrmlAbstractPropertyNode;
import jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor;

/**
 * JunVrmlBackgroundNode class
 * 
 *  @author    nisinaka
 *  @created   2004/11/02 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Nsn156 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlBackgroundNode.java,v 8.10 2008/02/20 06:33:17 nisinaka Exp $
 */
public class JunVrmlBackgroundNode extends JunVrmlAbstractPropertyNode {

	protected JunVrmlMFColorField skyColorField;

	public static float[] DefaultSkyColor = new float[] { 0, 0, 0 };

	public JunVrmlBackgroundNode(Hashtable aDictionary) {
		if (aDictionary.containsKey($("skyColor"))) {
			skyColorField = new JunVrmlMFColorField(aDictionary.get($("skyColor")));
		}
	}

	/**
	 * Answer my skyColor field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.mf.JunVrmlMFColorField
	 * @category field accessing
	 */
	protected JunVrmlMFColorField skyColorField() {
		if (skyColorField == null) {
			skyColorField = new JunVrmlMFColorField(DefaultSkyColor);
		}
		return skyColorField;
	}

	/**
	 * Process myself with the generator. 
	 * 
	 * @param aVisitor jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor
	 * @see jp.co.sra.jun.vrml.node.abstracts.JunVrmlNode#nodeDo_(jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor)
	 * @category enumerating
	 */
	public void nodeDo_(JunVrmlNodeVisitor aVisitor) {
		try {
			aVisitor.perform_with_("doBackground_", this);
		} catch (Exception e) {
			super.nodeDo_(aVisitor);
		}
	}

	/**
	 * Set my properties on the JunOpenGL3dObject.
	 * 
	 * @param a3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @see jp.co.sra.jun.vrml.node.abstracts.JunVrmlAbstractPropertyNode#propertyOn_(jp.co.sra.jun.opengl.objects.JunOpenGL3dObject)
	 * @category code generation
	 */
	public void propertyOn_(JunOpenGL3dObject a3dObject) {
		// The background is a property of JunOpenGL3dModel.
	}

	/**
	 * Answer the sky color as an array of Color.
	 * 
	 * @return java.awt.Color[]
	 * @category code generation
	 */
	public Color[] skyColorAsColors() {
		return this.skyColorField().asColors();
	}

}
