package jp.co.sra.jun.vrml.support;

import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.system.framework.JunAbstractObject;
import jp.co.sra.jun.vrml.node.abstracts.JunVrmlNode;

/**
 * JunVrmlCompiler class
 * 
 *  @author    nisinaka
 *  @created   2000/03/17 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlCompiler.java,v 8.11 2008/02/20 06:33:17 nisinaka Exp $
 */
public class JunVrmlCompiler extends JunAbstractObject {
	protected JunVrmlParser parser;
	protected JunVrmlGenerator generator;

	/**
	 * Create a new instance of <code>JunVrmlCompiler</code> and initialize it.
	 * 
	 * @param aParser jp.co.sra.jun.vrml.support.JunVrmlParser
	 * @param aGenerator jp.co.sra.jun.vrml.support.JunVrmlGenerator
	 * @category Instance creation
	 */
	public JunVrmlCompiler(JunVrmlParser aParser, JunVrmlGenerator aGenerator) {
		super();
		parser = aParser;
		generator = aGenerator;
	}

	/**
	 * Read the VRML source string, parse it, and generate a
	 * JunOpenGLDisplayModel. Creation date: (2000/03/17 17:59:04)
	 * 
	 * @param anObject java.lang.Object
	 * @param aParser jp.co.sra.jun.vrml.support.JunVrmlParser
	 * @param aGenerator jp.co.sra.jun.vrml.support.JunVrmlGenerator
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 */
	public static JunOpenGLDisplayModel Source_parser_generator_(Object anObject, JunVrmlParser aParser, JunVrmlGenerator aGenerator) {
		JunVrmlCompiler compiler = new JunVrmlCompiler(aParser, aGenerator);

		return compiler.parseAndGenerate_(anObject);
	}

	/**
	 * Read the VRML source string, parse it, and generate a
	 * JunOpenGLDisplayModel. Creation date: (2000/03/17 17:59:04)
	 * 
	 * @param anObject java.lang.Object
	 * @param aParser jp.co.sra.jun.vrml.support.JunVrmlParser
	 * @param aGenerator jp.co.sra.jun.vrml.support.JunVrmlGenerator
	 * @param aDisplayModel jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 */
	public static JunOpenGLDisplayModel Source_parser_generator_displayModel_(Object anObject, JunVrmlParser aParser, JunVrmlGenerator aGenerator, JunOpenGLDisplayModel aDisplayModel) {
		JunVrmlCompiler compiler = new JunVrmlCompiler(aParser, aGenerator);

		return compiler.parseAndGenerate_with_(anObject, aDisplayModel);
	}

	/**
	 * Answer the generator. Creation date: (2000/03/17 18:05:00)
	 * 
	 * @return jp.co.sra.jun.vrml.support.JunVrmlGenerator
	 */
	public JunVrmlGenerator generator() {
		return generator;
	}

	/**
	 * Set the generator. Creation date: (2000/03/17 18:05:39)
	 * 
	 * @param aGenerator jp.co.sra.jun.vrml.support.JunVrmlGenerator
	 */
	public void generator_(JunVrmlGenerator aGenerator) {
		generator = aGenerator;
	}

	/**
	 * Parse the source object.
	 * 
	 * @param anObject java.lang.Object
	 * 
	 * @return jp.co.sra.jun.vrml.node.abstracts.JunVrmlNode[]
	 */
	public JunVrmlNode[] parse_(Object anObject) {
		return this.parser().parse_(anObject);
	}

	/**
	 * Parse the source object and generate a JunOpenGLDisplayModel. Creation
	 * date: (2000/03/17 18:17:05)
	 * 
	 * @param anObject java.lang.Object
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 */
	public JunOpenGLDisplayModel parseAndGenerate_(Object anObject) {
		return this.generator().generate_(this.parse_(anObject));
	}

	/**
	 * Parse the source object and generate a JunOpenGLDisplayModel. Creation
	 * date: (2000/03/17 18:19:06)
	 * 
	 * @param anObject java.lang.Object
	 * @param aDisplayModel jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 */
	public JunOpenGLDisplayModel parseAndGenerate_with_(Object anObject, JunOpenGLDisplayModel aDisplayModel) {
		return this.generator().generate_with_(this.parse_(anObject), aDisplayModel);
	}

	/**
	 * Answer the parser. Creation date: (2000/03/17 18:05:00)
	 * 
	 * @return jp.co.sra.jun.vrml.support.JunVrmlParser
	 */
	public JunVrmlParser parser() {
		return parser;
	}

	/**
	 * Set the parser. Creation date: (2000/03/17 18:05:39)
	 * 
	 * @param aParser jp.co.sra.jun.vrml.support.JunVrmlParser
	 */
	public void parser_(JunVrmlParser aParser) {
		parser = aParser;
	}
}
