package jp.co.sra.jun.vrml.support;

import java.io.*;
import java.net.URL;

/**
 * JunVrmlCompilerTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2000/04/17 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlCompilerTestExamples.java,v 8.10 2008/02/20 06:33:17 nisinaka Exp $
 */
public class JunVrmlCompilerTestExamples extends jp.co.sra.jun.system.support.JunTestExamples {

	/**
	 * String representation of VRML1.0 - Benzene.
	 * 
	 * @return java.lang.String
	 */
	protected static String Benzene10() {
		return Read(Object.class.getResource("/jp/co/sra/jun/vrml/support/Benzene10.wrl"));
	}

	/**
	 * String representation of VRML2.0 - Benzene.
	 * 
	 * @return java.lang.String
	 */
	protected static String Benzene20() {
		return Read(Object.class.getResource("/jp/co/sra/jun/vrml/support/Benzene20.wrl"));
	}

	/**
	 * String representation of VRML2.0 - ExampleD2.
	 * 
	 * @return java.lang.String
	 */
	protected static String ExampleD2() {
		return Read(Object.class.getResource("/jp/co/sra/jun/vrml/support/ExampleD2.wrl"));
	}

	/**
	 * String representation of VRML2.0 - ExampleD3.
	 * 
	 * @return java.lang.String
	 */
	protected static String ExampleD3() {
		return Read(Object.class.getResource("/jp/co/sra/jun/vrml/support/ExampleD3.wrl"));
	}

	/**
	 * String representation of VRML2.0 - ExampleD4.
	 * 
	 * @return java.lang.String
	 */
	protected static String ExampleD4() {
		return Read(Object.class.getResource("/jp/co/sra/jun/vrml/support/ExampleD4.wrl"));
	}

	/**
	 * String representation of VRML2.0 - ExampleD5.
	 * 
	 * @return java.lang.String
	 */
	protected static String ExampleD5() {
		return Read(Object.class.getResource("/jp/co/sra/jun/vrml/support/ExampleD5.wrl"));
	}

	/**
	 * String representation of VRML2.0 - ExampleD9.
	 * 
	 * @return java.lang.String
	 */
	protected static String ExampleD9() {
		return Read(Object.class.getResource("/jp/co/sra/jun/vrml/support/ExampleD9.wrl"));
	}

	/**
	 * Read the content of the specified URL.
	 * 
	 * @param aURL java.net.URL
	 * 
	 * @return java.lang.String
	 */
	private static String Read(URL aURL) {
		StringWriter writer = new StringWriter();

		try {
			InputStream input = aURL.openStream();
			int ch;

			while ((ch = input.read()) > 0) {
				writer.write(ch);
			}
		} catch (IOException e) {
		}

		return writer.toString();
	}
}
