package jp.co.sra.qt4jun;

import java.awt.Rectangle;
import java.awt.Dimension;
import java.awt.Image;
import java.io.File;

/**
 * JunQTMovie interface
 * 
 *  @author    Hoshi Takanori
 *  @created   2005/01/19 (by Hoshi Takanori)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunQTMovie.java,v 8.10 2008/02/20 06:33:17 nisinaka Exp $
 */
public interface JunQTMovie {
	/**
	 * release the movie.
	 *
	 * @category initialize-release
	 */
	public void release();

	/**
	 * set the movie to active/deactive.
	 *
	 * @param active boolean
	 * @category accessing
	 */
	public void setActive(boolean active);

	/**
	 * get the movie box.
	 *
	 * @return java.awt.Rectangle
	 * @category accessing
	 */
	public Rectangle getBox();

	/**
	 * set the movie box.
	 *
	 * @param box java.awt.Rectangle
	 * @category accessing
	 */
	public void setBox(Rectangle box);

	/**
	 * get the duration.
	 *
	 * @return int
	 * @category accessing
	 */
	public int getDuration();

	/**
	 * get the next interesting time.
	 *
	 * @param time int
	 * @param rate int
	 * @return int
	 * @category accessing
	 */
	public int getNextInterestingTime(int time, int rate);

	/**
	 * select portions of the movie.
	 *
	 * @param start int
	 * @param duration int
	 * @category accessing
	 */
	public void setSelection(int start, int duration);

	/**
	 * get the time scale.
	 *
	 * @return int
	 * @category accessing
	 */
	public int getTimeScale();

	/**
	 * get the time value.
	 *
	 * @return int
	 * @category accessing
	 */
	public int getTimeValue();

	/**
	 * set the time value.
	 *
	 * @param time int
	 * @category accessing
	 */
	public void setTimeValue(int time);

	/**
	 * get the volume.
	 *
	 * @return double
	 * @category accessing
	 */
	public double getVolume();

	/**
	 * set the volume.
	 *
	 * @param volume double
	 * @category accessing
	 */
	public void setVolume(double volume);

	/**
	 * get the image at the given time value.
	 *
	 * @param time int
	 * @param extent java.awt.Dimension
	 * @return java.awt.Image
	 * @category converting
	 */
	public Image getImageAt(int time, Dimension extent);

	/**
	 * get the sound data from the movie.
	 *
	 * @param start int
	 * @param duration int
	 * @return byte[]
	 * @category converting
	 */
	public byte[] getSoundData(int start, int duration);

	/**
	 * copy the selected portions of the movie.
	 *
	 * @return jp.co.sra.qt4jun.JunQTMovie
	 * @category copying
	 */
	public JunQTMovie copySelection();

	/**
	 * flatten the movie to file.
	 *
	 * @param filename java.io.File
	 * @category writing
	 */
	public void flattenToFile(File filename);

	/**
	 * go to beginning of the movie.
	 *
	 * @category playing
	 */
	public void goToBeginning();

	/**
	 * go to end of the movie.
	 *
	 * @category playing
	 */
	public void goToEnd();

	/**
	 * is the movie done or not?
	 *
	 * @return boolean
	 * @category playing
	 */
	public boolean isDone();

	/**
	 * start the movie.
	 *
	 * @category playing
	 */
	public void start();

	/**
	 * stop the movie.
	 *
	 * @category playing
	 */
	public void stop();

	/**
	 * do movie task.
	 *
	 * @category playing
	 */
	public void task();

	/**
	 * update the movie.
	 *
	 * @category playing
	 */
	public void update();

	/**
	 * set the movie port.
	 *
	 * @param port jp.co.sra.qt4jun.JunQTPort
	 * @category private
	 */
	public void setPort(JunQTPort port);
}
