package jp.co.sra.qt4jun;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;

/**
 * JunQTPort interface
 * 
 *  @author    Hoshi Takanori
 *  @created   2005/01/19 (by Hoshi Takanori)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunQTPort.java,v 8.10 2008/02/20 06:33:17 nisinaka Exp $
 */
public interface JunQTPort {
	/**
	 * create port association 1.
	 *
	 * @category initialize-release
	 */
	public void createPortAssociation1();

	/**
	 * create port association 2.
	 *
	 * @category initialize-release
	 */
	public void createPortAssociation2();

	/**
	 * destroy port association.
	 *
	 * @category initialize-release
	 */
	public void destroyPortAssociation();

	/**
	 * get the movie component.
	 *
	 * @return java.awt.Component
	 * @category accessing
	 */
	public Component getComponent();

	/**
	 * set the movie box.
	 *
	 * @param movie jp.co.sra.qt4jun.JunQTMovie
	 * @param box java.awt.Rectangle
	 * @param offset java.awt.Point
	 * @category accessing
	 */
	public void setMovieBox(JunQTMovie movie, Rectangle box, Point offset);
}
