package jp.co.sra.smalltalk;

import java.util.Hashtable;

/**
 * StSymbol class
 * 
 *  @author    He Weijie
 *  @created   1998/09/16 (by HeWeijie)
 *  @updated   1998/11/04 (by nisinaka)
 *  @updated   1999/06/22 (by nisinaka)
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StSymbol.java,v 8.9 2008/02/20 06:33:18 nisinaka Exp $
 */
public class StSymbol extends StObject {

	protected static Hashtable _symbols = new Hashtable();

	/** The string representation. */
	protected String _string;

	/**
	 * Answer the symbol specified with the String.
	 * 
	 * @param aString
	 * @return jp.co.sra.smalltalk.StSymbol
	 * @category Instance creation
	 */
	public static StSymbol Intern_(String aString) {
		StSymbol aSymbol = (StSymbol) _symbols.get(aString.intern());

		if (aSymbol == null) {
			aSymbol = new StSymbol(aString);
		}

		return aSymbol;
	}

	/**
	 * Create a new instance of StSymbol and initialize it.
	 * The instance of StSymbol should not be created with the default constructor.
	 *
	 * @category Instance creation
	 */
	private StSymbol() {
	}

	/**
	 * Create a new instance of StSymbol and initialize it.
	 *
	 * @param aString java.lang.String
	 * @category Instance creation
	 */
	private StSymbol(String aString) {
		_string = aString.intern();
		_symbols.put(_string, this);
	}

	/**
	 * Answer the size.
	 * 
	 * @return int
	 * @category accessing
	 */
	public int size() {
		return _string.length();
	}

	/**
	 * Returns a string representation of the StString.
	 * 
	 * @return java.lang.String
	 * @category converting
	 */
	public String toString() {
		return _string;
	}

	/**
	 * Answer true if the receiver is equal to the Object, otherwise false.
	 * 
	 * @param anObject java.lang.Object
	 * @return boolean
	 * @category comparing
	 */
	public boolean equals(Object anObject) {
		return (this == anObject);
	}

	/**
	 * Returns a hash code value for the object.
	 * 
	 * @return int
	 * @see java.lang.Object#hashCode()
	 * @category comparing
	 */
	public int hashCode() {
		return _string.hashCode();
	}

}
