package jp.co.sra.smalltalk;

import java.io.*;

/**
 * StValueHolder class
 * 
 *  @author    nisinaka
 *  @created   1998/10/09 (by nisinaka)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StValueHolder.java,v 8.10 2008/02/20 06:33:18 nisinaka Exp $
 */
public class StValueHolder extends StValueModel {
	protected Object value = null;

	/**
	 * Create a new instance of <code>StValueHolder</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public StValueHolder() {
		super();
	}

	/**
	 * Create a new instance of <code>StValueHolder</code> and initialize it with aNumber.
	 * 
	 * @param aNumber double
	 * @category Instance creation
	 */
	public StValueHolder(double aNumber) {
		super();
		this.setValue_(new Double(aNumber));
	}

	/**
	 * Create a new instance of <code>StValueHolder</code> and initialize it with aNumber.
	 * 
	 * @param aNumber float
	 * @category Instance creation
	 */
	public StValueHolder(float aNumber) {
		super();
		this.setValue_(new Float(aNumber));
	}

	/**
	 * Create a new instance of <code>StValueHolder</code> and initialize it with aNumber.
	 * 
	 * @param aNumber int
	 * @category Instance creation
	 */
	public StValueHolder(int aNumber) {
		super();
		this.setValue_(new Integer(aNumber));
	}

	/**
	 * Create a new instance of <code>StValueHolder</code> and initialize it with aNumber.
	 * 
	 * @param aNumber long
	 * @category Instance creation
	 */
	public StValueHolder(long aNumber) {
		super();
		this.setValue_(new Long(aNumber));
	}

	/**
	 * Create a new instance of <code>StValueHolder</code> and initialize it with anObject.
	 * 
	 * @param anObject java.lang.Object
	 * @category Instance creation
	 */
	public StValueHolder(Object anObject) {
		super();
		this.setValue_(anObject);
	}

	/**
	 * Create a new instance of <code>StValueHolder</code> and initialize it with aBoolean.
	 * 
	 * @param aBoolean boolean
	 * @category Instance creation
	 */
	public StValueHolder(boolean aBoolean) {
		super();
		this.setValue_(new Boolean(aBoolean));
	}

	/**
	 * Create a new instance of <code>StValueHolder</code> and initialize it with anObject.
	 * 
	 * @param aClass java.lang.Class
	 * @param anObject java.lang.Object
	 * @return jp.co.sra.smalltalk.StValueHolder
	 * @category Instance creation
	 */
	public static StValueHolder With_(Class aClass, Object anObject) {
		return (StValueHolder) _New(aClass, anObject);
	}

	/**
	 * Create a new instance of <code>StValueHolder</code> and initialize it with anObject.
	 * 
	 * @param anObject java.lang.Object
	 * @return jp.co.sra.smalltalk.StValueHolder
	 * @category Instance creation
	 */
	public static final StValueHolder With_(Object anObject) {
		return With_(StValueHolder.class, anObject);
	}

	/**
	 * Assume 'value' is a Boolean and return it as boolean.
	 * 
	 * @return boolean
	 * @category accessing
	 */
	public boolean _booleanValue() {
		return ((Boolean) value).booleanValue();
	}

	/**
	 * Assume 'value' is a kind of Number and return it as double.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double _doubleValue() {
		return ((Number) value).doubleValue();
	}

	/**
	 * Assume 'value' is a kind of Number and return it as float.
	 * 
	 * @return float
	 * @category accessing
	 */
	public float _floatValue() {
		return ((Number) value).floatValue();
	}

	/**
	 * Assume 'value' is a kind of Number and return it as int.
	 * 
	 * @return int
	 * @category accessing
	 */
	public int _intValue() {
		return ((Number) value).intValue();
	}

	/**
	 * Assume 'value' is a kind of Number and return it as long.
	 * 
	 * @return long
	 * @category accessing
	 */
	public long _longValue() {
		return ((Number) value).longValue();
	}

	/**
	 * Print my string representation on aWriter.
	 * 
	 * @param aWriter java.io.Writer
	 * @throws java.io.IOException
	 * @see jp.co.sra.smalltalk.StObject#printOn_(java.io.Writer)
	 * @category printing
	 */
	public void printOn_(Writer aWriter) throws IOException {
		super.printOn_(aWriter);
		aWriter.write(" on: ");
		if (this.value() == null) {
			aWriter.write("null");
		} else {
			aWriter.write(this.value().toString());
		}
	}

	/**
	 * Set the currently stored value, without notifying dependents.
	 * 
	 * @param newValue java.lang.Object
	 * @see jp.co.sra.smalltalk.StValueModel#setValue_(java.lang.Object)
	 * @category accessing
	 */
	public void setValue_(Object newValue) {
		value = newValue;
	}

	/**
	 * Answer the currently stored value.
	 * 
	 * @return java.lang.Object
	 * @see jp.co.sra.smalltalk.StValueModel#value()
	 * @category accessing
	 */
	public Object value() {
		return value;
	}

	/**
	 * Set the currently stored value, and notify dependents.
	 * 
	 * @param aNumber double
	 * @category accessing
	 */
	public void value_(double aNumber) {
		super.value_(new Double(aNumber));
	}

	/**
	 * Set the currently stored value, and notify dependents.
	 * 
	 * @param aNumber float
	 * @category accessing
	 */
	public void value_(float aNumber) {
		super.value_(new Float(aNumber));
	}

	/**
	 * Set the currently stored value, and notify dependents.
	 * 
	 * @param aNumber int
	 * @category accessing
	 */
	public void value_(int aNumber) {
		super.value_(new Integer(aNumber));
	}

	/**
	 * Set the currently stored value, and notify dependents.
	 * 
	 * @param aNumber long
	 * @category accessing
	 */
	public void value_(long aNumber) {
		super.value_(new Long(aNumber));
	}

	/**
	 * Set the currently stored value, and notify dependents.
	 * 
	 * @param aBoolean boolean
	 * @category accessing
	 */
	public void value_(boolean aBoolean) {
		super.value_(new Boolean(aBoolean));
	}
}
