package jp.co.sra.smalltalk.menu;

import java.awt.Image;

import jp.co.sra.smalltalk.StApplicationModel;
import jp.co.sra.smalltalk.StSymbol;

/**
 * StCheckBoxMenuItem class
 * 
 *  @author    nisinaka
 *  @created   2005/02/17 (by nisinaka)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StCheckBoxMenuItem.java,v 8.9 2008/02/20 06:33:36 nisinaka Exp $
 */
public class StCheckBoxMenuItem extends StMenuItem {

	protected boolean isSelected;

	/**
	 * Create a new instance of StCheckBoxMenuItem and initialize it.
	 *
	 * @param label java.lang.Object
	 * @category Instance creation
	 */
	public StCheckBoxMenuItem(Object label) {
		super(label);
	}

	/**
	 * Create a new instance of StCheckBoxMenuItem and initialize it.
	 *
	 * @param label java.lang.Object
	 * @param menuListener jp.co.sra.smalltalk.menu.MenuListener
	 * @category Instance creation
	 */
	public StCheckBoxMenuItem(Object label, MenuListener menuListener) {
		super(label, menuListener);
	}

	/**
	 * Create a new instance of StCheckBoxMenuItem and initialize it.
	 *
	 * @param label java.lang.Object
	 * @param nameKey jp.co.sra.smalltalk.StSymbol
	 * @category Instance creation
	 */
	public StCheckBoxMenuItem(Object label, StSymbol nameKey) {
		super(label, nameKey);
	}

	/**
	 * Create a new instance of StCheckBoxMenuItem and initialize it.
	 *
	 * @param label java.lang.Object
	 * @param nameKey jp.co.sra.smalltalk.StSymbol
	 * @param labelImage java.awt.Image
	 * @category Instance creation
	 */
	public StCheckBoxMenuItem(Object label, StSymbol nameKey, Image labelImage) {
		super(label, nameKey, labelImage);
	}

	/**
	 * Create a new instance of StCheckBoxMenuItem and initialize it.
	 *
	 * @param label java.lang.Object
	 * @param nameKey jp.co.sra.smalltalk.StSymbol
	 * @param menuListener jp.co.sra.smalltalk.menu.MenuListener
	 * @category Instance creation
	 */
	public StCheckBoxMenuItem(Object label, StSymbol nameKey, MenuListener menuListener) {
		super(label, nameKey, menuListener);
	}

	/**
	 * Create a new instance of StCheckBoxMenuItem and initialize it.
	 *
	 * @param label java.lang.Object
	 * @param isSelected boolean
	 * @category Instance creation
	 */
	public StCheckBoxMenuItem(Object label, boolean isSelected) {
		this(label, null, null, isSelected, null);
	}

	/**
	 * Create a new instance of StCheckBoxMenuItem and initialize it.
	 *
	 * @param label java.lang.Object
	 * @param isSelected boolean
	 * @param menuListener jp.co.sra.smalltalk.menu.MenuListener
	 * @category Instance creation
	 */
	public StCheckBoxMenuItem(Object label, boolean isSelected, MenuListener menuListener) {
		this(label, null, null, isSelected, menuListener);
	}

	/**
	 * Create a new instance of StCheckBoxMenuItem and initialize it.
	 *
	 * @param label java.lang.Object
	 * @param nameKey jp.co.sra.smalltalk.StSymbol
	 * @param isSelected boolean
	 * @category Instance creation
	 */
	public StCheckBoxMenuItem(Object label, StSymbol nameKey, boolean isSelected) {
		this(label, nameKey, null, isSelected, null);
	}

	/**
	 * Create a new instance of StCheckBoxMenuItem and initialize it.
	 *
	 * @param label java.lang.Object
	 * @param nameKey jp.co.sra.smalltalk.StSymbol
	 * @param isSelected boolean
	 * @param menuListener jp.co.sra.smalltalk.menu.MenuListener
	 * @category Instance creation
	 */
	public StCheckBoxMenuItem(Object label, StSymbol nameKey, boolean isSelected, MenuListener menuListener) {
		this(label, nameKey, null, isSelected, menuListener);
	}

	/**
	 * Create a new instance of StCheckBoxMenuItem and initialize it.
	 *
	 * @param label java.lang.Object
	 * @param nameKey jp.co.sra.smalltalk.StSymbol
	 * @param labelImage java.awt.Image
	 * @param isSelected boolean
	 * @param menuListener jp.co.sra.smalltalk.menu.MenuListener
	 * @category Instance creation
	 */
	public StCheckBoxMenuItem(Object label, StSymbol nameKey, Image labelImage, boolean isSelected, MenuListener menuListener) {
		super(label, nameKey, labelImage, menuListener);
		this.beSelected(isSelected);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.menu.StMenuItem#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		isSelected = false;
	}

	/**
	 * Answer true if the receiver is currently selected, otherwise false.
	 * 
	 * @return boolean
	 * @category selection
	 */
	public boolean isSelected() {
		return isSelected;
	}

	/**
	 * Set whether the receiver is to be selected or not.
	 * 
	 * @param aBoolean boolean
	 * @category selection
	 */
	public void beSelected(boolean aBoolean) {
		if (isSelected != aBoolean) {
			isSelected = aBoolean;
			this.changed_($("selection"));
		}
	}

	/**
	 * Make the receiver be selected.
	 * 
	 * @category selection
	 */
	public void beOn() {
		this.beSelected(true);
	}

	/**
	 * Make the receiver be unselected.
	 * 
	 * @category selection
	 */
	public void beOff() {
		this.beSelected(false);
	}

	/**
	 * Create my default view.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StMenuItemView
	 * @category interface opening
	 */
	public StMenuItemView defaultView() {
		if (StApplicationModel.GetDefaultViewMode() == StApplicationModel.VIEW_AWT) {
			return new StCheckBoxMenuItemViewAwt(this);
		} else {
			return new StCheckBoxMenuItemViewSwing(this);
		}
	}

}