package jp.co.sra.smalltalk.menu;

import jp.co.sra.smalltalk.StApplicationModel;
import jp.co.sra.smalltalk.StSymbol;

/**
 * StRadioButtonMenuItem class
 * 
 *  @author    nisinaka
 *  @created   2005/02/17 (by nisinaka)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StRadioButtonMenuItem.java,v 8.11 2008/02/20 06:33:36 nisinaka Exp $
 */
public class StRadioButtonMenuItem extends StCheckBoxMenuItem {

	protected StRadioButtonGroup group;

	/**
	 * Create a new instance of StRadioButtonMenuItem and initialize it.
	 *
	 * @param label java.lang.Object
	 * @category Instance creation
	 */
	public StRadioButtonMenuItem(Object label) {
		this(label, (StSymbol) null, (StRadioButtonGroup) null, (MenuListener) null);
	}

	/**
	 * Create a new instance of StRadioButtonMenuItem and initialize it.
	 *
	 * @param label java.lang.Object
	 * @param nameKey jp.co.sra.smalltalk.StSymbol
	 * @category Instance creation
	 */
	public StRadioButtonMenuItem(Object label, StSymbol nameKey) {
		this(label, nameKey, (StRadioButtonGroup) null, (MenuListener) null);
	}

	/**
	 * Create a new instance of StRadioButtonMenuItem and initialize it.
	 *
	 * @param label java.lang.Object
	 * @param nameKey jp.co.sra.smalltalk.StSymbol
	 * @param menuListener jp.co.sra.smalltalk.menu.MenuListener
	 * @category Instance creation
	 */
	public StRadioButtonMenuItem(Object label, StSymbol nameKey, MenuListener menuListener) {
		this(label, nameKey, (StRadioButtonGroup) null, menuListener);
	}

	/**
	 * Create a new instance of StRadioButtonMenuItem and initialize it.
	 *
	 * @param label java.lang.Object
	 * @param radioButtonGroup jp.co.sra.smalltalk.menu.StRadioButtonGroup
	 * @category Instance creation
	 */
	public StRadioButtonMenuItem(Object label, StRadioButtonGroup radioButtonGroup) {
		this(label, (StSymbol) null, radioButtonGroup, (MenuListener) null);
	}

	/**
	 * Create a new instance of StRadioButtonMenuItem and initialize it.
	 *
	 * @param label java.lang.Object
	 * @param radioButtonGroup jp.co.sra.smalltalk.menu.StRadioButtonGroup
	 * @param menuListener jp.co.sra.smalltalk.menu.MenuListener
	 * @category Instance creation
	 */
	public StRadioButtonMenuItem(Object label, StRadioButtonGroup radioButtonGroup, MenuListener menuListener) {
		this(label, (StSymbol) null, radioButtonGroup, menuListener);
	}

	/**
	 * Create a new instance of StRadioButtonMenuItem and initialize it.
	 *
	 * @param label java.lang.Object
	 * @param nameKey jp.co.sra.smalltalk.StSymbol
	 * @param radioButtonGroup jp.co.sra.smalltalk.menu.StRadioButtonGroup
	 * @category Instance creation
	 */
	public StRadioButtonMenuItem(Object label, StSymbol nameKey, StRadioButtonGroup radioButtonGroup) {
		this(label, nameKey, radioButtonGroup, (MenuListener) null);
	}

	/**
	 * Create a new instance of StRadioButtonMenuItem and initialize it.
	 *
	 * @param label java.lang.Object
	 * @param nameKey jp.co.sra.smalltalk.StSymbol
	 * @param radioButtonGroup jp.co.sra.smalltalk.menu.StRadioButtonGroup
	 * @param menuListener jp.co.sra.smalltalk.menu.MenuListener
	 * @category Instance creation
	 */
	public StRadioButtonMenuItem(Object label, StSymbol nameKey, StRadioButtonGroup radioButtonGroup, MenuListener menuListener) {
		super(label);
		this.setNameKey_(nameKey);
		this.group_(radioButtonGroup);
		this.addMenuListener(menuListener);
	}

	/**
	 * Answer my current group.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StRadioButtonGroup
	 * @category accessing
	 */
	public StRadioButtonGroup group() {
		if (group == null) {
			group = StRadioButtonGroup.DefaultGroup;
		}
		return group;
	}

	/**
	 * Set my new group.
	 * 
	 * @param aGroup jp.co.sra.smalltalk.menu.StRadioButtonGroup
	 * @category accessing
	 */
	public void group_(StRadioButtonGroup aGroup) {
		this.group().remove(this);
		group = aGroup;
		this.group().add(this);
	}

	/**
	 * Set whether the receiver is to be selected or not.
	 * 
	 * @param aBoolean boolean
	 * @see jp.co.sra.smalltalk.menu.StCheckBoxMenuItem#beSelected(boolean)
	 * @category selection
	 */
	public void beSelected(boolean aBoolean) {
		boolean wasSelected = this.isSelected();

		super.beSelected(aBoolean);

		if (!wasSelected && this.isSelected()) {
			this.group().select(this);
		}
	}

	/**
	 * Create my default view.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StMenuItemView
	 * @category interface opening
	 */
	public StMenuItemView defaultView() {
		if (StApplicationModel.GetDefaultViewMode() == StApplicationModel.VIEW_AWT) {
			return new StRadioButtonMenuItemViewAwt(this);
		} else {
			return new StRadioButtonMenuItemViewSwing(this);
		}
	}

}