/* --------------------------------------------------------------------------
 *
 * This file was part of the "More for C++" library.
 * Copyright (c) 1999-2003 by Thorsten Goertz.
 * The "More for C++" library is free software; you can
 * redistribute it and/or modify it under the terms of the license
 * that comes with http://www.morefor.org/.
 *
 * ------------------------------------------------------------------------ */

#ifndef MORE_GC_HPP
#define MORE_GC_HPP

#include <cstdlib>
#include "glib/primitives/GObject.h"

class GC
{
public:

   class Adapter
   {
      protected:
         static void InitPointer( void**&, void*, /*Finalizable*/GObject* );
         static void AssignObject( void**&, void*, /*Finalizable*/GObject* );
         static void ForgetObject( void**& );
   };

   static void StartCollectorThread ();
   static void StopCollectorThread ();
   static int GetNoOfObjects ();

   /**
    * @author  Leif Erik Larsen
    * @since   2005.01.28
    * @force   True if we shall force one collection trip even if the 
    *          GC thread is currently active when this method is called.
    *          In that case we will wait until the GC thread is inactive,
    *          and then perform an explicit collection trip by the 
    *          calling thread.
    */
   static void CollectObjects ( bool force = false );
};

#endif
