/* --------------------------------------------------------------------------
 *
 * This file was part of the "More for C++" library.
 * Copyright (c) 1999-2003 by Thorsten Goertz.
 * The "More for C++" library is free software; you can
 * redistribute it and/or modify it under the terms of the license
 * that comes with http://www.morefor.org/.
 *
 * ------------------------------------------------------------------------ */

#ifndef GCIMPL_HPP
#define GCIMPL_HPP

#include "glib/GThread.h"
#include "glib/gc/heapmanager.h"
#include "glib/gc/aligningheapmanager.h"
#include "glib/gc/defaultheapmanager.h"
#include "glib/gc/handle.h"
#include "glib/gc/objectstack.h"
#include "glib/gc/pointer.h"

class GCImpl : public GObject
{
public:
   static void Init ( HeapManager& );
   static void ShutDown ();
   static void* CreateObject ( size_t nSizeOfObject, bool bMayBeNode );
   static bool IsRootPointer ( void** ppObject );
   static Handle* ResolveObject ( void* );
   static void InitPointer ( void**&, void*, GObject* );
   static void AssignObject ( void**&, void*, GObject*, bool bIsRootPointer );
   static void ForgetObject ( void**&, bool bIsRootPointer );
   static void ForgetUnassignedObject ( void* );
   static void StartCollectorThread ();
   static void StopCollectorThread ();
   static void DeclareObjectsTare ();
   static size_t GetNoOfObjects ();
   static void CollectObjects ( bool force = false );

private:
   void addObject ( Handle* );
   Handle* getLastObject () const;
   Handle* getPreviousObject ( Handle* ) const;
   void removeObject ( Handle* pObject, Handle* pNextObject );
   void markObjects ();
   void unmarkRootObjectTree ();
   void unmarkChildObjects ( Handle* pHandle );
   void finalizeMarkedObjects ();
   void sweepMarkedObjects ();
   void setNodeFlag ( Handle*, bool bObjectMayBeNode );
   bool objectMayBeNode ( Handle* ) const;
   void setGarbageFlag ( Handle*, bool bGarbage );
   bool objectIsGarbage ( Handle* pHandle ) const;

   static Handle NilHandle;

   class GCThread : public GThread
   {
   public:
      bool requestStop;
      GCThread ();
      virtual ~GCThread ();
      virtual void run ();
   private:
      /** Disable the copy constructor and assignment operator. */
      GCThread ( const GCThread& src ) {}
      GCThread& operator= ( const GCThread& ) { return *this; }
   };

   HeapManager* m_pHeapManager;
   Handle*      m_pLastObject;
   size_t       m_nNoOfObjects;
   size_t       m_nNoOfTareObjects;
   bool         m_bCollecting;
   ObjectStack* m_pMarkStack;
   p<GCThread>* m_ppCollectorThread;
};

#endif
