/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/gui/GComponentSize.h"
#include "glib/primitives/GString.h"

GComponentSize::GComponentSize ()
               :width(0),
                height(0)
{
}

GComponentSize::GComponentSize ( double width, double height )
               :width(width),
                height(height)
{
}

GComponentSize::GComponentSize ( const GComponentSize& src )
               :GObject(src),
                width(src.width),
                height(src.height)
{
}

GComponentSize::~GComponentSize ()
{
}

GComponentSize& GComponentSize::operator= ( const GComponentSize& src )
{
   this->width = src.width;
   this->height = src.height;
   return *this;
}

GString GComponentSize::toString () const
{
   GString str(16);
   str += '[';
   str += width;
   str += ',';
   str += height;
   str += ']';
   return str;
}

void GComponentSize::setSize ( double width, double height )
{
   this->width = width;
   this->height = height;
}


