/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "glib/gui/GContainerWindow.h"
#include "glib/gui/GDecoratedWindow.h"
#include "glib/gui/GGraphics.h"
#include "glib/gui/GScrollbar.h"

GContainerWindow::GContainerWindow ( const GString& name, 
                                     const GString& constraints, 
                                     GDecoratedWindow& client, 
                                     GWindow* parentWin, 
                                     bool visible )
                 :GWindow(name, 
                          constraints, 
                          parentWin, 
                          parentWin, 
                          visible ? WS_VISIBLE : 0,
                          WS2_OS2Y),
                  client(client)
{
}

GContainerWindow::~GContainerWindow ()
{
}

bool GContainerWindow::onPaint ( GGraphics& g, const GRectangle& /*rect*/ )
{
   if (client.isVScrollbarVisible() && client.isHScrollbarVisible())
   {
      int vbarWidth = GScrollbar::GetDefaultVScrollbarWidth();
      int hbarHeight = GScrollbar::GetDefaultHScrollbarHeight();
      GColor color = getBackgroundColor();
      GDimension dim = getWindowSize();
      GRectangle r(dim.width - vbarWidth, 0, vbarWidth, hbarHeight);
      g.drawFilledRectangle(r, color);
   }

   return true;
}

void GContainerWindow::layout ()
{
   GRectangle r = getWindowRect();
   int width = r.width;
   int height = r.height;

   // ---
   int scrbarw = client.vScrollbar->isVisible() ? GScrollbar::GetDefaultVScrollbarWidth() : 0;
   int scrbarh = client.hScrollbar->isVisible() ? GScrollbar::GetDefaultHScrollbarHeight() : 0;
   int fwleft = client.getFrameWLeft();
   int fwright = client.getFrameWRight();
   int fwbottom = client.getFrameWBottom();
   int fwtop = client.getFrameWTop();
   int clientw = width - scrbarw - fwleft - fwright;
   int clienth = height - scrbarh - fwbottom - fwtop;

   // Adjust the size and position of the horizontal scrollbar.
   GScrollbar& hsb = client.getHScrollbar();
   hsb.setWindowBounds(fwleft, fwbottom, clientw, scrbarh);

   // Adjust the size and position of the vertical scrollbar.
   GScrollbar& vsb = client.getVScrollbar();
   vsb.setWindowBounds(width - scrbarw - fwright, fwbottom + scrbarh, scrbarw, clienth);

   // Adjust the size and position of the Client Area Window.
   // This must be done in the context of GWindow, to prevent recursive calls.
   client.GWindow::setWindowBounds(fwleft, fwbottom + scrbarh, clientw, clienth);
}

GWindowMessage::Answer GContainerWindow::handleWindowMessage ( GWindowMessage& msg )
{
   switch (msg.getID())
   {
      case WM_HSCROLL: 
      case WM_VSCROLL: 
         // Reuse scrollbar event handling code in GDecoratedWindow.
         return client.handleWindowMessage(msg);

      default:
         return GWindow::handleWindowMessage(msg);
   }
}
